/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodProtoReference;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.writer.ProtoSection;
import org.jf.dexlib2.writer.builder.BuilderContext;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderMethodProtoReference;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

class BuilderProtoPool
implements ProtoSection<BuilderStringReference, BuilderTypeReference, BuilderMethodProtoReference, BuilderTypeList> {
    @Nonnull
    private final BuilderContext context;
    @Nonnull
    private final ConcurrentMap<MethodProtoReference, BuilderMethodProtoReference> internedItems = Maps.newConcurrentMap();

    BuilderProtoPool(@Nonnull BuilderContext context) {
        this.context = context;
    }

    @Nonnull
    public BuilderMethodProtoReference internMethodProto(@Nonnull MethodProtoReference methodProto) {
        BuilderMethodProtoReference ret = (BuilderMethodProtoReference)this.internedItems.get(methodProto);
        if (ret != null) {
            return ret;
        }
        BuilderMethodProtoReference protoReference = new BuilderMethodProtoReference(this.context.stringPool.internString(MethodUtil.getShorty(methodProto.getParameterTypes(), methodProto.getReturnType())), this.context.typeListPool.internTypeList(methodProto.getParameterTypes()), this.context.typePool.internType(methodProto.getReturnType()));
        ret = this.internedItems.putIfAbsent(protoReference, protoReference);
        return ret == null ? protoReference : ret;
    }

    @Nonnull
    public BuilderMethodProtoReference internMethodProto(@Nonnull MethodReference methodReference) {
        return this.internMethodProto(new ImmutableMethodProtoReference(methodReference.getParameterTypes(), methodReference.getReturnType()));
    }

    @Override
    @Nonnull
    public BuilderStringReference getShorty(@Nonnull BuilderMethodProtoReference proto) {
        return proto.shorty;
    }

    @Override
    @Nonnull
    public BuilderTypeReference getReturnType(@Nonnull BuilderMethodProtoReference proto) {
        return proto.returnType;
    }

    @Override
    @Nullable
    public BuilderTypeList getParameters(@Nonnull BuilderMethodProtoReference proto) {
        return proto.parameterTypes;
    }

    @Override
    public int getItemIndex(@Nonnull BuilderMethodProtoReference proto) {
        return proto.getIndex();
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderMethodProtoReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderMethodProtoReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderMethodProtoReference key) {
                return key.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderMethodProtoReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

