/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.pool.BaseIndexPool;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.PoolMethodProto;
import org.jf.dexlib2.writer.pool.ProtoPool;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypePool;

public class MethodPool
extends BaseIndexPool<MethodReference>
implements MethodSection<CharSequence, CharSequence, MethodProtoReference, MethodReference, PoolMethod> {
    @Nonnull
    private final StringPool stringPool;
    @Nonnull
    private final TypePool typePool;
    @Nonnull
    private final ProtoPool protoPool;

    public MethodPool(@Nonnull StringPool stringPool, @Nonnull TypePool typePool, @Nonnull ProtoPool protoPool) {
        this.stringPool = stringPool;
        this.typePool = typePool;
        this.protoPool = protoPool;
    }

    public void intern(@Nonnull MethodReference method) {
        Integer prev = this.internedItems.put(method, 0);
        if (prev == null) {
            this.typePool.intern(method.getDefiningClass());
            this.protoPool.intern(new PoolMethodProto(method));
            this.stringPool.intern(method.getName());
        }
    }

    @Override
    @Nonnull
    public CharSequence getDefiningClass(@Nonnull MethodReference methodReference) {
        return methodReference.getDefiningClass();
    }

    @Override
    @Nonnull
    public MethodProtoReference getPrototype(@Nonnull MethodReference methodReference) {
        return new PoolMethodProto(methodReference);
    }

    @Override
    @Nonnull
    public MethodProtoReference getPrototype(@Nonnull PoolMethod poolMethod) {
        return new PoolMethodProto(poolMethod);
    }

    @Override
    @Nonnull
    public CharSequence getName(@Nonnull MethodReference methodReference) {
        return methodReference.getName();
    }

    @Override
    public int getMethodIndex(@Nonnull PoolMethod poolMethod) {
        return this.getItemIndex(poolMethod);
    }
}

