/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.writer.ProtoSection;
import org.jf.dexlib2.writer.pool.BaseIndexPool;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.dexlib2.writer.pool.TypePool;

public class ProtoPool
extends BaseIndexPool<MethodProtoReference>
implements ProtoSection<CharSequence, CharSequence, MethodProtoReference, TypeListPool.Key<? extends Collection<? extends CharSequence>>> {
    @Nonnull
    private final StringPool stringPool;
    @Nonnull
    private final TypePool typePool;
    @Nonnull
    private final TypeListPool typeListPool;

    public ProtoPool(@Nonnull StringPool stringPool, @Nonnull TypePool typePool, @Nonnull TypeListPool typeListPool) {
        this.stringPool = stringPool;
        this.typePool = typePool;
        this.typeListPool = typeListPool;
    }

    public void intern(@Nonnull MethodProtoReference reference) {
        Integer prev = this.internedItems.put(reference, 0);
        if (prev == null) {
            this.stringPool.intern(this.getShorty(reference));
            this.typePool.intern(reference.getReturnType());
            this.typeListPool.intern(reference.getParameterTypes());
        }
    }

    @Override
    @Nonnull
    public CharSequence getShorty(@Nonnull MethodProtoReference reference) {
        return MethodUtil.getShorty(reference.getParameterTypes(), reference.getReturnType());
    }

    @Override
    @Nonnull
    public CharSequence getReturnType(@Nonnull MethodProtoReference protoReference) {
        return protoReference.getReturnType();
    }

    @Override
    @Nullable
    public TypeListPool.Key<List<? extends CharSequence>> getParameters(@Nonnull MethodProtoReference methodProto) {
        return new TypeListPool.Key<List<? extends CharSequence>>(methodProto.getParameterTypes());
    }
}

