/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.PatchingChain;
import soot.Printer;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.CodeAttribute;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.EscapedWriter;
import soot.util.HashChain;
import soot.validation.BodyValidator;
import soot.validation.CheckEscapingValidator;
import soot.validation.CheckInitValidator;
import soot.validation.CheckTypesValidator;
import soot.validation.CheckVoidLocalesValidator;
import soot.validation.LocalsValidator;
import soot.validation.TrapsValidator;
import soot.validation.UnitBoxesValidator;
import soot.validation.UsesValidator;
import soot.validation.ValidationException;
import soot.validation.ValueBoxesValidator;

public abstract class Body
extends AbstractHost
implements Serializable {
    protected transient SootMethod method = null;
    protected Chain<Local> localChain = new HashChain<Local>();
    protected Chain<Trap> trapChain = new HashChain<Trap>();
    protected PatchingChain<Unit> unitChain = new PatchingChain(new HashChain());
    private static BodyValidator[] validators;

    public abstract Object clone();

    private static synchronized BodyValidator[] getValidators() {
        if (validators == null) {
            validators = new BodyValidator[]{LocalsValidator.v(), TrapsValidator.v(), UnitBoxesValidator.v(), UsesValidator.v(), ValueBoxesValidator.v(), CheckTypesValidator.v(), CheckVoidLocalesValidator.v(), CheckEscapingValidator.v()};
        }
        return validators;
    }

    protected Body(SootMethod m) {
        this.method = m;
    }

    protected Body() {
    }

    public SootMethod getMethod() {
        if (this.method == null) {
            throw new RuntimeException("no method associated w/ body");
        }
        return this.method;
    }

    public void setMethod(SootMethod method) {
        this.method = method;
    }

    public int getLocalCount() {
        return this.localChain.size();
    }

    public Map<Object, Object> importBodyContentsFrom(Body b) {
        Object copy;
        HashMap<Object, Object> bindings = new HashMap<Object, Object>();
        for (Unit unit : b.getUnits()) {
            copy = (Unit)unit.clone();
            copy.addAllTagsOf(unit);
            this.unitChain.addLast((Unit)copy);
            bindings.put(unit, copy);
        }
        for (Trap trap : b.getTraps()) {
            copy = (Trap)trap.clone();
            this.trapChain.addLast((Trap)copy);
            bindings.put(trap, copy);
        }
        for (Local local : b.getLocals()) {
            copy = (Local)local.clone();
            this.localChain.addLast((Local)copy);
            bindings.put(local, copy);
        }
        for (UnitBox unitBox : this.getAllUnitBoxes()) {
            Unit oldObject = unitBox.getUnit();
            Unit newObject = (Unit)bindings.get(oldObject);
            if (newObject == null) continue;
            unitBox.setUnit(newObject);
        }
        for (ValueBox valueBox : this.getUseBoxes()) {
            if (!(valueBox.getValue() instanceof Local)) continue;
            valueBox.setValue((Value)bindings.get(valueBox.getValue()));
        }
        for (ValueBox valueBox : this.getDefBoxes()) {
            if (!(valueBox.getValue() instanceof Local)) continue;
            valueBox.setValue((Value)bindings.get(valueBox.getValue()));
        }
        return bindings;
    }

    protected void runValidation(BodyValidator validator) {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        validator.validate(this, exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    public void validate() {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        this.validate(exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    public void validate(List<ValidationException> exceptionList) {
        boolean runAllValidators = Options.v().debug() || Options.v().validate();
        for (BodyValidator validator : Body.getValidators()) {
            if (!validator.isBasicValidator() && !runAllValidators) continue;
            validator.validate(this, exceptionList);
        }
    }

    public void validateValueBoxes() {
        this.runValidation(ValueBoxesValidator.v());
    }

    public void validateLocals() {
        this.runValidation(LocalsValidator.v());
    }

    public void validateTraps() {
        this.runValidation(TrapsValidator.v());
    }

    public void validateUnitBoxes() {
        this.runValidation(UnitBoxesValidator.v());
    }

    public void validateUses() {
        this.runValidation(UsesValidator.v());
    }

    public Chain<Local> getLocals() {
        return this.localChain;
    }

    public Chain<Trap> getTraps() {
        return this.trapChain;
    }

    public Local getThisLocal() {
        for (Unit s : this.getUnits()) {
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ThisRef)) continue;
            return (Local)((IdentityStmt)s).getLeftOp();
        }
        throw new RuntimeException("couldn't find identityref! in " + this.getMethod());
    }

    public Local getParameterLocal(int i) {
        for (Unit s : this.getUnits()) {
            IdentityStmt is;
            ParameterRef pr;
            if (!(s instanceof IdentityStmt) || !(((IdentityStmt)s).getRightOp() instanceof ParameterRef) || (pr = (ParameterRef)(is = (IdentityStmt)s).getRightOp()).getIndex() != i) continue;
            return (Local)is.getLeftOp();
        }
        throw new RuntimeException("couldn't find parameterref" + i + "! in " + this.getMethod());
    }

    public List<Local> getParameterLocals() {
        int numParams = this.getMethod().getParameterCount();
        ArrayList<Local> retVal = new ArrayList<Local>(numParams);
        for (Unit u : this.getUnits()) {
            IdentityStmt is;
            if (!(u instanceof IdentityStmt) || !((is = (IdentityStmt)u).getRightOp() instanceof ParameterRef)) continue;
            ParameterRef pr = (ParameterRef)is.getRightOp();
            retVal.add(pr.getIndex(), (Local)is.getLeftOp());
        }
        if (retVal.size() != numParams) {
            throw new RuntimeException("couldn't find parameterref! in " + this.getMethod());
        }
        return retVal;
    }

    public List<Value> getParameterRefs() {
        Value[] res = new Value[this.getMethod().getParameterCount()];
        for (Unit s : this.getUnits()) {
            Value rightOp;
            if (!(s instanceof IdentityStmt) || !((rightOp = ((IdentityStmt)s).getRightOp()) instanceof ParameterRef)) continue;
            ParameterRef parameterRef = (ParameterRef)rightOp;
            res[parameterRef.getIndex()] = parameterRef;
        }
        return Arrays.asList(res);
    }

    public PatchingChain<Unit> getUnits() {
        return this.unitChain;
    }

    public List<UnitBox> getAllUnitBoxes() {
        ArrayList<UnitBox> unitBoxList = new ArrayList<UnitBox>();
        for (Unit unit : this.unitChain) {
            unitBoxList.addAll(unit.getUnitBoxes());
        }
        for (Trap trap : this.trapChain) {
            unitBoxList.addAll(trap.getUnitBoxes());
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)tag).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List<UnitBox> getUnitBoxes(boolean branchTarget) {
        ArrayList<UnitBox> unitBoxList = new ArrayList<UnitBox>();
        for (Unit unit : this.unitChain) {
            if (branchTarget) {
                if (!unit.branches()) continue;
                unitBoxList.addAll(unit.getUnitBoxes());
                continue;
            }
            if (unit.branches()) continue;
            unitBoxList.addAll(unit.getUnitBoxes());
        }
        for (Trap trap : this.trapChain) {
            unitBoxList.addAll(trap.getUnitBoxes());
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)tag).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> useBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            useBoxList.addAll(item.getUseBoxes());
        }
        return useBoxList;
    }

    public List<ValueBox> getDefBoxes() {
        ArrayList<ValueBox> defBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            defBoxList.addAll(item.getDefBoxes());
        }
        return defBoxList;
    }

    public List<ValueBox> getUseAndDefBoxes() {
        ArrayList<ValueBox> useAndDefBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            useAndDefBoxList.addAll(item.getUseBoxes());
            useAndDefBoxList.addAll(item.getDefBoxes());
        }
        return useAndDefBoxList;
    }

    public void checkInit() {
        this.runValidation(CheckInitValidator.v());
    }

    public String toString() {
        ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
        PrintWriter writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));
        try {
            Printer.v().printTo(this, writerOut);
        }
        catch (RuntimeException e) {
            e.printStackTrace(writerOut);
        }
        writerOut.flush();
        writerOut.close();
        return streamOut.toString();
    }

    public long getModificationCount() {
        return this.localChain.getModificationCount() + this.unitChain.getModificationCount() + this.trapChain.getModificationCount();
    }
}

