/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import soot.ClassProvider;
import soot.ClassSource;
import soot.DexClassSource;
import soot.G;
import soot.Scene;
import soot.SourceLocator;
import soot.dexpler.Util;
import soot.options.Options;

public class DexClassProvider
implements ClassProvider {
    @Override
    public ClassSource find(String className) {
        File file;
        Map<String, File> index = SourceLocator.v().dexClassIndex();
        if (index == null) {
            index = new HashMap<String, File>();
            this.buildDexIndex(index, SourceLocator.v().classPath());
            SourceLocator.v().setDexClassIndex(index);
        }
        if ((file = index.get(className)) == null) {
            return null;
        }
        return new DexClassSource(className, file);
    }

    private List<File> getAllDexFiles(String path) {
        ArrayDeque<File> toVisit = new ArrayDeque<File>();
        HashSet<File> visited = new HashSet<File>();
        ArrayList<File> ret = new ArrayList<File>();
        toVisit.add(new File(path));
        while (!toVisit.isEmpty()) {
            File cur = (File)toVisit.poll();
            if (visited.contains(cur)) continue;
            visited.add(cur);
            if (cur.isDirectory()) {
                toVisit.addAll(Arrays.asList(cur.listFiles()));
                continue;
            }
            if (!cur.isFile() || !cur.getName().endsWith(".dex")) continue;
            ret.add(cur);
        }
        return ret;
    }

    private void buildDexIndex(Map<String, File> index, List<String> classPath) {
        for (String path : classPath) {
            List<File> allDexFiles = this.getAllDexFiles(path);
            if (!allDexFiles.isEmpty()) {
                for (File dexFile : allDexFiles) {
                    this.readDexFile(index, dexFile);
                }
                continue;
            }
            File file = new File(path);
            if (!file.isFile() || !file.getName().endsWith(".apk") && !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
            HashSet<String> entryNames = new HashSet<String>();
            ZipFile archive = null;
            try {
                archive = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".dex")) continue;
                    entryNames.add(entryName);
                    if (Options.v().process_multiple_dex()) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (archive != null) {
                        archive.close();
                        archive = null;
                    }
                }
                catch (Throwable throwable) {}
            }
            if (entryNames.isEmpty()) continue;
            if (Options.v().process_multiple_dex()) {
                for (String entryName : entryNames) {
                    this.readDexFile(index, file, entryName);
                }
                continue;
            }
            this.readDexFile(index, file);
        }
    }

    private void readDexFile(Map<String, File> index, File dex) {
        try {
            for (String className : DexClassProvider.classesOfDex(dex)) {
                index.put(className, dex);
            }
        }
        catch (IOException e) {
            G.v().out.println("Warning: IO error while processing dex file '" + dex + "'");
            G.v().out.println("Exception: " + e);
        }
        catch (Exception e) {
            G.v().out.println("Warning: exception while processing dex file '" + dex + "'");
            G.v().out.println("Exception: " + e);
        }
    }

    private void readDexFile(Map<String, File> index, File dex, String dexName) {
        try {
            for (String className : DexClassProvider.classesOfDex(dex, dexName)) {
                index.put(className, dex);
            }
        }
        catch (IOException e) {
            G.v().out.println("Warning: IO error while processing dex file '" + dex + "'");
            G.v().out.println("Exception: " + e);
        }
        catch (Exception e) {
            G.v().out.println("Warning: exception while processing dex file '" + dex + "'");
            G.v().out.println("Exception: " + e);
        }
    }

    public static Set<String> classesOfDex(File file) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        int api = Scene.v().getAndroidAPIVersion();
        DexBackedDexFile d = DexFileFactory.loadDexFile(file, Opcodes.forApi(api));
        for (ClassDef classDef : d.getClasses()) {
            String name = Util.dottedClassName(classDef.getType());
            classes.add(name);
        }
        return classes;
    }

    public static Set<String> classesOfDex(File file, String dexName) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        int api = Scene.v().getAndroidAPIVersion();
        DexBackedDexFile d = DexFileFactory.loadDexEntry(file, dexName, true, Opcodes.forApi(api));
        for (ClassDef classDef : d.getClasses()) {
            String name = Util.dottedClassName(classDef.getType());
            classes.add(name);
        }
        return classes;
    }
}

