/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.ClassMember;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.util.ArraySet;
import soot.util.Chain;

public class Hierarchy {
    private Map<SootClass, List<SootClass>> classToSubclasses;
    private Map<SootClass, List<SootClass>> interfaceToSubinterfaces;
    private Map<SootClass, List<SootClass>> interfaceToSuperinterfaces;
    private Map<SootClass, List<SootClass>> classToDirSubclasses;
    private Map<SootClass, List<SootClass>> interfaceToDirSubinterfaces;
    private Map<SootClass, List<SootClass>> interfaceToDirSuperinterfaces;
    private Map<SootClass, List<SootClass>> interfaceToDirImplementers;
    int state;
    Scene sc = Scene.v();

    public Hierarchy() {
        this.state = this.sc.getState();
        Chain<SootClass> allClasses = this.sc.getClasses();
        this.classToSubclasses = new HashMap<SootClass, List<SootClass>>(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToSubinterfaces = new HashMap<SootClass, List<SootClass>>(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToSuperinterfaces = new HashMap<SootClass, List<SootClass>>(allClasses.size() * 2 + 1, 0.7f);
        this.classToDirSubclasses = new HashMap<SootClass, List<SootClass>>(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToDirSubinterfaces = new HashMap<SootClass, List<SootClass>>(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToDirSuperinterfaces = new HashMap<SootClass, List<SootClass>>(allClasses.size() * 2 + 1, 0.7f);
        this.interfaceToDirImplementers = new HashMap<SootClass, List<SootClass>>(allClasses.size() * 2 + 1, 0.7f);
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1) continue;
            if (c.isInterface()) {
                this.interfaceToDirSubinterfaces.put(c, new ArrayList());
                this.interfaceToDirSuperinterfaces.put(c, new ArrayList());
                this.interfaceToDirImplementers.put(c, new ArrayList());
                continue;
            }
            this.classToDirSubclasses.put(c, new ArrayList());
        }
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1 || !c.hasSuperclass()) continue;
            if (c.isInterface()) {
                List<SootClass> l2 = this.interfaceToDirSuperinterfaces.get(c);
                for (SootClass i : c.getInterfaces()) {
                    if (c.resolvingLevel() < 1) continue;
                    List<SootClass> l = this.interfaceToDirSubinterfaces.get(i);
                    if (l != null) {
                        l.add(c);
                    }
                    if (l2 == null) continue;
                    l2.add(i);
                }
                continue;
            }
            List<SootClass> l = this.classToDirSubclasses.get(c.getSuperclass());
            if (l != null) {
                l.add(c);
            }
            for (SootClass i : c.getInterfaces()) {
                if (c.resolvingLevel() < 1 || (l = this.interfaceToDirImplementers.get(i)) == null) continue;
                l.add(c);
            }
        }
        for (SootClass c : allClasses) {
            if (c.resolvingLevel() < 1 || !c.isInterface()) continue;
            List<SootClass> imp = this.interfaceToDirImplementers.get(c);
            ArraySet<SootClass> s = new ArraySet<SootClass>();
            for (SootClass c0 : imp) {
                if (c.resolvingLevel() < 1) continue;
                s.addAll(this.getSubclassesOfIncluding(c0));
            }
            imp.clear();
            imp.addAll(s);
        }
    }

    private void checkState() {
        if (this.state != this.sc.getState()) {
            throw new ConcurrentModificationException("Scene changed for Hierarchy!");
        }
    }

    public List<SootClass> getSubclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.getSubclassesOf(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSubclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        if (this.classToSubclasses.get(c) != null) {
            return this.classToSubclasses.get(c);
        }
        ArrayList<SootClass> l = new ArrayList();
        for (SootClass cls : this.classToDirSubclasses.get(c)) {
            if (cls.resolvingLevel() < 1) continue;
            l.addAll(this.getSubclassesOfIncluding(cls));
        }
        l = Collections.unmodifiableList(l);
        this.classToSubclasses.put(c, l);
        return l;
    }

    public List<SootClass> getSuperclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        List<SootClass> l = this.getSuperclassesOf(c);
        ArrayList<SootClass> al = new ArrayList<SootClass>();
        al.add(c);
        al.addAll(l);
        return Collections.unmodifiableList(al);
    }

    public List<SootClass> getSuperclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        SootClass cl = c;
        while (cl.hasSuperclass()) {
            l.add(cl.getSuperclass());
            cl = cl.getSuperclass();
        }
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSubinterfacesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.getSubinterfacesOf(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSubinterfacesOf(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        if (this.interfaceToSubinterfaces.get(c) != null) {
            return this.interfaceToSubinterfaces.get(c);
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        for (SootClass si : this.interfaceToDirSubinterfaces.get(c)) {
            l.addAll(this.getSubinterfacesOfIncluding(si));
        }
        this.interfaceToSubinterfaces.put(c, Collections.unmodifiableList(l));
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSuperinterfacesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(this.getSuperinterfacesOf(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getSuperinterfacesOf(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        List<SootClass> cached = this.interfaceToSuperinterfaces.get(c);
        if (cached != null) {
            return cached;
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        for (SootClass si : this.interfaceToDirSuperinterfaces.get(c)) {
            l.addAll(this.getSuperinterfacesOfIncluding(si));
        }
        this.interfaceToSuperinterfaces.put(c, Collections.unmodifiableList(l));
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getDirectSuperclassesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List<SootClass> getDirectSubclassesOf(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        return Collections.unmodifiableList(this.classToDirSubclasses.get(c));
    }

    public List<SootClass> getDirectSubclassesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (c.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll((Collection)this.classToDirSubclasses.get(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getDirectSuperinterfacesOf(SootClass c) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List<SootClass> getDirectSubinterfacesOf(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        return this.interfaceToDirSubinterfaces.get(c);
    }

    public List<SootClass> getDirectSubinterfacesOfIncluding(SootClass c) {
        c.checkLevel(1);
        if (!c.isInterface()) {
            throw new RuntimeException("interface needed!");
        }
        this.checkState();
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll((Collection)this.interfaceToDirSubinterfaces.get(c));
        l.add(c);
        return Collections.unmodifiableList(l);
    }

    public List<SootClass> getDirectImplementersOf(SootClass i) {
        i.checkLevel(1);
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed; got " + i);
        }
        this.checkState();
        return Collections.unmodifiableList(this.interfaceToDirImplementers.get(i));
    }

    public List<SootClass> getImplementersOf(SootClass i) {
        i.checkLevel(1);
        if (!i.isInterface()) {
            throw new RuntimeException("interface needed; got " + i);
        }
        this.checkState();
        ArraySet<SootClass> set = new ArraySet<SootClass>();
        for (SootClass c : this.getSubinterfacesOfIncluding(i)) {
            set.addAll(this.getDirectImplementersOf(c));
        }
        ArrayList<SootClass> l = new ArrayList<SootClass>();
        l.addAll(set);
        return Collections.unmodifiableList(l);
    }

    public boolean isClassSubclassOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        List<SootClass> parentClasses = this.getSuperclassesOf(child);
        if (parentClasses.contains(possibleParent)) {
            return true;
        }
        for (SootClass sc : parentClasses) {
            if (!sc.isPhantom()) continue;
            return true;
        }
        return false;
    }

    public boolean isClassSubclassOfIncluding(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        List<SootClass> parentClasses = this.getSuperclassesOfIncluding(child);
        if (parentClasses.contains(possibleParent)) {
            return true;
        }
        for (SootClass sc : parentClasses) {
            if (!sc.isPhantom()) continue;
            return true;
        }
        return false;
    }

    public boolean isClassDirectSubclassOf(SootClass c, SootClass c2) {
        throw new RuntimeException("Not implemented yet!");
    }

    public boolean isClassSuperclassOf(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSubclassesOf(parent).contains(possibleChild);
    }

    public boolean isClassSuperclassOfIncluding(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSubclassesOfIncluding(parent).contains(possibleChild);
    }

    public boolean isInterfaceSubinterfaceOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getSubinterfacesOf(possibleParent).contains(child);
    }

    public boolean isInterfaceDirectSubinterfaceOf(SootClass child, SootClass possibleParent) {
        child.checkLevel(1);
        possibleParent.checkLevel(1);
        return this.getDirectSubinterfacesOf(possibleParent).contains(child);
    }

    public boolean isInterfaceSuperinterfaceOf(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getSuperinterfacesOf(possibleChild).contains(parent);
    }

    public boolean isInterfaceDirectSuperinterfaceOf(SootClass parent, SootClass possibleChild) {
        parent.checkLevel(1);
        possibleChild.checkLevel(1);
        return this.getDirectSuperinterfacesOf(possibleChild).contains(parent);
    }

    public SootClass getLeastCommonSuperclassOf(SootClass c1, SootClass c2) {
        c1.checkLevel(1);
        c2.checkLevel(1);
        throw new RuntimeException("Not implemented yet!");
    }

    public boolean isVisible(SootClass from, SootClass check) {
        if (check.isPublic()) {
            return true;
        }
        if (check.isProtected() || check.isPrivate()) {
            return false;
        }
        return from.getJavaPackageName().equals(check.getJavaPackageName());
    }

    public boolean isVisible(SootClass from, ClassMember m) {
        from.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        if (!this.isVisible(from, m.getDeclaringClass())) {
            return false;
        }
        if (m.isPublic()) {
            return true;
        }
        if (m.isPrivate()) {
            return from.equals(m.getDeclaringClass());
        }
        if (m.isProtected()) {
            return this.isClassSubclassOfIncluding(from, m.getDeclaringClass());
        }
        return from.getJavaPackageName().equals(m.getDeclaringClass().getJavaPackageName());
    }

    public SootMethod resolveConcreteDispatch(SootClass concreteType, SootMethod m) {
        concreteType.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        if (concreteType.isInterface()) {
            throw new RuntimeException("class needed!");
        }
        String methodSig = m.getSubSignature();
        for (SootClass c : this.getSuperclassesOfIncluding(concreteType)) {
            SootMethod sm = c.getMethodUnsafe(methodSig);
            if (sm == null || !this.isVisible(c, m)) continue;
            return sm;
        }
        throw new RuntimeException("could not resolve concrete dispatch!\nType: " + concreteType + "\nMethod: " + m);
    }

    public List<SootMethod> resolveConcreteDispatch(List<Type> classes, SootMethod m) {
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        for (Type cls : classes) {
            if (cls instanceof RefType) {
                s.add(this.resolveConcreteDispatch(((RefType)cls).getSootClass(), m));
                continue;
            }
            if (cls instanceof ArrayType) {
                s.add(this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m));
                continue;
            }
            throw new RuntimeException("Unable to resolve concrete dispatch of type " + cls);
        }
        return Collections.unmodifiableList(new ArrayList(s));
    }

    public List<SootMethod> resolveAbstractDispatch(SootClass c, SootMethod m) {
        Collection<SootClass> classesIt;
        c.checkLevel(1);
        m.getDeclaringClass().checkLevel(1);
        this.checkState();
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        if (c.isInterface()) {
            HashSet<SootClass> classes = new HashSet<SootClass>();
            for (SootClass sootClass : this.getImplementersOf(c)) {
                classes.addAll(this.getSubclassesOfIncluding(sootClass));
            }
            classesIt = classes;
        } else {
            classesIt = this.getSubclassesOfIncluding(c);
        }
        for (SootClass cl : classesIt) {
            if (Modifier.isAbstract(cl.getModifiers())) continue;
            s.add(this.resolveConcreteDispatch(cl, m));
        }
        return Collections.unmodifiableList(new ArrayList(s));
    }

    public List<SootMethod> resolveAbstractDispatch(List<SootClass> classes, SootMethod m) {
        m.getDeclaringClass().checkLevel(1);
        ArraySet<SootMethod> s = new ArraySet<SootMethod>();
        for (SootClass sootClass : classes) {
            s.addAll(this.resolveAbstractDispatch(sootClass, m));
        }
        return Collections.unmodifiableList(new ArrayList(s));
    }

    public SootMethod resolveSpecialDispatch(SpecialInvokeExpr ie, SootMethod container2) {
        container2.getDeclaringClass().checkLevel(1);
        SootMethod target = ie.getMethod();
        target.getDeclaringClass().checkLevel(1);
        if ("<init>".equals(target.getName()) || target.isPrivate()) {
            return target;
        }
        if (this.isClassSubclassOf(target.getDeclaringClass(), container2.getDeclaringClass())) {
            return this.resolveConcreteDispatch(container2.getDeclaringClass(), target);
        }
        return target;
    }
}

