/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.DoubleLiteral;
import soot.JastAddJ.FloatingPointLiteral;
import soot.JastAddJ.IllegalLiteral;
import soot.JastAddJ.IntegerLiteral;
import soot.JastAddJ.Literal;
import soot.JastAddJ.LongLiteral;
import soot.JastAddJ.TypeDecl;

public class NumericLiteral
extends Literal
implements Cloneable {
    public static final int DECIMAL = 0;
    public static final int HEXADECIMAL = 1;
    public static final int OCTAL = 2;
    public static final int BINARY = 3;
    protected String digits = "";
    protected int kind = 0;
    private StringBuffer buf = new StringBuffer();
    private int idx = 0;
    private boolean whole;
    private boolean fraction;
    private boolean exponent;
    private boolean floating;
    private boolean isFloat;
    private boolean isLong;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public NumericLiteral clone() throws CloneNotSupportedException {
        NumericLiteral node = (NumericLiteral)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public NumericLiteral copy() {
        try {
            NumericLiteral node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public NumericLiteral fullCopy() {
        NumericLiteral tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public void setDigits(String digits) {
        this.digits = digits;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    private String name() {
        String name;
        switch (this.kind) {
            case 0: {
                name = "decimal";
                break;
            }
            case 1: {
                name = "hexadecimal";
                break;
            }
            case 2: {
                name = "octal";
                break;
            }
            default: {
                name = "binary";
            }
        }
        if (this.floating) {
            return name + " floating point";
        }
        return name;
    }

    private void pushChar() {
        this.buf.append(this.getLITERAL().charAt(this.idx++));
    }

    private void skip(int n) {
        this.idx += n;
    }

    private boolean have(int n) {
        return this.getLITERAL().length() >= this.idx + n;
    }

    private char peek(int n) {
        return this.getLITERAL().charAt(this.idx + n);
    }

    private static final boolean isDecimalDigit(char c) {
        return c == '_' || c >= '0' && c <= '9';
    }

    private static final boolean isHexadecimalDigit(char c) {
        return c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static final boolean isBinaryDigit(char c) {
        return c == '_' || c == '0' || c == '1';
    }

    private static final boolean isUnderscore(char c) {
        return c == '_';
    }

    public Literal parse() {
        if (this.getLITERAL().length() == 0) {
            throw new IllegalStateException("Empty NumericLiteral");
        }
        this.kind = this.classifyLiteral();
        Literal literal = !this.floating ? this.parseDigits() : this.parseFractionPart();
        literal.setStart(this.LITERALstart);
        literal.setEnd(this.LITERALend);
        return literal;
    }

    private int classifyLiteral() {
        if (this.peek(0) == '.') {
            this.floating = true;
            return 0;
        }
        if (this.peek(0) == '0') {
            if (!this.have(2)) {
                return 0;
            }
            if (this.peek(1) == 'x' || this.peek(1) == 'X') {
                this.skip(2);
                return 1;
            }
            if (this.peek(1) == 'b' || this.peek(1) == 'B') {
                this.skip(2);
                return 3;
            }
            return 0;
        }
        return 0;
    }

    private boolean misplacedUnderscore() {
        if (this.idx == 0 || this.idx + 1 == this.getLITERAL().length()) {
            return true;
        }
        switch (this.kind) {
            case 0: {
                return !NumericLiteral.isDecimalDigit(this.peek(-1)) || !NumericLiteral.isDecimalDigit(this.peek(1));
            }
            case 1: {
                return !NumericLiteral.isHexadecimalDigit(this.peek(-1)) || !NumericLiteral.isHexadecimalDigit(this.peek(1));
            }
            case 3: {
                return !NumericLiteral.isBinaryDigit(this.peek(-1)) || !NumericLiteral.isBinaryDigit(this.peek(1));
            }
        }
        throw new IllegalStateException("Unexpected literal kind");
    }

    private Literal syntaxError(String msg) {
        String err = "in " + this.name() + " literal " + "\"" + this.getLITERAL() + "\"" + ": " + msg;
        return new IllegalLiteral(err);
    }

    private Literal unexpectedCharacter(char c) {
        return this.syntaxError("unexpected character '" + c + "'; not a valid digit");
    }

    private String getLiteralString() {
        return this.buf.toString().toLowerCase();
    }

    private Literal buildLiteral() {
        NumericLiteral literal;
        this.setDigits(this.buf.toString().toLowerCase());
        if (!this.floating) {
            if (!this.whole) {
                return this.syntaxError("at least one digit is required");
            }
            if (this.kind == 0 && this.digits.charAt(0) == '0') {
                this.kind = 2;
                for (int idx = 1; idx < this.digits.length(); ++idx) {
                    char c = this.digits.charAt(idx);
                    if (c >= '0' && c <= '7') continue;
                    return this.unexpectedCharacter(c);
                }
            }
            literal = this.isLong ? new LongLiteral(this.getLITERAL()) : new IntegerLiteral(this.getLITERAL());
        } else {
            if (this.kind == 1 && !this.exponent) {
                return this.syntaxError("exponent is required");
            }
            if (!this.whole && !this.fraction) {
                return this.syntaxError("at least one digit is required in either the whole or fraction part");
            }
            if (this.kind == 1) {
                this.digits = "0x" + this.digits;
            }
            literal = this.isFloat ? new FloatingPointLiteral(this.getLITERAL()) : new DoubleLiteral(this.getLITERAL());
        }
        literal.setDigits(this.getDigits());
        literal.setKind(this.getKind());
        return literal;
    }

    private Literal parseDigits() {
        block12: while (this.have(1)) {
            char c = this.peek(0);
            switch (c) {
                case '_': {
                    if (this.misplacedUnderscore()) {
                        return this.syntaxError("misplaced underscore - underscores may only be used within sequences of digits");
                    }
                    this.skip(1);
                    continue block12;
                }
                case '.': {
                    if (this.kind != 0 && this.kind != 1) {
                        return this.unexpectedCharacter(c);
                    }
                    return this.parseFractionPart();
                }
                case 'L': 
                case 'l': {
                    if (this.have(2)) {
                        return this.syntaxError("extra digits/characters after suffix " + c);
                    }
                    this.isLong = true;
                    this.skip(1);
                    continue block12;
                }
                case 'F': 
                case 'f': {
                    if (this.kind == 3) {
                        return this.unexpectedCharacter(c);
                    }
                    this.isFloat = true;
                }
                case 'D': 
                case 'd': {
                    if (this.kind == 3) {
                        return this.unexpectedCharacter(c);
                    }
                    if (this.kind != 1) {
                        if (this.have(2)) {
                            return this.syntaxError("extra digits/characters after type suffix " + c);
                        }
                        this.floating = true;
                        this.skip(1);
                        continue block12;
                    }
                    this.whole = true;
                    this.pushChar();
                    continue block12;
                }
            }
            switch (this.kind) {
                case 0: {
                    if (c == 'e' || c == 'E') {
                        return this.parseExponentPart();
                    }
                    if (c == 'f' || c == 'F') {
                        if (this.have(2)) {
                            return this.syntaxError("extra digits/characters after type suffix " + c);
                        }
                        this.floating = true;
                        this.isFloat = true;
                        this.skip(1);
                        continue block12;
                    }
                    if (c == 'd' || c == 'D') {
                        if (this.have(2)) {
                            return this.syntaxError("extra digits/characters after type suffix " + c);
                        }
                        this.floating = true;
                        this.skip(1);
                        continue block12;
                    }
                    if (!NumericLiteral.isDecimalDigit(c)) {
                        return this.unexpectedCharacter(c);
                    }
                    this.whole = true;
                    this.pushChar();
                    continue block12;
                }
                case 1: {
                    if (c == 'p' || c == 'P') {
                        return this.parseExponentPart();
                    }
                    if (!NumericLiteral.isHexadecimalDigit(c)) {
                        return this.unexpectedCharacter(c);
                    }
                    this.whole = true;
                    this.pushChar();
                    continue block12;
                }
                case 3: {
                    if (!NumericLiteral.isBinaryDigit(c)) {
                        return this.unexpectedCharacter(c);
                    }
                    this.whole = true;
                    this.pushChar();
                    continue block12;
                }
            }
        }
        return this.buildLiteral();
    }

    private Literal parseFractionPart() {
        this.floating = true;
        this.pushChar();
        block4: while (this.have(1)) {
            char c = this.peek(0);
            switch (c) {
                case '_': {
                    if (this.misplacedUnderscore()) {
                        return this.syntaxError("misplaced underscore - underscores may only be used as separators within sequences of valid digits");
                    }
                    this.skip(1);
                    continue block4;
                }
                case '.': {
                    return this.syntaxError("multiple decimal periods are not allowed");
                }
            }
            if (this.kind == 0) {
                if (c == 'e' || c == 'E') {
                    return this.parseExponentPart();
                }
                if (c == 'f' || c == 'F') {
                    if (this.have(2)) {
                        return this.syntaxError("extra digits/characters after type suffix " + c);
                    }
                    this.floating = true;
                    this.isFloat = true;
                    this.skip(1);
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    if (this.have(2)) {
                        return this.syntaxError("extra digits/characters after type suffix " + c);
                    }
                    this.floating = true;
                    this.skip(1);
                    continue;
                }
                if (!NumericLiteral.isDecimalDigit(c)) {
                    return this.unexpectedCharacter(c);
                }
                this.pushChar();
                this.fraction = true;
                continue;
            }
            if (c == 'p' || c == 'P') {
                return this.parseExponentPart();
            }
            if (!NumericLiteral.isHexadecimalDigit(c)) {
                return this.unexpectedCharacter(c);
            }
            this.fraction = true;
            this.pushChar();
        }
        return this.buildLiteral();
    }

    private Literal parseExponentPart() {
        this.floating = true;
        this.pushChar();
        if (this.have(1) && (this.peek(0) == '+' || this.peek(0) == '-')) {
            this.pushChar();
        }
        block8: while (this.have(1)) {
            char c = this.peek(0);
            switch (c) {
                case '_': {
                    if (this.misplacedUnderscore()) {
                        return this.syntaxError("misplaced underscore - underscores may only be used as separators within sequences of valid digits");
                    }
                    this.skip(1);
                    continue block8;
                }
                case '+': 
                case '-': {
                    return this.syntaxError("exponent sign character is only allowed as the first character of the exponent part of a floating point literal");
                }
                case '.': {
                    return this.syntaxError("multiple decimal periods are not allowed");
                }
                case 'P': 
                case 'p': {
                    return this.syntaxError("multiple exponent specifiers are not allowed");
                }
                case 'F': 
                case 'f': {
                    this.isFloat = true;
                }
                case 'D': 
                case 'd': {
                    if (this.have(2)) {
                        return this.syntaxError("extra digits/characters after type suffix " + c);
                    }
                    this.skip(1);
                    continue block8;
                }
            }
            if (!NumericLiteral.isDecimalDigit(c)) {
                return this.unexpectedCharacter(c);
            }
            this.pushChar();
            this.exponent = true;
        }
        return this.buildLiteral();
    }

    public NumericLiteral() {
    }

    @Override
    public void init$Children() {
    }

    public NumericLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public NumericLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol2.value;
        this.LITERALstart = symbol2.getStart();
        this.LITERALend = symbol2.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public long parseLong() {
        ASTNode$State state = this.state();
        switch (this.getKind()) {
            case 1: {
                return this.parseLongHexadecimal();
            }
            case 2: {
                return this.parseLongOctal();
            }
            case 3: {
                return this.parseLongBinary();
            }
        }
        return this.parseLongDecimal();
    }

    public long parseLongHexadecimal() {
        int i;
        ASTNode$State state = this.state();
        long val = 0L;
        if (this.digits.length() > 16) {
            for (i = 0; i < this.digits.length() - 16; ++i) {
                if (this.digits.charAt(i) == '0') continue;
                throw new NumberFormatException("");
            }
        }
        for (i = 0; i < this.digits.length(); ++i) {
            int c = this.digits.charAt(i);
            c = c >= 97 && c <= 102 ? c - 97 + 10 : (c -= 48);
            val = val * 16L + (long)c;
        }
        return val;
    }

    public long parseLongOctal() {
        int i;
        ASTNode$State state = this.state();
        long val = 0L;
        if (this.digits.length() > 21) {
            for (i = 0; i < this.digits.length() - 21; ++i) {
                if (!(i == this.digits.length() - 21 - 1 ? this.digits.charAt(i) != '0' && this.digits.charAt(i) != '1' : this.digits.charAt(i) != '0')) continue;
                throw new NumberFormatException("");
            }
        }
        for (i = 0; i < this.digits.length(); ++i) {
            int c = this.digits.charAt(i) - 48;
            val = val * 8L + (long)c;
        }
        return val;
    }

    public long parseLongBinary() {
        int i;
        ASTNode$State state = this.state();
        long val = 0L;
        if (this.digits.length() > 64) {
            for (i = 0; i < this.digits.length() - 64; ++i) {
                if (this.digits.charAt(i) == '0') continue;
                throw new NumberFormatException("");
            }
        }
        for (i = 0; i < this.digits.length(); ++i) {
            if (this.digits.charAt(i) != '1') continue;
            val |= 1L << this.digits.length() - i - 1;
        }
        return val;
    }

    public long parseLongDecimal() {
        ASTNode$State state = this.state();
        long val = 0L;
        long prev = 0L;
        for (int i = 0; i < this.digits.length(); ++i) {
            boolean negMinValue;
            prev = val;
            int c = this.digits.charAt(i);
            if (c < 48 || c > 57) {
                throw new NumberFormatException("");
            }
            val = val * 10L + (long)(c -= 48);
            if (val >= prev) continue;
            boolean bl = negMinValue = i == this.digits.length() - 1 && this.isNegative() && val == Long.MIN_VALUE;
            if (negMinValue) continue;
            throw new NumberFormatException("");
        }
        if (val == Long.MIN_VALUE) {
            return val;
        }
        if (val < 0L) {
            throw new NumberFormatException("");
        }
        return this.isNegative() ? -val : val;
    }

    public boolean needsRewrite() {
        ASTNode$State state = this.state();
        return true;
    }

    public boolean isNegative() {
        ASTNode$State state = this.state();
        return this.getLITERAL().charAt(0) == '-';
    }

    public String getDigits() {
        ASTNode$State state = this.state();
        return this.digits;
    }

    public int getKind() {
        ASTNode$State state = this.state();
        return this.kind;
    }

    public int getRadix() {
        ASTNode$State state = this.state();
        switch (this.kind) {
            case 1: {
                return 16;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 2;
            }
        }
        return 10;
    }

    public boolean isDecimal() {
        ASTNode$State state = this.state();
        return this.kind == 0;
    }

    public boolean isHex() {
        ASTNode$State state = this.state();
        return this.kind == 1;
    }

    public boolean isOctal() {
        ASTNode$State state = this.state();
        return this.kind == 2;
    }

    public boolean isBinary() {
        ASTNode$State state = this.state();
        return this.kind == 3;
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.unknownType();
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.needsRewrite()) {
            ++this.state().duringLiterals;
            Literal result = this.rewriteRule0();
            --this.state().duringLiterals;
            return result;
        }
        return super.rewriteTo();
    }

    private Literal rewriteRule0() {
        return this.parse();
    }
}

