/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Annotation;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.BytecodeReader;
import soot.JastAddJ.Case;
import soot.JastAddJ.CatchClause;
import soot.JastAddJ.ClassInstanceExpr;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.ElementValue;
import soot.JastAddJ.Expr;
import soot.JastAddJ.FileNamesPart;
import soot.JastAddJ.GLBType;
import soot.JastAddJ.ImportDecl;
import soot.JastAddJ.JavaParser;
import soot.JastAddJ.LUBType;
import soot.JastAddJ.LabeledStmt;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.NameType;
import soot.JastAddJ.PathPart;
import soot.JastAddJ.PrimitiveCompilationUnit;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.JastAddJ.VariableScope;
import soot.JastAddJ.WildcardsCompilationUnit;
import soot.jimple.Stmt;

public class Program
extends ASTNode<ASTNode>
implements Cloneable {
    protected BytecodeReader bytecodeReader;
    protected JavaParser javaParser;
    private boolean pathsInitialized = false;
    private ArrayList classPath;
    private ArrayList sourcePath;
    private FileNamesPart sourceFiles = new FileNamesPart(this);
    public int classFileReadTime;
    public static final int SRC_PREC_JAVA = 1;
    public static final int SRC_PREC_CLASS = 2;
    public static final int SRC_PREC_ONLY_CLASS = 3;
    private int srcPrec = 0;
    private HashMap loadedCompilationUnit = new HashMap();
    protected boolean typeObject_computed = false;
    protected TypeDecl typeObject_value;
    protected boolean typeCloneable_computed = false;
    protected TypeDecl typeCloneable_value;
    protected boolean typeSerializable_computed = false;
    protected TypeDecl typeSerializable_value;
    protected boolean typeBoolean_computed = false;
    protected TypeDecl typeBoolean_value;
    protected boolean typeByte_computed = false;
    protected TypeDecl typeByte_value;
    protected boolean typeShort_computed = false;
    protected TypeDecl typeShort_value;
    protected boolean typeChar_computed = false;
    protected TypeDecl typeChar_value;
    protected boolean typeInt_computed = false;
    protected TypeDecl typeInt_value;
    protected boolean typeLong_computed = false;
    protected TypeDecl typeLong_value;
    protected boolean typeFloat_computed = false;
    protected TypeDecl typeFloat_value;
    protected boolean typeDouble_computed = false;
    protected TypeDecl typeDouble_value;
    protected boolean typeString_computed = false;
    protected TypeDecl typeString_value;
    protected boolean typeVoid_computed = false;
    protected TypeDecl typeVoid_value;
    protected boolean typeNull_computed = false;
    protected TypeDecl typeNull_value;
    protected boolean unknownType_computed = false;
    protected TypeDecl unknownType_value;
    protected Map hasPackage_String_values;
    protected Map lookupType_String_String_values;
    protected Map lookupLibType_String_String_values;
    protected Map getLibCompilationUnit_String_values;
    protected List getLibCompilationUnit_String_list;
    protected boolean getPrimitiveCompilationUnit_computed = false;
    protected PrimitiveCompilationUnit getPrimitiveCompilationUnit_value;
    protected boolean unknownConstructor_computed = false;
    protected ConstructorDecl unknownConstructor_value;
    protected boolean wildcards_computed = false;
    protected WildcardsCompilationUnit wildcards_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.typeObject_computed = false;
        this.typeObject_value = null;
        this.typeCloneable_computed = false;
        this.typeCloneable_value = null;
        this.typeSerializable_computed = false;
        this.typeSerializable_value = null;
        this.typeBoolean_computed = false;
        this.typeBoolean_value = null;
        this.typeByte_computed = false;
        this.typeByte_value = null;
        this.typeShort_computed = false;
        this.typeShort_value = null;
        this.typeChar_computed = false;
        this.typeChar_value = null;
        this.typeInt_computed = false;
        this.typeInt_value = null;
        this.typeLong_computed = false;
        this.typeLong_value = null;
        this.typeFloat_computed = false;
        this.typeFloat_value = null;
        this.typeDouble_computed = false;
        this.typeDouble_value = null;
        this.typeString_computed = false;
        this.typeString_value = null;
        this.typeVoid_computed = false;
        this.typeVoid_value = null;
        this.typeNull_computed = false;
        this.typeNull_value = null;
        this.unknownType_computed = false;
        this.unknownType_value = null;
        this.hasPackage_String_values = null;
        this.lookupType_String_String_values = null;
        this.lookupLibType_String_String_values = null;
        this.getLibCompilationUnit_String_values = null;
        this.getLibCompilationUnit_String_list = null;
        this.getPrimitiveCompilationUnit_computed = false;
        this.getPrimitiveCompilationUnit_value = null;
        this.unknownConstructor_computed = false;
        this.unknownConstructor_value = null;
        this.wildcards_computed = false;
        this.wildcards_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Program clone() throws CloneNotSupportedException {
        Program node = (Program)super.clone();
        node.typeObject_computed = false;
        node.typeObject_value = null;
        node.typeCloneable_computed = false;
        node.typeCloneable_value = null;
        node.typeSerializable_computed = false;
        node.typeSerializable_value = null;
        node.typeBoolean_computed = false;
        node.typeBoolean_value = null;
        node.typeByte_computed = false;
        node.typeByte_value = null;
        node.typeShort_computed = false;
        node.typeShort_value = null;
        node.typeChar_computed = false;
        node.typeChar_value = null;
        node.typeInt_computed = false;
        node.typeInt_value = null;
        node.typeLong_computed = false;
        node.typeLong_value = null;
        node.typeFloat_computed = false;
        node.typeFloat_value = null;
        node.typeDouble_computed = false;
        node.typeDouble_value = null;
        node.typeString_computed = false;
        node.typeString_value = null;
        node.typeVoid_computed = false;
        node.typeVoid_value = null;
        node.typeNull_computed = false;
        node.typeNull_value = null;
        node.unknownType_computed = false;
        node.unknownType_value = null;
        node.hasPackage_String_values = null;
        node.lookupType_String_String_values = null;
        node.lookupLibType_String_String_values = null;
        node.getLibCompilationUnit_String_values = null;
        node.getLibCompilationUnit_String_list = null;
        node.getPrimitiveCompilationUnit_computed = false;
        node.getPrimitiveCompilationUnit_value = null;
        node.unknownConstructor_computed = false;
        node.unknownConstructor_value = null;
        node.wildcards_computed = false;
        node.wildcards_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public Program copy() {
        try {
            Program node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public Program fullCopy() {
        Program tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public void initBytecodeReader(BytecodeReader r) {
        this.bytecodeReader = r;
    }

    public void initJavaParser(JavaParser p) {
        this.javaParser = p;
    }

    public CompilationUnit addSourceFile(String name) {
        return this.sourceFiles.addSourceFile(name);
    }

    public Iterator compilationUnitIterator() {
        this.initPaths();
        return new Iterator(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Program.this.getNumCompilationUnit() || !Program.this.sourceFiles.isEmpty();
            }

            public Object next() {
                if (Program.this.getNumCompilationUnit() == this.index) {
                    String typename = (String)Program.this.sourceFiles.keySet().iterator().next();
                    CompilationUnit u = Program.this.getCompilationUnit(typename);
                    if (u != null) {
                        Program.this.addCompilationUnit(u);
                        Program.this.getCompilationUnit(Program.this.getNumCompilationUnit() - 1);
                    } else {
                        throw new Error("File " + typename + " not found");
                    }
                }
                return Program.this.getCompilationUnit(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public InputStream getInputStream(String name) {
        this.initPaths();
        try {
            for (PathPart part : this.classPath) {
                if (!part.selectCompilationUnit(name)) continue;
                return part.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new Error("Could not find nested type " + name);
    }

    public boolean isPackage(String name) {
        if (this.sourceFiles.hasPackage(name)) {
            return true;
        }
        for (PathPart part : this.classPath) {
            if (!part.hasPackage(name)) continue;
            return true;
        }
        for (PathPart part : this.sourcePath) {
            if (!part.hasPackage(name)) continue;
            return true;
        }
        return false;
    }

    public void pushClassPath(String name) {
        PathPart part = PathPart.createSourcePath(name, this);
        if (part == null) {
            throw new Error("Could not push source path " + name);
        }
        this.sourcePath.add(part);
        System.out.println("Pushing source path " + name);
        part = PathPart.createClassPath(name, this);
        if (part != null) {
            this.classPath.add(part);
            System.out.println("Pushing class path " + name);
        }
    }

    public void popClassPath() {
        if (this.sourcePath.size() > 0) {
            this.sourcePath.remove(this.sourcePath.size() - 1);
        }
        if (this.classPath.size() > 0) {
            this.classPath.remove(this.classPath.size() - 1);
        }
    }

    public void initPaths() {
        if (!this.pathsInitialized) {
            PathPart part;
            int i;
            this.pathsInitialized = true;
            ArrayList<String> classPaths = new ArrayList<String>();
            ArrayList<String> sourcePaths = new ArrayList<String>();
            String[] bootclasspaths = this.options().hasValueForOption("-bootclasspath") ? this.options().getValueForOption("-bootclasspath").split(File.pathSeparator) : System.getProperty("sun.boot.class.path").split(File.pathSeparator);
            for (int i2 = 0; i2 < bootclasspaths.length; ++i2) {
                classPaths.add(bootclasspaths[i2]);
            }
            String[] extdirs = this.options().hasValueForOption("-extdirs") ? this.options().getValueForOption("-extdirs").split(File.pathSeparator) : System.getProperty("java.ext.dirs").split(File.pathSeparator);
            for (int i3 = 0; i3 < extdirs.length; ++i3) {
                classPaths.add(extdirs[i3]);
            }
            String[] userClasses = null;
            userClasses = this.options().hasValueForOption("-classpath") ? this.options().getValueForOption("-classpath").split(File.pathSeparator) : (this.options().hasValueForOption("-cp") ? this.options().getValueForOption("-cp").split(File.pathSeparator) : ".".split(File.pathSeparator));
            if (!this.options().hasValueForOption("-sourcepath")) {
                for (i = 0; i < userClasses.length; ++i) {
                    classPaths.add(userClasses[i]);
                    sourcePaths.add(userClasses[i]);
                }
            } else {
                for (i = 0; i < userClasses.length; ++i) {
                    classPaths.add(userClasses[i]);
                }
                userClasses = this.options().getValueForOption("-sourcepath").split(File.pathSeparator);
                for (i = 0; i < userClasses.length; ++i) {
                    sourcePaths.add(userClasses[i]);
                }
            }
            this.classPath = new ArrayList();
            this.sourcePath = new ArrayList();
            for (String s : classPaths) {
                part = PathPart.createClassPath(s, this);
                if (part != null) {
                    this.classPath.add(part);
                    continue;
                }
                if (!this.options().verbose()) continue;
                System.out.println("Warning: Could not use " + s + " as class path");
            }
            for (String s : sourcePaths) {
                part = PathPart.createSourcePath(s, this);
                if (part != null) {
                    this.sourcePath.add(part);
                    continue;
                }
                if (!this.options().verbose()) continue;
                System.out.println("Warning: Could not use " + s + " as source path");
            }
        }
    }

    public void addClassPath(PathPart pathPart) {
        this.classPath.add(pathPart);
        pathPart.program = this;
    }

    public void addSourcePath(PathPart pathPart) {
        this.sourcePath.add(pathPart);
        pathPart.program = this;
    }

    public void simpleReset() {
        this.lookupType_String_String_values = new HashMap();
        this.hasPackage_String_values = new HashMap();
        List<CompilationUnit> list = new List<CompilationUnit>();
        for (int i = 0; i < this.getNumCompilationUnit(); ++i) {
            CompilationUnit unit = this.getCompilationUnit(i);
            if (unit.fromSource()) continue;
            list.add(unit);
        }
        this.setCompilationUnitList(list);
    }

    public void errorCheck(Collection collection) {
        Iterator iter = this.compilationUnitIterator();
        while (iter.hasNext()) {
            CompilationUnit cu = (CompilationUnit)iter.next();
            if (!cu.fromSource()) continue;
            cu.collectErrors();
            collection.addAll(cu.errors);
        }
    }

    public void errorCheck(Collection collection, Collection warn) {
        Iterator iter = this.compilationUnitIterator();
        while (iter.hasNext()) {
            CompilationUnit cu = (CompilationUnit)iter.next();
            if (!cu.fromSource()) continue;
            cu.collectErrors();
            collection.addAll(cu.errors);
            warn.addAll(cu.warnings);
        }
    }

    public boolean errorCheck() {
        LinkedList collection = new LinkedList();
        this.errorCheck(collection);
        if (collection.isEmpty()) {
            return false;
        }
        System.out.println("Errors:");
        for (String s : collection) {
            System.out.println(s);
        }
        return true;
    }

    @Override
    public void toString(StringBuffer s) {
        Iterator iter = this.compilationUnitIterator();
        while (iter.hasNext()) {
            CompilationUnit cu = (CompilationUnit)iter.next();
            if (!cu.fromSource()) continue;
            cu.toString(s);
        }
    }

    @Override
    public String dumpTree() {
        StringBuffer s = new StringBuffer();
        Iterator iter = this.compilationUnitIterator();
        while (iter.hasNext()) {
            CompilationUnit cu = (CompilationUnit)iter.next();
            if (!cu.fromSource()) continue;
            s.append(cu.dumpTree());
        }
        return s.toString();
    }

    public void jimplify1() {
        CompilationUnit u;
        Iterator iter = this.compilationUnitIterator();
        while (iter.hasNext()) {
            u = (CompilationUnit)iter.next();
            if (!u.fromSource()) continue;
            u.jimplify1phase1();
        }
        iter = this.compilationUnitIterator();
        while (iter.hasNext()) {
            u = (CompilationUnit)iter.next();
            if (!u.fromSource()) continue;
            u.jimplify1phase2();
        }
    }

    @Override
    public void jimplify2() {
        Iterator iter = this.compilationUnitIterator();
        while (iter.hasNext()) {
            CompilationUnit u = (CompilationUnit)iter.next();
            if (!u.fromSource()) continue;
            u.jimplify2();
        }
    }

    public void setSrcPrec(int i) {
        this.srcPrec = i;
    }

    public boolean hasLoadedCompilationUnit(String fileName) {
        return this.loadedCompilationUnit.containsKey(fileName);
    }

    public CompilationUnit getCachedOrLoadCompilationUnit(String fileName) {
        if (this.loadedCompilationUnit.containsKey(fileName)) {
            return (CompilationUnit)this.loadedCompilationUnit.get(fileName);
        }
        this.addSourceFile(fileName);
        return (CompilationUnit)this.loadedCompilationUnit.get(fileName);
    }

    public void releaseCompilationUnitForFile(String fileName) {
        this.lookupType_String_String_values = new HashMap();
        this.hasPackage_String_values = new HashMap();
        this.loadedCompilationUnit.remove(fileName);
        List<CompilationUnit> newList = new List<CompilationUnit>();
        for (CompilationUnit cu : this.getCompilationUnits()) {
            String pathName;
            boolean dontAdd = false;
            if (cu.fromSource() && (pathName = cu.pathName()).equals(fileName)) {
                dontAdd = true;
            }
            if (dontAdd) continue;
            newList.add(cu);
        }
        this.setCompilationUnitList(newList);
    }

    public Program() {
        this.is$Final(true);
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
        this.setChild(new List(), 0);
    }

    public Program(List<CompilationUnit> p0) {
        this.setChild(p0, 0);
        this.is$Final(true);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setCompilationUnitList(List<CompilationUnit> list) {
        this.setChild(list, 0);
    }

    public int getNumCompilationUnit() {
        return this.getCompilationUnitList().getNumChild();
    }

    public int getNumCompilationUnitNoTransform() {
        return this.getCompilationUnitListNoTransform().getNumChildNoTransform();
    }

    public CompilationUnit getCompilationUnit(int i) {
        return (CompilationUnit)this.getCompilationUnitList().getChild(i);
    }

    public void refined__Program_addCompilationUnit(CompilationUnit node) {
        List list = this.parent == null || state == null ? this.getCompilationUnitListNoTransform() : this.getCompilationUnitList();
        list.addChild(node);
    }

    public void addCompilationUnitNoTransform(CompilationUnit node) {
        List<CompilationUnit> list = this.getCompilationUnitListNoTransform();
        list.addChild(node);
    }

    public void setCompilationUnit(CompilationUnit node, int i) {
        List list = this.getCompilationUnitList();
        list.setChild(node, i);
    }

    public List<CompilationUnit> getCompilationUnits() {
        return this.getCompilationUnitList();
    }

    public List<CompilationUnit> getCompilationUnitsNoTransform() {
        return this.getCompilationUnitListNoTransform();
    }

    public List<CompilationUnit> refined__Program_getCompilationUnitList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    public List<CompilationUnit> getCompilationUnitListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public CompilationUnit getCompilationUnit(String name) {
        this.initPaths();
        try {
            String pkgName;
            CompilationUnit unit;
            PathPart part;
            if (this.sourceFiles.selectCompilationUnit(name)) {
                return this.sourceFiles.getCompilationUnit();
            }
            PathPart sourcePart = null;
            PathPart classPart = null;
            Iterator iter = this.sourcePath.iterator();
            while (iter.hasNext() && sourcePart == null) {
                part = (PathPart)iter.next();
                if (!part.selectCompilationUnit(name)) continue;
                sourcePart = part;
            }
            iter = this.classPath.iterator();
            while (iter.hasNext() && classPart == null) {
                part = (PathPart)iter.next();
                if (!part.selectCompilationUnit(name)) continue;
                classPart = part;
            }
            if (sourcePart != null && this.srcPrec == 1) {
                unit = sourcePart.getCompilationUnit();
                int index = name.lastIndexOf(46);
                if (index == -1) {
                    return unit;
                }
                pkgName = name.substring(0, index);
                if (pkgName.equals(unit.getPackageDecl())) {
                    return unit;
                }
            }
            if (classPart != null && this.srcPrec == 2) {
                unit = classPart.getCompilationUnit();
                int index = name.lastIndexOf(46);
                if (index == -1) {
                    return unit;
                }
                pkgName = name.substring(0, index);
                if (pkgName.equals(unit.getPackageDecl())) {
                    return unit;
                }
            }
            if (this.srcPrec == 3) {
                if (classPart != null) {
                    unit = classPart.getCompilationUnit();
                    int index = name.lastIndexOf(46);
                    if (index == -1) {
                        return unit;
                    }
                    pkgName = name.substring(0, index);
                    if (pkgName.equals(unit.getPackageDecl())) {
                        return unit;
                    }
                }
            } else if (sourcePart != null && (classPart == null || classPart.age <= sourcePart.age)) {
                unit = sourcePart.getCompilationUnit();
                int index = name.lastIndexOf(46);
                if (index == -1) {
                    return unit;
                }
                pkgName = name.substring(0, index);
                if (pkgName.equals(unit.getPackageDecl())) {
                    return unit;
                }
            } else if (classPart != null) {
                unit = classPart.getCompilationUnit();
                int index = name.lastIndexOf(46);
                if (index == -1) {
                    return unit;
                }
                pkgName = name.substring(0, index);
                if (pkgName.equals(unit.getPackageDecl())) {
                    return unit;
                }
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void addCompilationUnit(CompilationUnit unit) {
        try {
            if (unit.pathName() != null) {
                String fileName = new File(unit.pathName()).getCanonicalPath();
                this.loadedCompilationUnit.put(fileName, unit);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.refined__Program_addCompilationUnit(unit);
    }

    public List getCompilationUnitList() {
        this.initPaths();
        return this.refined__Program_getCompilationUnitList();
    }

    public TypeDecl typeObject() {
        if (this.typeObject_computed) {
            return this.typeObject_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeObject_value = this.typeObject_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeObject_computed = true;
        }
        return this.typeObject_value;
    }

    private TypeDecl typeObject_compute() {
        return this.lookupType("java.lang", "Object");
    }

    public TypeDecl typeCloneable() {
        if (this.typeCloneable_computed) {
            return this.typeCloneable_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeCloneable_value = this.typeCloneable_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeCloneable_computed = true;
        }
        return this.typeCloneable_value;
    }

    private TypeDecl typeCloneable_compute() {
        return this.lookupType("java.lang", "Cloneable");
    }

    public TypeDecl typeSerializable() {
        if (this.typeSerializable_computed) {
            return this.typeSerializable_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeSerializable_value = this.typeSerializable_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeSerializable_computed = true;
        }
        return this.typeSerializable_value;
    }

    private TypeDecl typeSerializable_compute() {
        return this.lookupType("java.io", "Serializable");
    }

    public TypeDecl typeBoolean() {
        if (this.typeBoolean_computed) {
            return this.typeBoolean_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeBoolean_value = this.typeBoolean_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeBoolean_computed = true;
        }
        return this.typeBoolean_value;
    }

    private TypeDecl typeBoolean_compute() {
        return this.lookupType("@primitive", "boolean");
    }

    public TypeDecl typeByte() {
        if (this.typeByte_computed) {
            return this.typeByte_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeByte_value = this.typeByte_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeByte_computed = true;
        }
        return this.typeByte_value;
    }

    private TypeDecl typeByte_compute() {
        return this.lookupType("@primitive", "byte");
    }

    public TypeDecl typeShort() {
        if (this.typeShort_computed) {
            return this.typeShort_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeShort_value = this.typeShort_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeShort_computed = true;
        }
        return this.typeShort_value;
    }

    private TypeDecl typeShort_compute() {
        return this.lookupType("@primitive", "short");
    }

    public TypeDecl typeChar() {
        if (this.typeChar_computed) {
            return this.typeChar_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeChar_value = this.typeChar_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeChar_computed = true;
        }
        return this.typeChar_value;
    }

    private TypeDecl typeChar_compute() {
        return this.lookupType("@primitive", "char");
    }

    public TypeDecl typeInt() {
        if (this.typeInt_computed) {
            return this.typeInt_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeInt_value = this.typeInt_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeInt_computed = true;
        }
        return this.typeInt_value;
    }

    private TypeDecl typeInt_compute() {
        return this.lookupType("@primitive", "int");
    }

    public TypeDecl typeLong() {
        if (this.typeLong_computed) {
            return this.typeLong_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeLong_value = this.typeLong_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeLong_computed = true;
        }
        return this.typeLong_value;
    }

    private TypeDecl typeLong_compute() {
        return this.lookupType("@primitive", "long");
    }

    public TypeDecl typeFloat() {
        if (this.typeFloat_computed) {
            return this.typeFloat_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeFloat_value = this.typeFloat_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeFloat_computed = true;
        }
        return this.typeFloat_value;
    }

    private TypeDecl typeFloat_compute() {
        return this.lookupType("@primitive", "float");
    }

    public TypeDecl typeDouble() {
        if (this.typeDouble_computed) {
            return this.typeDouble_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeDouble_value = this.typeDouble_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeDouble_computed = true;
        }
        return this.typeDouble_value;
    }

    private TypeDecl typeDouble_compute() {
        return this.lookupType("@primitive", "double");
    }

    public TypeDecl typeString() {
        if (this.typeString_computed) {
            return this.typeString_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeString_value = this.typeString_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeString_computed = true;
        }
        return this.typeString_value;
    }

    private TypeDecl typeString_compute() {
        return this.lookupType("java.lang", "String");
    }

    public TypeDecl typeVoid() {
        if (this.typeVoid_computed) {
            return this.typeVoid_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeVoid_value = this.typeVoid_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeVoid_computed = true;
        }
        return this.typeVoid_value;
    }

    private TypeDecl typeVoid_compute() {
        return this.lookupType("@primitive", "void");
    }

    public TypeDecl typeNull() {
        if (this.typeNull_computed) {
            return this.typeNull_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.typeNull_value = this.typeNull_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.typeNull_computed = true;
        }
        return this.typeNull_value;
    }

    private TypeDecl typeNull_compute() {
        return this.lookupType("@primitive", "null");
    }

    public TypeDecl unknownType() {
        if (this.unknownType_computed) {
            return this.unknownType_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.unknownType_value = this.unknownType_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.unknownType_computed = true;
        }
        return this.unknownType_value;
    }

    private TypeDecl unknownType_compute() {
        return this.lookupType("@primitive", "Unknown");
    }

    public boolean hasPackage(String packageName) {
        String _parameters = packageName;
        if (this.hasPackage_String_values == null) {
            this.hasPackage_String_values = new HashMap(4);
        }
        if (this.hasPackage_String_values.containsKey(_parameters)) {
            return (Boolean)this.hasPackage_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean hasPackage_String_value = this.hasPackage_compute(packageName);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.hasPackage_String_values.put(_parameters, hasPackage_String_value);
        }
        return hasPackage_String_value;
    }

    private boolean hasPackage_compute(String packageName) {
        return this.isPackage(packageName);
    }

    public TypeDecl lookupType(String packageName, String typeName) {
        ArrayList<String> _parameters = new ArrayList<String>(2);
        _parameters.add(packageName);
        _parameters.add(typeName);
        if (this.lookupType_String_String_values == null) {
            this.lookupType_String_String_values = new HashMap(4);
        }
        if (this.lookupType_String_String_values.containsKey(_parameters)) {
            return (TypeDecl)this.lookupType_String_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        TypeDecl lookupType_String_String_value = this.lookupType_compute(packageName, typeName);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.lookupType_String_String_values.put(_parameters, lookupType_String_String_value);
        }
        return lookupType_String_String_value;
    }

    private TypeDecl lookupType_compute(String packageName, String typeName) {
        String fullName = packageName.equals("") ? typeName : packageName + "." + typeName;
        for (int i = 0; i < this.getNumCompilationUnit(); ++i) {
            for (int j = 0; j < this.getCompilationUnit(i).getNumTypeDecl(); ++j) {
                TypeDecl type = this.getCompilationUnit(i).getTypeDecl(j);
                if (!type.fullName().equals(fullName)) continue;
                return type;
            }
        }
        return this.lookupLibType(packageName, typeName);
    }

    public TypeDecl lookupLibType(String packageName, String typeName) {
        ArrayList<String> _parameters = new ArrayList<String>(2);
        _parameters.add(packageName);
        _parameters.add(typeName);
        if (this.lookupLibType_String_String_values == null) {
            this.lookupLibType_String_String_values = new HashMap(4);
        }
        if (this.lookupLibType_String_String_values.containsKey(_parameters)) {
            return (TypeDecl)this.lookupLibType_String_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        TypeDecl lookupLibType_String_String_value = this.lookupLibType_compute(packageName, typeName);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.lookupLibType_String_String_values.put(_parameters, lookupLibType_String_String_value);
        }
        return lookupLibType_String_String_value;
    }

    private TypeDecl lookupLibType_compute(String packageName, String typeName) {
        CompilationUnit libUnit;
        String fullName;
        String string = fullName = packageName.equals("") ? typeName : packageName + "." + typeName;
        if (packageName.equals("@primitive")) {
            PrimitiveCompilationUnit unit = this.getPrimitiveCompilationUnit();
            if (typeName.equals("boolean")) {
                return unit.typeBoolean();
            }
            if (typeName.equals("byte")) {
                return unit.typeByte();
            }
            if (typeName.equals("short")) {
                return unit.typeShort();
            }
            if (typeName.equals("char")) {
                return unit.typeChar();
            }
            if (typeName.equals("int")) {
                return unit.typeInt();
            }
            if (typeName.equals("long")) {
                return unit.typeLong();
            }
            if (typeName.equals("float")) {
                return unit.typeFloat();
            }
            if (typeName.equals("double")) {
                return unit.typeDouble();
            }
            if (typeName.equals("null")) {
                return unit.typeNull();
            }
            if (typeName.equals("void")) {
                return unit.typeVoid();
            }
            if (typeName.equals("Unknown")) {
                return unit.unknownType();
            }
        }
        if ((libUnit = this.getLibCompilationUnit(fullName)) != null) {
            for (int j = 0; j < libUnit.getNumTypeDecl(); ++j) {
                TypeDecl type = libUnit.getTypeDecl(j);
                if (!type.fullName().equals(fullName)) continue;
                return type;
            }
        }
        return null;
    }

    public CompilationUnit getLibCompilationUnit(String fullName) {
        String _parameters = fullName;
        if (this.getLibCompilationUnit_String_values == null) {
            this.getLibCompilationUnit_String_values = new HashMap(4);
        }
        if (this.getLibCompilationUnit_String_values.containsKey(_parameters)) {
            return (CompilationUnit)this.getLibCompilationUnit_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        CompilationUnit getLibCompilationUnit_String_value = this.getLibCompilationUnit_compute(fullName);
        if (this.getLibCompilationUnit_String_list == null) {
            this.getLibCompilationUnit_String_list = new List();
            this.getLibCompilationUnit_String_list.is$Final = true;
            this.getLibCompilationUnit_String_list.setParent(this);
        }
        this.getLibCompilationUnit_String_list.add(getLibCompilationUnit_String_value);
        if (getLibCompilationUnit_String_value != null) {
            getLibCompilationUnit_String_value.is$Final = true;
        }
        this.getLibCompilationUnit_String_values.put(_parameters, getLibCompilationUnit_String_value);
        return getLibCompilationUnit_String_value;
    }

    private CompilationUnit getLibCompilationUnit_compute(String fullName) {
        return this.getCompilationUnit(fullName);
    }

    public PrimitiveCompilationUnit getPrimitiveCompilationUnit() {
        if (this.getPrimitiveCompilationUnit_computed) {
            return this.getPrimitiveCompilationUnit_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.getPrimitiveCompilationUnit_value = this.getPrimitiveCompilationUnit_compute();
        this.getPrimitiveCompilationUnit_value.setParent(this);
        this.getPrimitiveCompilationUnit_value.is$Final = true;
        this.getPrimitiveCompilationUnit_computed = true;
        return this.getPrimitiveCompilationUnit_value;
    }

    private PrimitiveCompilationUnit getPrimitiveCompilationUnit_compute() {
        PrimitiveCompilationUnit u = new PrimitiveCompilationUnit();
        u.setPackageDecl("@primitive");
        return u;
    }

    public ConstructorDecl unknownConstructor() {
        if (this.unknownConstructor_computed) {
            return this.unknownConstructor_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.unknownConstructor_value = this.unknownConstructor_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.unknownConstructor_computed = true;
        }
        return this.unknownConstructor_value;
    }

    private ConstructorDecl unknownConstructor_compute() {
        return (ConstructorDecl)this.unknownType().constructors().iterator().next();
    }

    public WildcardsCompilationUnit wildcards() {
        if (this.wildcards_computed) {
            return this.wildcards_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.wildcards_value = this.wildcards_compute();
        this.wildcards_value.setParent(this);
        this.wildcards_value.is$Final = true;
        this.wildcards_computed = true;
        return this.wildcards_value;
    }

    private WildcardsCompilationUnit wildcards_compute() {
        return new WildcardsCompilationUnit("wildcards", new List<ImportDecl>(), new List<TypeDecl>());
    }

    @Override
    public TypeDecl Define_TypeDecl_superType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public ConstructorDecl Define_ConstructorDecl_constructorDecl(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public TypeDecl Define_TypeDecl_componentType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unknownType();
    }

    @Override
    public LabeledStmt Define_LabeledStmt_lookupLabel(ASTNode caller, ASTNode child, String name) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return true;
    }

    @Override
    public boolean Define_boolean_isIncOrDec(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        int childIndex = this.getIndexOfChild(caller);
        return true;
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        int childIndex = this.getIndexOfChild(caller);
        return true;
    }

    @Override
    public TypeDecl Define_TypeDecl_typeException(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.lookupType("java.lang", "Exception");
    }

    @Override
    public TypeDecl Define_TypeDecl_typeRuntimeException(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.lookupType("java.lang", "RuntimeException");
    }

    @Override
    public TypeDecl Define_TypeDecl_typeError(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.lookupType("java.lang", "Error");
    }

    @Override
    public TypeDecl Define_TypeDecl_typeNullPointerException(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.lookupType("java.lang", "NullPointerException");
    }

    @Override
    public TypeDecl Define_TypeDecl_typeThrowable(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.lookupType("java.lang", "Throwable");
    }

    @Override
    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        int childIndex = this.getIndexOfChild(caller);
        throw new Error("Operation handlesException not supported");
    }

    @Override
    public Collection Define_Collection_lookupConstructor(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection Define_Collection_lookupSuperConstructor(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return Collections.EMPTY_LIST;
    }

    @Override
    public Expr Define_Expr_nestedScope(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        int childIndex = this.getIndexOfChild(caller);
        return Collections.EMPTY_LIST;
    }

    @Override
    public TypeDecl Define_TypeDecl_typeObject(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeObject();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeCloneable(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeCloneable();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeSerializable(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeSerializable();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeBoolean(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeBoolean();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeByte(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeByte();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeShort(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeShort();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeChar(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeChar();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeInt(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeInt();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeLong(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeLong();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeFloat(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeFloat();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeDouble(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeDouble();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeString(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeString();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeVoid(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeVoid();
    }

    @Override
    public TypeDecl Define_TypeDecl_typeNull(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeNull();
    }

    @Override
    public TypeDecl Define_TypeDecl_unknownType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unknownType();
    }

    @Override
    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        int childIndex = this.getIndexOfChild(caller);
        return this.hasPackage(packageName);
    }

    @Override
    public TypeDecl Define_TypeDecl_lookupType(ASTNode caller, ASTNode child, String packageName, String typeName) {
        int childIndex = this.getIndexOfChild(caller);
        return this.lookupType(packageName, typeName);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        int childIndex = this.getIndexOfChild(caller);
        return SimpleSet.emptySet;
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        int childIndex = this.getIndexOfChild(caller);
        return SimpleSet.emptySet;
    }

    @Override
    public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeStatic(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeFinal(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeAbstract(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeVolatile(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeTransient(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeStrictfp(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeSynchronized(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayBeNative(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public ASTNode Define_ASTNode_enclosingBlock(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public VariableScope Define_VariableScope_outerScope(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        throw new UnsupportedOperationException("outerScope() not defined");
    }

    @Override
    public boolean Define_boolean_insideLoop(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_insideSwitch(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public Case Define_Case_bind(ASTNode caller, ASTNode child, Case c) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public String Define_String_typeDeclIndent(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return "";
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return NameType.NO_NAME;
    }

    @Override
    public boolean Define_boolean_isAnonymous(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public Variable Define_Variable_unknownField(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unknownType().findSingleVariable("unknown");
    }

    @Override
    public MethodDecl Define_MethodDecl_unknownMethod(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        Iterator iter = this.unknownType().memberMethods("unknown").iterator();
        if (iter.hasNext()) {
            MethodDecl m = (MethodDecl)iter.next();
            return m;
        }
        throw new Error("Could not find method unknown in type Unknown");
    }

    @Override
    public ConstructorDecl Define_ConstructorDecl_unknownConstructor(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unknownConstructor();
    }

    @Override
    public TypeDecl Define_TypeDecl_declType(ASTNode caller, ASTNode child) {
        int i = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public BodyDecl Define_BodyDecl_enclosingBodyDecl(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public boolean Define_boolean_isMemberType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public TypeDecl Define_TypeDecl_hostType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public TypeDecl Define_TypeDecl_switchType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unknownType();
    }

    @Override
    public TypeDecl Define_TypeDecl_returnType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeVoid();
    }

    @Override
    public TypeDecl Define_TypeDecl_enclosingInstance(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public String Define_String_methodHost(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        throw new Error("Needs extra equation for methodHost()");
    }

    @Override
    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return true;
    }

    @Override
    public boolean Define_boolean_isMethodParameter(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_isConstructorParameter(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_isExceptionHandlerParameter(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public ElementValue Define_ElementValue_lookupElementTypeValue(ASTNode caller, ASTNode child, String name) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public boolean Define_boolean_withinSuppressWarnings(ASTNode caller, ASTNode child, String s) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_withinDeprecatedAnnotation(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public Annotation Define_Annotation_lookupAnnotation(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        int i = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public TypeDecl Define_TypeDecl_enclosingAnnotationDecl(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.unknownType();
    }

    @Override
    public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.typeNull();
    }

    @Override
    public boolean Define_boolean_inExtendsOrImplements(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public TypeDecl Define_TypeDecl_typeWildcard(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.wildcards().typeWildcard();
    }

    @Override
    public TypeDecl Define_TypeDecl_lookupWildcardExtends(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        int childIndex = this.getIndexOfChild(caller);
        return this.wildcards().lookupWildcardExtends(typeDecl);
    }

    @Override
    public TypeDecl Define_TypeDecl_lookupWildcardSuper(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        int childIndex = this.getIndexOfChild(caller);
        return this.wildcards().lookupWildcardSuper(typeDecl);
    }

    @Override
    public LUBType Define_LUBType_lookupLUBType(ASTNode caller, ASTNode child, Collection bounds) {
        int childIndex = this.getIndexOfChild(caller);
        return this.wildcards().lookupLUBType(bounds);
    }

    @Override
    public GLBType Define_GLBType_lookupGLBType(ASTNode caller, ASTNode child, ArrayList bounds) {
        int childIndex = this.getIndexOfChild(caller);
        return this.wildcards().lookupGLBType(bounds);
    }

    @Override
    public TypeDecl Define_TypeDecl_genericDecl(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public boolean Define_boolean_variableArityValid(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public TypeDecl Define_TypeDecl_expectedType(ASTNode caller, ASTNode child) {
        int i = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public Stmt Define_soot_jimple_Stmt_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getCompilationUnitListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            throw new Error("condition_false_label not implemented");
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_false_label(this, caller);
    }

    @Override
    public Stmt Define_soot_jimple_Stmt_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getCompilationUnitListNoTransform()) {
            int i = caller.getIndexOfChild(child);
            throw new Error("condition_true_label not implemented");
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_true_label(this, caller);
    }

    @Override
    public int Define_int_localNum(ASTNode caller, ASTNode child) {
        if (caller == this.getCompilationUnitListNoTransform()) {
            int index = caller.getIndexOfChild(child);
            return 0;
        }
        return this.getParent().Define_int_localNum(this, caller);
    }

    @Override
    public boolean Define_boolean_enclosedByExceptionHandler(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public ArrayList Define_ArrayList_exceptionRanges(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public boolean Define_boolean_isCatchParam(ASTNode caller, ASTNode child) {
        int i = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public CatchClause Define_CatchClause_catchClause(ASTNode caller, ASTNode child) {
        int i = this.getIndexOfChild(caller);
        throw new IllegalStateException("Could not find parent catch clause");
    }

    @Override
    public boolean Define_boolean_resourcePreviouslyDeclared(ASTNode caller, ASTNode child, String name) {
        int i = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public ClassInstanceExpr Define_ClassInstanceExpr_getClassInstanceExpr(ASTNode caller, ASTNode child) {
        int i = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public boolean Define_boolean_isAnonymousDecl(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_isExplicitGenericConstructorAccess(ASTNode caller, ASTNode child) {
        int i = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

