/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import soot.ClassSource;
import soot.G;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.javaToJimple.IInitialResolver;
import soot.jimple.JimpleMethodSource;
import soot.jimple.parser.JimpleAST;
import soot.jimple.parser.lexer.LexerException;
import soot.jimple.parser.parser.ParserException;
import soot.options.Options;

public class JimpleClassSource
extends ClassSource {
    private SourceLocator.FoundFile foundFile;

    public JimpleClassSource(String className, SourceLocator.FoundFile foundFile) {
        super(className);
        if (foundFile == null) {
            throw new IllegalStateException("Error: The FoundFile must not be null.");
        }
        this.foundFile = foundFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            G.v().out.println("resolving [from .jimple]: " + this.className);
        }
        InputStream classFile = null;
        try {
            classFile = this.foundFile.inputStream();
            JimpleAST jimpAST = new JimpleAST(classFile);
            jimpAST.getSkeleton(sc);
            JimpleMethodSource mtdSrc = new JimpleMethodSource(jimpAST);
            Iterator<SootMethod> mtdIt = sc.methodIterator();
            while (mtdIt.hasNext()) {
                SootMethod sm = mtdIt.next();
                sm.setSource(mtdSrc);
            }
            IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
            for (String t : jimpAST.getCstPool()) {
                deps.typesToSignature.add(RefType.v(t));
            }
            IInitialResolver.Dependencies dependencies = deps;
            return dependencies;
        }
        catch (IOException e) {
            throw new RuntimeException("Error: Failed to create JimpleAST from source input stream for class " + this.className + ".", e);
        }
        catch (ParserException e) {
            throw new RuntimeException("Error: Failed when parsing class " + this.className + ".", e);
        }
        catch (LexerException e) {
            throw new RuntimeException("Error: Failed when lexing class " + this.className + ".", e);
        }
        finally {
            try {
                if (classFile != null) {
                    classFile.close();
                    classFile = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error: Failed to close source input stream.", e);
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        if (this.foundFile != null) {
            this.foundFile.close();
            this.foundFile = null;
        }
    }
}

