/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import soot.AttributesUnitPrinter;
import soot.Body;
import soot.BriefUnitPrinter;
import soot.G;
import soot.LabeledUnitPrinter;
import soot.Local;
import soot.Modifier;
import soot.NormalUnitPrinter;
import soot.PatchingChain;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.options.Options;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.Tag;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.DeterministicHashMap;

public class Printer {
    private static final char fileSeparator = System.getProperty("file.separator").charAt(0);
    public static final int USE_ABBREVIATIONS = 1;
    public static final int ADD_JIMPLE_LN = 16;
    int options = 0;
    int jimpleLnNum = 0;

    public Printer(Singletons.Global g) {
    }

    public static Printer v() {
        return G.v().soot_Printer();
    }

    public boolean useAbbreviations() {
        return (this.options & 1) != 0;
    }

    public boolean addJimpleLn() {
        return (this.options & 0x10) != 0;
    }

    public void setOption(int opt) {
        this.options |= opt;
    }

    public void clearOption(int opt) {
        this.options &= ~opt;
    }

    public int getJimpleLnNum() {
        return this.jimpleLnNum;
    }

    public void setJimpleLnNum(int newVal) {
        this.jimpleLnNum = newVal;
    }

    public void incJimpleLnNum() {
        ++this.jimpleLnNum;
    }

    public void printTo(SootClass cl, PrintWriter out) {
        Iterator<SootMethod> methodIt;
        Iterator<SootField> fieldIt;
        Iterator<SootClass> interfaceIt;
        this.setJimpleLnNum(1);
        StringTokenizer st = new StringTokenizer(Modifier.toString(cl.getModifiers()));
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (cl.isInterface() && tok.equals("abstract")) continue;
            out.print(tok + " ");
        }
        String classPrefix = "";
        if (!cl.isInterface()) {
            classPrefix = classPrefix + " class";
            classPrefix = classPrefix.trim();
        }
        out.print(classPrefix + " " + Scene.v().quotedNameOf(cl.getName()) + "");
        if (cl.hasSuperclass()) {
            out.print(" extends " + Scene.v().quotedNameOf(cl.getSuperclass().getName()) + "");
        }
        if ((interfaceIt = cl.getInterfaces().iterator()).hasNext()) {
            out.print(" implements ");
            out.print("" + Scene.v().quotedNameOf(interfaceIt.next().getName()) + "");
            while (interfaceIt.hasNext()) {
                out.print(",");
                out.print(" " + Scene.v().quotedNameOf(interfaceIt.next().getName()) + "");
            }
        }
        out.println();
        this.incJimpleLnNum();
        out.println("{");
        this.incJimpleLnNum();
        if (Options.v().print_tags_in_output()) {
            for (Tag t : cl.getTags()) {
                out.print("/*");
                out.print(t.toString());
                out.println("*/");
            }
        }
        if ((fieldIt = cl.getFields().iterator()).hasNext()) {
            while (fieldIt.hasNext()) {
                SootField f = fieldIt.next();
                if (f.isPhantom()) continue;
                if (Options.v().print_tags_in_output()) {
                    for (Tag t : f.getTags()) {
                        out.print("/*");
                        out.print(t.toString());
                        out.println("*/");
                    }
                }
                out.println("    " + f.getDeclaration() + ";");
                if (!this.addJimpleLn()) continue;
                this.setJimpleLnNum(this.addJimpleLnTags(this.getJimpleLnNum(), f));
            }
        }
        if ((methodIt = cl.methodIterator()).hasNext()) {
            if (cl.getMethodCount() != 0) {
                out.println();
                this.incJimpleLnNum();
            }
            while (methodIt.hasNext()) {
                SootMethod method = methodIt.next();
                if (method.isPhantom()) continue;
                if (!Modifier.isAbstract(method.getModifiers()) && !Modifier.isNative(method.getModifiers())) {
                    if (!method.hasActiveBody()) {
                        method.retrieveActiveBody();
                        if (!method.hasActiveBody()) {
                            throw new RuntimeException("method " + method.getName() + " has no active body!");
                        }
                    } else if (Options.v().print_tags_in_output()) {
                        for (Tag t : method.getTags()) {
                            out.print("/*");
                            out.print(t.toString());
                            out.println("*/");
                        }
                    }
                    this.printTo(method.getActiveBody(), out);
                    if (!methodIt.hasNext()) continue;
                    out.println();
                    this.incJimpleLnNum();
                    continue;
                }
                if (Options.v().print_tags_in_output()) {
                    for (Tag t : method.getTags()) {
                        out.print("/*");
                        out.print(t.toString());
                        out.println("*/");
                    }
                }
                out.print("    ");
                out.print(method.getDeclaration());
                out.println(";");
                this.incJimpleLnNum();
                if (!methodIt.hasNext()) continue;
                out.println();
                this.incJimpleLnNum();
            }
        }
        out.println("}");
        this.incJimpleLnNum();
    }

    public void printTo(Body b, PrintWriter out) {
        boolean isPrecise = !this.useAbbreviations();
        String decl = b.getMethod().getDeclaration();
        out.println("    " + decl);
        if (!this.addJimpleLn()) {
            // empty if block
        }
        if (this.addJimpleLn()) {
            this.setJimpleLnNum(this.addJimpleLnTags(this.getJimpleLnNum(), b.getMethod()));
        }
        out.println("    {");
        this.incJimpleLnNum();
        BriefUnitGraph unitGraph = new BriefUnitGraph(b);
        LabeledUnitPrinter up = isPrecise ? new NormalUnitPrinter(b) : new BriefUnitPrinter(b);
        if (this.addJimpleLn()) {
            up.setPositionTagger(new AttributesUnitPrinter(this.getJimpleLnNum()));
        }
        this.printLocalsInBody(b, up);
        this.printStatementsInBody(b, out, up, unitGraph);
        out.println("    }");
        this.incJimpleLnNum();
    }

    private void printStatementsInBody(Body body, PrintWriter out, LabeledUnitPrinter up, UnitGraph unitGraph) {
        Iterator<Trap> trapIt;
        PatchingChain<Unit> units = body.getUnits();
        Iterator iterator = units.iterator();
        while (iterator.hasNext()) {
            Unit currentStmt;
            Unit previousStmt = currentStmt = (Unit)iterator.next();
            if (currentStmt != units.getFirst()) {
                if (unitGraph.getSuccsOf(previousStmt).size() != 1 || unitGraph.getPredsOf(currentStmt).size() != 1 || up.labels().containsKey(currentStmt)) {
                    up.newline();
                } else {
                    List<Unit> succs = unitGraph.getSuccsOf(previousStmt);
                    if (succs.get(0) != currentStmt) {
                        up.newline();
                    }
                }
            }
            if (up.labels().containsKey(currentStmt)) {
                up.unitRef(currentStmt, true);
                up.literal(":");
                up.newline();
            }
            if (up.references().containsKey(currentStmt)) {
                up.unitRef(currentStmt, false);
            }
            up.startUnit(currentStmt);
            currentStmt.toString(up);
            up.endUnit(currentStmt);
            up.literal(";");
            up.newline();
            if (!Options.v().print_tags_in_output()) continue;
            for (Tag t : currentStmt.getTags()) {
                up.noIndent();
                up.literal("/*");
                up.literal(t.toString());
                up.literal("*/");
                up.newline();
            }
        }
        out.print(up.toString());
        if (this.addJimpleLn()) {
            this.setJimpleLnNum(up.getPositionTagger().getEndLn());
        }
        if ((trapIt = body.getTraps().iterator()).hasNext()) {
            out.println();
            this.incJimpleLnNum();
        }
        while (trapIt.hasNext()) {
            Trap trap = trapIt.next();
            out.println("        catch " + Scene.v().quotedNameOf(trap.getException().getName()) + " from " + up.labels().get(trap.getBeginUnit()) + " to " + up.labels().get(trap.getEndUnit()) + " with " + up.labels().get(trap.getHandlerUnit()) + ";");
            this.incJimpleLnNum();
        }
    }

    private int addJimpleLnTags(int lnNum, SootMethod meth) {
        meth.addTag(new JimpleLineNumberTag(lnNum));
        return ++lnNum;
    }

    private int addJimpleLnTags(int lnNum, SootField f) {
        f.addTag(new JimpleLineNumberTag(lnNum));
        return ++lnNum;
    }

    private void printLocalsInBody(Body body, UnitPrinter up) {
        List<Local> localList;
        DeterministicHashMap typeToLocals = new DeterministicHashMap(body.getLocalCount() * 2 + 1, 0.7f);
        for (Local local : body.getLocals()) {
            Type t = local.getType();
            if (typeToLocals.containsKey(t)) {
                localList = (List)typeToLocals.get(t);
            } else {
                localList = new ArrayList();
                typeToLocals.put(t, localList);
            }
            localList.add(local);
        }
        for (Type type : typeToLocals.keySet()) {
            localList = (List)typeToLocals.get(type);
            Object[] locals = localList.toArray();
            up.type(type);
            up.literal(" ");
            for (int k = 0; k < locals.length; ++k) {
                if (k != 0) {
                    up.literal(", ");
                }
                up.local((Local)locals[k]);
            }
            up.literal(";");
            up.newline();
        }
        if (!typeToLocals.isEmpty()) {
            up.newline();
        }
    }
}

