/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import soot.ClassProvider;
import soot.ClassSource;
import soot.CoffiClassProvider;
import soot.CoffiClassSource;
import soot.CompilationDeathException;
import soot.DexClassProvider;
import soot.G;
import soot.JavaClassProvider;
import soot.JimpleClassProvider;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.asm.AsmClassProvider;
import soot.options.Options;

public class SourceLocator {
    protected Set<ClassLoader> additionalClassLoaders = new HashSet<ClassLoader>();
    protected Set<String> classesToLoad;
    private List<ClassProvider> classProviders;
    private List<String> classPath;
    private List<String> sourcePath;
    private LoadingCache<String, ClassSourceType> pathToSourceType = CacheBuilder.newBuilder().initialCapacity(60).maximumSize(500L).softValues().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build(new CacheLoader<String, ClassSourceType>(){

        @Override
        public ClassSourceType load(String path) throws Exception {
            File f = new File(path);
            if (!f.exists() && !Options.v().ignore_classpath_errors()) {
                throw new Exception("Error: The path '" + path + "' does not exist.");
            }
            if (!f.canRead() && !Options.v().ignore_classpath_errors()) {
                throw new Exception("Error: The path '" + path + "' exists but is not readable.");
            }
            if (f.isFile()) {
                if (path.endsWith(".zip")) {
                    return ClassSourceType.zip;
                }
                if (path.endsWith(".jar")) {
                    return ClassSourceType.jar;
                }
                if (path.endsWith(".apk")) {
                    return ClassSourceType.apk;
                }
                if (path.endsWith(".dex")) {
                    return ClassSourceType.dex;
                }
                return ClassSourceType.unknown;
            }
            return ClassSourceType.directory;
        }
    });
    private LoadingCache<String, Set<String>> archivePathsToEntriesCache = CacheBuilder.newBuilder().initialCapacity(60).maximumSize(500L).softValues().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build(new CacheLoader<String, Set<String>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> load(String archivePath) throws Exception {
            ZipFile archive = null;
            try {
                archive = new ZipFile(archivePath);
                HashSet<String> ret = new HashSet<String>();
                Enumeration<? extends ZipEntry> it = archive.entries();
                while (it.hasMoreElements()) {
                    ret.add(it.nextElement().getName());
                }
                HashSet<String> hashSet = ret;
                return hashSet;
            }
            finally {
                if (archive != null) {
                    archive.close();
                }
            }
        }
    });
    private Map<String, File> dexClassIndex;

    public SourceLocator(Singletons.Global g) {
    }

    public static SourceLocator v() {
        return G.v().soot_SourceLocator();
    }

    public ClassSource getClassSource(String className) {
        ClassSource ret;
        if (this.classesToLoad == null) {
            this.classesToLoad = new HashSet<String>();
            this.classesToLoad.addAll(Scene.v().getBasicClasses());
            for (SootClass sootClass : Scene.v().getApplicationClasses()) {
                this.classesToLoad.add(sootClass.getName());
            }
        }
        if (this.classPath == null) {
            this.classPath = SourceLocator.explodeClassPath(Scene.v().getSootClassPath());
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        JavaClassProvider.JarException ex = null;
        for (ClassProvider cp : this.classProviders) {
            try {
                ret = cp.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        for (final ClassLoader cl : this.additionalClassLoaders) {
            try {
                ret = new ClassProvider(){

                    @Override
                    public ClassSource find(String className) {
                        String fileName = className.replace('.', '/') + ".class";
                        InputStream stream = cl.getResourceAsStream(fileName);
                        if (stream == null) {
                            return null;
                        }
                        return new CoffiClassSource(className, stream, fileName);
                    }
                }.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        if (className.startsWith("soot.rtlib.tamiflex.")) {
            ClassLoader cl;
            String string = className.replace('.', '/') + ".class";
            cl = this.getClass().getClassLoader();
            if (cl == null) {
                return null;
            }
            InputStream stream = cl.getResourceAsStream(string);
            if (stream != null) {
                return new CoffiClassSource(className, stream, string);
            }
        }
        return null;
    }

    public void additionalClassLoader(ClassLoader c) {
        this.additionalClassLoaders.add(c);
    }

    private void setupClassProviders() {
        this.classProviders = new LinkedList<ClassProvider>();
        ClassProvider classFileClassProvider = Options.v().coffi() ? new CoffiClassProvider() : new AsmClassProvider();
        switch (Options.v().src_prec()) {
            case 1: {
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JimpleClassProvider());
                this.classProviders.add(new JavaClassProvider());
                break;
            }
            case 2: {
                this.classProviders.add(classFileClassProvider);
                break;
            }
            case 4: {
                this.classProviders.add(new JavaClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            case 3: {
                this.classProviders.add(new JimpleClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JavaClassProvider());
                break;
            }
            case 5: {
                this.classProviders.add(new DexClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JavaClassProvider());
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            case 6: {
                this.classProviders.add(new DexClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            default: {
                throw new RuntimeException("Other source precedences are not currently supported.");
            }
        }
    }

    public void setClassProviders(List<ClassProvider> classProviders) {
        this.classProviders = classProviders;
    }

    public List<String> classPath() {
        return this.classPath;
    }

    public void invalidateClassPath() {
        this.classPath = null;
        this.dexClassIndex = null;
    }

    public List<String> sourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new ArrayList<String>();
            for (String dir : this.classPath) {
                ClassSourceType cst = this.getClassSourceType(dir);
                if (cst == ClassSourceType.apk || cst == ClassSourceType.jar || cst == ClassSourceType.zip) continue;
                this.sourcePath.add(dir);
            }
        }
        return this.sourcePath;
    }

    private ClassSourceType getClassSourceType(String path) {
        try {
            return this.pathToSourceType.get(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getClassesUnder(String aPath) {
        return this.getClassesUnder(aPath, "");
    }

    private List<String> getClassesUnder(String aPath, String prefix) {
        ArrayList<String> classes = new ArrayList<String>();
        ClassSourceType cst = this.getClassSourceType(aPath);
        if (cst == ClassSourceType.apk) {
            ZipFile archive = null;
            try {
                archive = new ZipFile(aPath);
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".dex")) continue;
                    classes.addAll(DexClassProvider.classesOfDex(new File(aPath)));
                }
            }
            catch (IOException e) {
                throw new CompilationDeathException("Error reasing archive '" + aPath + "'", e);
            }
            finally {
                try {
                    if (archive != null) {
                        archive.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        if (cst == ClassSourceType.dex) {
            try {
                classes.addAll(DexClassProvider.classesOfDex(new File(aPath)));
            }
            catch (IOException e) {
                throw new CompilationDeathException("Error reasing '" + aPath + "'", e);
            }
        }
        if (cst == ClassSourceType.jar || cst == ClassSourceType.zip) {
            HashSet<String> dexEntryNames = new HashSet<String>();
            ZipFile archive = null;
            try {
                archive = new ZipFile(aPath);
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entryName.endsWith(".class") || entryName.endsWith(".jimple")) {
                        int extensionIndex = entryName.lastIndexOf(46);
                        entryName = entryName.substring(0, extensionIndex);
                        entryName = entryName.replace('/', '.');
                        classes.add(prefix + entryName);
                        continue;
                    }
                    if (!entryName.endsWith(".dex")) continue;
                    dexEntryNames.add(entryName);
                }
            }
            catch (Throwable e) {
                throw new CompilationDeathException("Error reading archive '" + aPath + "'", e);
            }
            finally {
                try {
                    if (archive != null) {
                        archive.close();
                    }
                }
                catch (Throwable entries) {}
            }
            if (!dexEntryNames.isEmpty()) {
                File file = new File(aPath);
                if (Options.v().process_multiple_dex()) {
                    for (String dexEntryName : dexEntryNames) {
                        try {
                            classes.addAll(DexClassProvider.classesOfDex(file, dexEntryName));
                        }
                        catch (Throwable extensionIndex) {}
                    }
                } else {
                    try {
                        classes.addAll(DexClassProvider.classesOfDex(file));
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else if (cst == ClassSourceType.directory) {
            File file = new File(aPath);
            File[] files = file.listFiles();
            if (files == null) {
                files = new File[]{file};
            }
            for (File element : files) {
                if (element.isDirectory()) {
                    classes.addAll(this.getClassesUnder(aPath + File.separatorChar + element.getName(), prefix + element.getName() + "."));
                    continue;
                }
                String fileName = element.getName();
                if (fileName.endsWith(".class")) {
                    int index = fileName.lastIndexOf(".class");
                    classes.add(prefix + fileName.substring(0, index));
                    continue;
                }
                if (fileName.endsWith(".jimple")) {
                    int index = fileName.lastIndexOf(".jimple");
                    classes.add(prefix + fileName.substring(0, index));
                    continue;
                }
                if (fileName.endsWith(".java")) {
                    int index = fileName.lastIndexOf(".java");
                    classes.add(prefix + fileName.substring(0, index));
                    continue;
                }
                if (!fileName.endsWith(".dex")) continue;
                try {
                    classes.addAll(DexClassProvider.classesOfDex(element));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            throw new RuntimeException("Invalid class source type");
        }
        return classes;
    }

    public String getFileNameFor(SootClass c, int rep) {
        if (rep == 12) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        if (!Options.v().output_jar()) {
            b.append(this.getOutputDir());
        }
        if (b.length() > 0 && b.charAt(b.length() - 1) != File.separatorChar) {
            b.append(File.separatorChar);
        }
        if (rep != 15) {
            if (rep == 14) {
                b.append(c.getName().replace('.', File.separatorChar));
            } else if (rep == 16) {
                b.append(c.getName().replace('.', '_'));
                b.append("_Maker");
            } else {
                b.append(c.getName());
            }
            b.append(this.getExtensionFor(rep));
            return b.toString();
        }
        return this.getDavaFilenameFor(c, b);
    }

    private String getDavaFilenameFor(SootClass c, StringBuffer b) {
        b.append("dava");
        b.append(File.separatorChar);
        SourceLocator.ensureDirectoryExists(new File(b.toString() + "classes"));
        b.append("src");
        b.append(File.separatorChar);
        String fixedPackageName = c.getJavaPackageName();
        if (!fixedPackageName.equals("")) {
            b.append(fixedPackageName.replace('.', File.separatorChar));
            b.append(File.separatorChar);
        }
        SourceLocator.ensureDirectoryExists(new File(b.toString()));
        b.append(c.getShortJavaStyleName());
        b.append(".java");
        return b.toString();
    }

    public Set<String> classesInDynamicPackage(String str) {
        HashSet<String> set = new HashSet<String>(0);
        StringTokenizer strtok = new StringTokenizer(Scene.v().getSootClassPath(), String.valueOf(File.pathSeparatorChar));
        while (strtok.hasMoreTokens()) {
            String path = strtok.nextToken();
            List<String> l = this.getClassesUnder(path);
            for (String filename : l) {
                if (!filename.startsWith(str)) continue;
                set.add(filename);
            }
            path = path + File.pathSeparatorChar;
            StringTokenizer tokenizer = new StringTokenizer(str, ".");
            while (tokenizer.hasMoreTokens()) {
                path = path + tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                path = path + File.pathSeparatorChar;
            }
            l = this.getClassesUnder(path);
            for (String string : l) {
                set.add(str + "." + string);
            }
        }
        return set;
    }

    public String getExtensionFor(int rep) {
        switch (rep) {
            case 5: {
                return ".baf";
            }
            case 6: {
                return ".b";
            }
            case 1: {
                return ".jimple";
            }
            case 2: {
                return ".jimp";
            }
            case 3: {
                return ".shimple";
            }
            case 4: {
                return ".shimp";
            }
            case 8: {
                return ".grimp";
            }
            case 7: {
                return ".grimple";
            }
            case 14: {
                return ".class";
            }
            case 15: {
                return ".java";
            }
            case 13: {
                return ".jasmin";
            }
            case 9: {
                return ".xml";
            }
            case 16: {
                return ".java";
            }
            case 17: {
                return ".asm";
            }
        }
        throw new RuntimeException();
    }

    public static void ensureDirectoryExists(File dir) {
        if (dir != null && !dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                G.v().out.println("Unable to create " + dir);
                throw new CompilationDeathException(0);
            }
        }
    }

    public String getOutputDir() {
        File dir;
        if (Options.v().output_dir().length() == 0) {
            dir = new File("sootOutput");
        } else {
            dir = new File(Options.v().output_dir());
            if (dir.getPath().endsWith(".jar") && (dir = dir.getParentFile()) == null) {
                dir = new File("");
            }
        }
        SourceLocator.ensureDirectoryExists(dir);
        return dir.getPath();
    }

    public String getOutputJarName() {
        File dir;
        if (!Options.v().output_jar()) {
            return "";
        }
        if (Options.v().output_dir().length() == 0) {
            dir = new File("sootOutput/out.jar");
        } else {
            dir = new File(Options.v().output_dir());
            if (!dir.getPath().endsWith(".jar")) {
                dir = new File(dir.getPath(), "out.jar");
            }
        }
        SourceLocator.ensureDirectoryExists(dir.getParentFile());
        return dir.getPath();
    }

    public static List<String> explodeClassPath(String classPath) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String originalDir = tokenizer.nextToken();
            try {
                String canonicalDir = new File(originalDir).getCanonicalPath();
                ret.add(canonicalDir);
            }
            catch (IOException e) {
                throw new CompilationDeathException("Couldn't resolve classpath entry " + originalDir + ": " + e);
            }
        }
        return ret;
    }

    public FoundFile lookupInClassPath(String fileName) {
        for (String dir : this.classPath) {
            FoundFile ret = null;
            ClassSourceType cst = this.getClassSourceType(dir);
            if (cst == ClassSourceType.zip || cst == ClassSourceType.jar) {
                ret = this.lookupInArchive(dir, fileName);
            } else if (cst == ClassSourceType.directory) {
                ret = this.lookupInDir(dir, fileName);
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private FoundFile lookupInDir(String dir, String fileName) {
        File f = new File(dir + File.separatorChar + fileName);
        if (f.canRead()) {
            return new FoundFile(f);
        }
        return null;
    }

    private FoundFile lookupInArchive(String archivePath, String fileName) {
        Set<String> entryNames = null;
        try {
            entryNames = this.archivePathsToEntriesCache.get(archivePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error: Failed to retrieve the archive entries list for the archive at path '" + archivePath + "'.", e);
        }
        if (entryNames.contains(fileName)) {
            return new FoundFile(archivePath, fileName);
        }
        return null;
    }

    public String getSourceForClass(String className) {
        String javaClassName = className;
        if (className.indexOf("$") != -1) {
            javaClassName = className.substring(0, className.indexOf("$"));
        }
        return javaClassName;
    }

    public Map<String, File> dexClassIndex() {
        return this.dexClassIndex;
    }

    public void setDexClassIndex(Map<String, File> index) {
        this.dexClassIndex = index;
    }

    public static class FoundFile {
        private File file;
        private String entryName;
        private ZipFile zipFile = null;
        private ZipEntry zipEntry = null;
        private List<InputStream> openedInputStreams = new ArrayList<InputStream>();

        FoundFile(String archivePath, String entryName) {
            this();
            if (archivePath == null || entryName == null) {
                throw new IllegalArgumentException("Error: The archive path and entry name cannot be null.");
            }
            this.file = new File(archivePath);
            this.entryName = entryName;
        }

        FoundFile(File file) {
            this();
            if (file == null) {
                throw new IllegalArgumentException("Error: The file cannot be null.");
            }
            this.file = file;
            this.entryName = null;
        }

        private FoundFile() {
        }

        public String getFilePath() {
            return this.file.getPath();
        }

        public boolean isZipFile() {
            return this.entryName != null;
        }

        public File getFile() {
            return this.file;
        }

        public InputStream inputStream() {
            InputStream ret = null;
            if (!this.isZipFile()) {
                try {
                    ret = new FileInputStream(this.file);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error: Failed to open a InputStream for the file at path '" + this.file.getPath() + "'.", e);
                }
            }
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.file);
                    this.zipEntry = this.zipFile.getEntry(this.entryName);
                    if (this.zipEntry == null) {
                        this.silentClose();
                        throw new RuntimeException("Error: Failed to find entry '" + this.entryName + "' in the archive file at path '" + this.file.getPath() + "'.");
                    }
                }
                catch (Exception e) {
                    this.silentClose();
                    throw new RuntimeException("Error: Failed to open the archive file at path '" + this.file.getPath() + "' for entry '" + this.entryName + "'.", e);
                }
            }
            try {
                ret = this.doJDKBugWorkaround(this.zipFile.getInputStream(this.zipEntry), this.zipEntry.getSize());
            }
            catch (Exception e) {
                throw new RuntimeException("Error: Failed to open a InputStream for the entry '" + this.zipEntry.getName() + "' of the archive at path '" + this.zipFile.getName() + "'.", e);
            }
            this.openedInputStreams.add(ret);
            return ret;
        }

        public void silentClose() {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            ArrayList<Exception> errs = new ArrayList<Exception>();
            Iterator<InputStream> it = this.openedInputStreams.iterator();
            while (it.hasNext()) {
                InputStream is = it.next();
                try {
                    is.close();
                }
                catch (Exception e) {
                    errs.add(e);
                }
                it.remove();
            }
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                    errs.clear();
                }
                catch (Exception e) {
                    errs.add(e);
                }
                this.zipFile = null;
                this.zipEntry = null;
            }
            if (!errs.isEmpty()) {
                String msg = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = null;
                try {
                    ps = new PrintStream((OutputStream)baos, true, "utf-8");
                    ps.println("Error: Failed to close all opened resources. The following exceptions were thrown in the process: ");
                    int i = 0;
                    for (Throwable throwable : errs) {
                        ps.print("Exception ");
                        ps.print(i++);
                        ps.print(": ");
                        throwable.printStackTrace(ps);
                    }
                    msg = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                }
                catch (Exception exception) {
                }
                finally {
                    ps.close();
                }
                throw new RuntimeException(msg);
            }
        }

        private InputStream doJDKBugWorkaround(InputStream is, long size) throws IOException {
            int sz;
            byte[] buf = new byte[sz];
            int N = 1024;
            int ln = 0;
            int count = 0;
            for (sz = (int)size; sz > 0 && (ln = is.read(buf, count, Math.min(1024, sz))) != -1; sz -= ln) {
                count += ln;
            }
            return new ByteArrayInputStream(buf);
        }
    }

    private static enum ClassSourceType {
        jar,
        zip,
        apk,
        dex,
        directory,
        unknown;

    }
}

