/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import soot.ClassSource;
import soot.SootClass;
import soot.SourceLocator;
import soot.asm.SootClassBuilder;
import soot.javaToJimple.IInitialResolver;

class AsmClassSource
extends ClassSource {
    private SourceLocator.FoundFile foundFile;

    AsmClassSource(String cls, SourceLocator.FoundFile foundFile) {
        super(cls);
        if (foundFile == null) {
            throw new IllegalStateException("Error: The FoundFile must not be null.");
        }
        this.foundFile = foundFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IInitialResolver.Dependencies resolve(SootClass sc) {
        InputStream d = null;
        try {
            d = this.foundFile.inputStream();
            ClassReader clsr = new ClassReader(d);
            SootClassBuilder scb = new SootClassBuilder(sc);
            clsr.accept(scb, 4);
            IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
            deps.typesToSignature.addAll(scb.deps);
            IInitialResolver.Dependencies dependencies = deps;
            return dependencies;
        }
        catch (IOException e) {
            throw new RuntimeException("Error: Failed to create class reader from class source.", e);
        }
        finally {
            try {
                if (d != null) {
                    d.close();
                    d = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error: Failed to close source input stream.", e);
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        if (this.foundFile != null) {
            this.foundFile.close();
            this.foundFile = null;
        }
    }
}

