/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.toolkits.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.baf.toolkits.base.Peephole;

public class PeepholeOptimizer
extends BodyTransformer {
    private final String packageName = "soot.baf.toolkits.base";
    private static boolean peepholesLoaded = false;
    private static final Object loaderLock = new Object();
    private final Map<String, Class<?>> peepholeMap = new HashMap();

    public PeepholeOptimizer(Singletons.Global g) {
    }

    public static PeepholeOptimizer v() {
        return G.v().soot_baf_toolkits_base_PeepholeOptimizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (!peepholesLoaded) {
            Object object = loaderLock;
            synchronized (object) {
                if (!peepholesLoaded) {
                    peepholesLoaded = true;
                    InputStream peepholeListingStream = null;
                    peepholeListingStream = PeepholeOptimizer.class.getResourceAsStream("peephole.dat");
                    if (peepholeListingStream == null) {
                        throw new RuntimeException("could not open file peephole.dat!");
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(peepholeListingStream));
                    String line = null;
                    LinkedList<String> peepholes = new LinkedList<String>();
                    try {
                        line = reader.readLine();
                        while (line != null) {
                            if (line.length() > 0 && line.charAt(0) != '#') {
                                peepholes.add(line);
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("IO error occured while reading file:  " + line + System.getProperty("line.separator") + e);
                    }
                    try {
                        reader.close();
                        peepholeListingStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    for (String peepholeName : peepholes) {
                        Class<?> peepholeClass = this.peepholeMap.get(peepholeName);
                        if (peepholeClass != null) continue;
                        try {
                            peepholeClass = Class.forName("soot.baf.toolkits.base." + peepholeName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e.toString());
                        }
                        this.peepholeMap.put(peepholeName, peepholeClass);
                    }
                }
            }
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (String peepholeName : this.peepholeMap.keySet()) {
                boolean peepholeWorked = true;
                while (peepholeWorked) {
                    peepholeWorked = false;
                    Peephole p = null;
                    try {
                        p = (Peephole)this.peepholeMap.get(peepholeName).newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e.toString());
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e.toString());
                    }
                    if (!p.apply(body)) continue;
                    peepholeWorked = true;
                    changed = true;
                }
            }
        }
    }
}

