/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.toolkits.scalar.UnusedLocalEliminator;

public class DexArrayInitReducer
extends BodyTransformer {
    public static DexArrayInitReducer v() {
        return new DexArrayInitReducer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (!b.getTraps().isEmpty()) {
            return;
        }
        AssignStmt u1 = null;
        AssignStmt u2 = null;
        Iterator<Unit> uIt = b.getUnits().snapshotIterator();
        while (uIt.hasNext()) {
            Unit u = uIt.next();
            if (!(u instanceof AssignStmt) || !((Stmt)u).getBoxesPointingToThis().isEmpty()) {
                u1 = null;
                u2 = null;
                continue;
            }
            AssignStmt assignStmt = (AssignStmt)u;
            if (assignStmt.getLeftOp() instanceof ArrayRef) {
                if (u1 != null && u2 != null) {
                    ArrayRef arrayRef = (ArrayRef)assignStmt.getLeftOp();
                    Value u1val = u1.getDefBoxes().get(0).getValue();
                    Value u2val = u2.getDefBoxes().get(0).getValue();
                    if (arrayRef.getIndex() == u1val) {
                        arrayRef.setIndex(u1.getRightOp());
                    } else if (arrayRef.getIndex() == u2val) {
                        arrayRef.setIndex(u2.getRightOp());
                    }
                    if (assignStmt.getRightOp() == u1val) {
                        assignStmt.setRightOp(u1.getRightOp());
                    } else if (assignStmt.getRightOp() == u2val) {
                        assignStmt.setRightOp(u2.getRightOp());
                    }
                    Unit checkU = u;
                    boolean foundU1 = false;
                    boolean foundU2 = false;
                    boolean doneU1 = false;
                    boolean doneU2 = false;
                    while (!(doneU1 && doneU2 || foundU1 && foundU2 || checkU == null)) {
                        for (ValueBox vb : checkU.getUseBoxes()) {
                            if (!doneU1 && vb.getValue() == u1val) {
                                foundU1 = true;
                            }
                            if (doneU2 || vb.getValue() != u2val) continue;
                            foundU2 = true;
                        }
                        for (ValueBox vb : checkU.getDefBoxes()) {
                            if (vb.getValue() == u1val) {
                                doneU1 = true;
                                continue;
                            }
                            if (vb.getValue() != u2val) continue;
                            doneU2 = true;
                        }
                        if (checkU.branches()) {
                            foundU1 = true;
                            foundU2 = true;
                            break;
                        }
                        checkU = b.getUnits().getSuccOf(checkU);
                    }
                    if (!foundU1 && u1val instanceof Local) {
                        b.getUnits().remove(u1);
                        if (Options.v().verbose()) {
                            G.v().out.println("[" + b.getMethod().getName() + "]    remove 1 " + u1);
                        }
                    }
                    if (!foundU2 && u2val instanceof Local) {
                        b.getUnits().remove(u2);
                        if (Options.v().verbose()) {
                            G.v().out.println("[" + b.getMethod().getName() + "]    remove 2 " + u2);
                        }
                    }
                    u1 = null;
                    u2 = null;
                } else {
                    u1 = null;
                    u2 = null;
                    continue;
                }
            }
            if (!(assignStmt.getRightOp() instanceof Constant)) {
                u1 = null;
                u2 = null;
                continue;
            }
            if (u1 == null) {
                u1 = assignStmt;
                continue;
            }
            if (u2 == null) {
                u2 = assignStmt;
                continue;
            }
            u1 = u2;
            u2 = assignStmt;
        }
        UnusedLocalEliminator.v().transform(b);
    }
}

