/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassPathResolver;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.immutable.debug.ImmutableLineNumber;
import org.jf.dexlib2.util.MethodUtil;
import soot.Body;
import soot.DoubleType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Timer;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.dexpler.DalvikThrowAnalysis;
import soot.dexpler.Debug;
import soot.dexpler.DexArrayInitReducer;
import soot.dexpler.DexIfTransformer;
import soot.dexpler.DexJumpChainShortener;
import soot.dexpler.DexNullArrayRefTransformer;
import soot.dexpler.DexNullThrowTransformer;
import soot.dexpler.DexNullTransformer;
import soot.dexpler.DexNumTransformer;
import soot.dexpler.DexReturnInliner;
import soot.dexpler.DexReturnPacker;
import soot.dexpler.DexReturnValuePropagator;
import soot.dexpler.DexTrapStackFixer;
import soot.dexpler.DexType;
import soot.dexpler.InvalidDalvikBytecodeException;
import soot.dexpler.TrapMinimizer;
import soot.dexpler.instructions.DanglingInstruction;
import soot.dexpler.instructions.DeferableInstruction;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.InstructionFactory;
import soot.dexpler.instructions.MoveExceptionInstruction;
import soot.dexpler.instructions.OdexInstruction;
import soot.dexpler.instructions.PseudoInstruction;
import soot.dexpler.instructions.RetypeableInstruction;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantCastEliminator;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;
import soot.toolkits.exceptions.TrapTightener;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.UnusedLocalEliminator;

public class DexBody {
    private List<DexlibAbstractInstruction> instructions;
    private Local[] registerLocals;
    private Local storeResultLocal;
    private Map<Integer, DexlibAbstractInstruction> instructionAtAddress;
    private LocalGenerator localGenerator;
    private List<DeferableInstruction> deferredInstructions;
    private Set<RetypeableInstruction> instructionsToRetype;
    private DanglingInstruction dangling;
    private int numRegisters;
    private int numParameterRegisters;
    private final List<Type> parameterTypes;
    private boolean isStatic;
    private String methodSignature = "";
    private JimpleBody jBody;
    private List<? extends TryBlock<? extends ExceptionHandler>> tries;
    private RefType declaringClassType;
    private final DexFile dexFile;
    private final Method method;
    private ArrayList<PseudoInstruction> pseudoInstructionData = new ArrayList();
    private LocalSplitter localSplitter = null;
    private TrapTightener trapTightener = null;
    private UnreachableCodeEliminator unreachableCodeEliminator = null;
    private CopyPropagator copyPropagator = null;

    PseudoInstruction isAddressInData(int a) {
        for (PseudoInstruction pi : this.pseudoInstructionData) {
            int fb = pi.getDataFirstByte();
            int lb = pi.getDataLastByte();
            if (fb > a || a > lb) continue;
            return pi;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public DexBody(DexFile dexFile, Method method, RefType declaringClassType) {
        MethodImplementation code = method.getImplementation();
        if (code == null) {
            throw new RuntimeException("error: no code for method " + method.getName());
        }
        this.declaringClassType = declaringClassType;
        this.tries = code.getTryBlocks();
        this.methodSignature = method.getDefiningClass() + ": " + method.getReturnType() + " " + method.getName() + "(";
        for (MethodParameter methodParameter : method.getParameters()) {
            this.methodSignature = this.methodSignature + methodParameter.getType() + ",";
        }
        List<? extends CharSequence> paramTypes = method.getParameterTypes();
        if (paramTypes != null) {
            this.parameterTypes = new ArrayList<Type>();
            for (CharSequence charSequence : paramTypes) {
                this.parameterTypes.add(DexType.toSoot(charSequence.toString()));
            }
        } else {
            this.parameterTypes = Collections.emptyList();
        }
        this.isStatic = Modifier.isStatic(method.getAccessFlags());
        this.numRegisters = code.getRegisterCount();
        this.numParameterRegisters = MethodUtil.getParameterRegisterCount(method);
        if (!this.isStatic) {
            --this.numParameterRegisters;
        }
        this.instructions = new ArrayList<DexlibAbstractInstruction>();
        this.instructionAtAddress = new HashMap<Integer, DexlibAbstractInstruction>();
        this.registerLocals = new Local[this.numRegisters];
        boolean bl = false;
        for (Instruction instruction : code.getInstructions()) {
            void var6_10;
            DexlibAbstractInstruction dexInstruction = InstructionFactory.fromInstruction(instruction, (int)var6_10);
            this.instructions.add(dexInstruction);
            this.instructionAtAddress.put((int)var6_10, dexInstruction);
            Debug.printDbg(" put instruction '", dexInstruction, "' at 0x", Integer.toHexString((int)var6_10));
            var6_10 += instruction.getCodeUnits();
        }
        if (this.numParameterRegisters > this.numRegisters) {
            throw new RuntimeException("Malformed dex file: insSize (" + this.numParameterRegisters + ") > registersSize (" + this.numRegisters + ")");
        }
        for (DebugItem debugItem : code.getDebugItems()) {
            if (!(debugItem instanceof ImmutableLineNumber)) continue;
            ImmutableLineNumber ln = (ImmutableLineNumber)debugItem;
            DexlibAbstractInstruction ins = this.instructionAtAddress(ln.getCodeAddress());
            if (ins == null) {
                Debug.printDbg("Line number tag pointing to invalid offset: " + ln.getCodeAddress(), new Object[0]);
                continue;
            }
            ins.setLineNumber(ln.getLineNumber());
            Debug.printDbg("Add line number tag " + ln.getLineNumber() + " for instruction: " + this.instructionAtAddress(ln.getCodeAddress()), new Object[0]);
        }
        this.dexFile = dexFile;
        this.method = method;
    }

    public Set<Type> usedTypes() {
        HashSet<Type> types = new HashSet<Type>();
        for (DexlibAbstractInstruction dexlibAbstractInstruction : this.instructions) {
            types.addAll(dexlibAbstractInstruction.introducedTypes());
        }
        if (this.tries != null) {
            for (TryBlock tryBlock : this.tries) {
                List hList = tryBlock.getExceptionHandlers();
                for (ExceptionHandler handler : hList) {
                    String exType = handler.getExceptionType();
                    if (exType == null) continue;
                    types.add(DexType.toSoot(exType));
                }
            }
        }
        return types;
    }

    public void add(Unit u) {
        this.getBody().getUnits().add(u);
    }

    public void addDeferredJimplification(DeferableInstruction i) {
        this.deferredInstructions.add(i);
    }

    public void addRetype(RetypeableInstruction i) {
        this.instructionsToRetype.add(i);
    }

    public Local generateLocal(Type t) {
        return this.localGenerator.generateLocal(t);
    }

    public Body getBody() {
        if (this.jBody == null) {
            throw new RuntimeException("No jimplification happened yet, no body available.");
        }
        return this.jBody;
    }

    public Local[] getRegisterLocals() {
        return this.registerLocals;
    }

    public Local getRegisterLocal(int num) throws InvalidDalvikBytecodeException {
        int totalRegisters = this.registerLocals.length;
        if (num > totalRegisters) {
            throw new InvalidDalvikBytecodeException("Trying to access register " + num + " but only " + totalRegisters + " is/are available.");
        }
        return this.registerLocals[num];
    }

    public Local getStoreResultLocal() {
        return this.storeResultLocal;
    }

    public DexlibAbstractInstruction instructionAtAddress(int address) {
        DexlibAbstractInstruction i = null;
        while (i == null && address >= 0) {
            i = this.instructionAtAddress.get(address);
            --address;
        }
        return i;
    }

    public Body jimplify(Body b, SootMethod m) {
        Timer t_whole_jimplification = new Timer();
        Timer t_num = new Timer();
        Timer t_null = new Timer();
        t_whole_jimplification.start();
        this.jBody = (JimpleBody)b;
        this.localGenerator = new LocalGenerator(this.jBody);
        this.deferredInstructions = new ArrayList<DeferableInstruction>();
        this.instructionsToRetype = new HashSet<RetypeableInstruction>();
        Debug.printDbg("\n[jimplify] start for: ", this.methodSignature);
        LinkedList<Local> paramLocals = new LinkedList<Local>();
        if (!this.isStatic) {
            int thisRegister = this.numRegisters - this.numParameterRegisters - 1;
            Local thisLocal = Jimple.v().newLocal("$u" + thisRegister, UnknownType.v());
            this.jBody.getLocals().add(thisLocal);
            this.registerLocals[thisRegister] = thisLocal;
            JIdentityStmt idStmt = (JIdentityStmt)Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(this.declaringClassType));
            this.add(idStmt);
            paramLocals.add(thisLocal);
        }
        int i = 0;
        int parameterRegister = this.numRegisters - this.numParameterRegisters;
        for (Type t : this.parameterTypes) {
            Local local = Jimple.v().newLocal("$u" + parameterRegister, UnknownType.v());
            this.jBody.getLocals().add(local);
            Debug.printDbg("add local for parameter register number: ", parameterRegister);
            this.registerLocals[parameterRegister] = local;
            JIdentityStmt idStmt = (JIdentityStmt)Jimple.v().newIdentityStmt(local, Jimple.v().newParameterRef(t, i++));
            this.add(idStmt);
            paramLocals.add(local);
            if (t instanceof LongType || t instanceof DoubleType) {
                Local g = Jimple.v().newLocal("$u" + ++parameterRegister, UnknownType.v());
                this.jBody.getLocals().add(g);
                this.registerLocals[parameterRegister] = g;
            }
            ++parameterRegister;
        }
        for (i = 0; i < this.numRegisters - this.numParameterRegisters - (this.isStatic ? 0 : 1); ++i) {
            Debug.printDbg("add local for register number: ", i);
            this.registerLocals[i] = Jimple.v().newLocal("$u" + i, UnknownType.v());
            this.jBody.getLocals().add(this.registerLocals[i]);
        }
        this.storeResultLocal = Jimple.v().newLocal("$u-1", UnknownType.v());
        this.jBody.getLocals().add(this.storeResultLocal);
        boolean isOdex = this.dexFile instanceof DexBackedDexFile ? ((DexBackedDexFile)this.dexFile).isOdexFile() : false;
        ClassPath cp = null;
        if (isOdex) {
            String[] sootClasspath = Options.v().soot_classpath().split(File.pathSeparator);
            ArrayList<String> classpathList = new ArrayList<String>();
            for (String str : sootClasspath) {
                classpathList.add(str);
            }
            try {
                ClassPathResolver classPathResolver = new ClassPathResolver(classpathList, classpathList, classpathList, this.dexFile);
                cp = new ClassPath(classPathResolver.getResolvedClassProviders().toArray(new ClassProvider[0]));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        int prevLineNumber = -1;
        for (DexlibAbstractInstruction dexlibAbstractInstruction : this.instructions) {
            if (isOdex && dexlibAbstractInstruction instanceof OdexInstruction) {
                ((OdexInstruction)((Object)dexlibAbstractInstruction)).deOdex(this.dexFile, this.method, cp);
            }
            if (this.dangling != null) {
                this.dangling.finalize(this, dexlibAbstractInstruction);
                this.dangling = null;
            }
            dexlibAbstractInstruction.jimplify(this);
            if (dexlibAbstractInstruction.getLineNumber() > 0) {
                prevLineNumber = dexlibAbstractInstruction.getLineNumber();
                continue;
            }
            dexlibAbstractInstruction.setLineNumber(prevLineNumber);
        }
        for (DeferableInstruction deferableInstruction : this.deferredInstructions) {
            deferableInstruction.deferredJimplify(this);
        }
        if (this.tries != null) {
            this.addTraps();
        }
        this.instructions = null;
        this.instructionAtAddress.clear();
        this.deferredInstructions = null;
        this.dangling = null;
        this.tries = null;
        Debug.printDbg("body before any transformation : ", m, "\n", this.jBody);
        Debug.printDbg("\nbefore splitting", new Object[0]);
        Debug.printDbg("", this.jBody);
        DexTrapStackFixer.v().transform(this.jBody);
        DexJumpChainShortener.v().transform(this.jBody);
        DexReturnInliner.v().transform(this.jBody);
        DexArrayInitReducer.v().transform(this.jBody);
        this.getLocalSplitter().transform(this.jBody);
        this.getUnreachableCodeEliminator().transform(this.jBody);
        DeadAssignmentEliminator.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        Debug.printDbg("\nafter splitting", new Object[0]);
        Debug.printDbg("", this.jBody);
        for (RetypeableInstruction retypeableInstruction : this.instructionsToRetype) {
            retypeableInstruction.retype(this.jBody);
        }
        t_num.start();
        DexNumTransformer.v().transform(this.jBody);
        t_num.end();
        DexReturnValuePropagator.v().transform(this.jBody);
        this.getCopyPopagator().transform(this.jBody);
        DexNullThrowTransformer.v().transform(this.jBody);
        t_null.start();
        DexNullTransformer.v().transform(this.jBody);
        t_null.end();
        DexIfTransformer.v().transform(this.jBody);
        DeadAssignmentEliminator.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        DexNullArrayRefTransformer.v().transform(this.jBody);
        Debug.printDbg("\nafter Num and Null transformers", new Object[0]);
        Debug.printDbg("", this.jBody);
        TypeAssigner.v().transform(this.jBody);
        LocalPacker.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        LocalNameStandardizer.v().transform(this.jBody);
        Debug.printDbg("\nafter type assigner localpacker and name standardizer", new Object[0]);
        Debug.printDbg("", this.jBody);
        TrapTightener.v().transform(this.jBody);
        TrapMinimizer.v().transform(this.jBody);
        Aggregator.v().transform(this.jBody);
        ConditionalBranchFolder.v().transform(this.jBody);
        ConstantCastEliminator.v().transform(this.jBody);
        UnreachableCodeEliminator.v().transform(this.jBody);
        DeadAssignmentEliminator.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        NopEliminator.v().transform(this.jBody);
        DexReturnPacker.v().transform(this.jBody);
        for (Unit unit : this.jBody.getUnits()) {
            RefType rt;
            Type t;
            DefinitionStmt def;
            CastExpr c;
            AssignStmt ass;
            if (unit instanceof AssignStmt && (ass = (AssignStmt)unit).getRightOp() instanceof CastExpr && (c = (CastExpr)ass.getRightOp()).getType() instanceof NullType) {
                Debug.printDbg("replacing cast to null_type by nullConstant assignment in ", unit);
                ass.setRightOp(NullConstant.v());
            }
            if (!(unit instanceof DefinitionStmt) || !((def = (DefinitionStmt)unit).getLeftOp() instanceof Local) || !(def.getRightOp() instanceof CaughtExceptionRef) || !((t = def.getLeftOp().getType()) instanceof RefType) || !(rt = (RefType)t).getSootClass().isPhantom() || rt.getSootClass().hasSuperclass() || rt.getSootClass().getName().equals("java.lang.Throwable")) continue;
            rt.getSootClass().setSuperclass(Scene.v().getSootClass("java.lang.Throwable"));
        }
        Debug.printDbg("\nafter jb pack", new Object[0]);
        Debug.printDbg("", this.jBody);
        for (Local local : this.jBody.getLocals()) {
            Type t = local.getType();
            if (!(t instanceof NullType)) continue;
            Debug.printDbg("replacing null_type by java.lang.Object for local ", local);
            local.setType(RefType.v("java.lang.Object"));
        }
        t_whole_jimplification.end();
        Debug.printDbg("timer whole jimlification: ", t_whole_jimplification.getTime());
        Debug.printDbg("timer num: ", t_num.getTime());
        Debug.printDbg("timer null: ", t_null.getTime());
        return this.jBody;
    }

    protected LocalSplitter getLocalSplitter() {
        if (this.localSplitter == null) {
            this.localSplitter = new LocalSplitter(DalvikThrowAnalysis.v());
        }
        return this.localSplitter;
    }

    protected TrapTightener getTrapTightener() {
        if (this.trapTightener == null) {
            this.trapTightener = new TrapTightener(DalvikThrowAnalysis.v());
        }
        return this.trapTightener;
    }

    protected UnreachableCodeEliminator getUnreachableCodeEliminator() {
        if (this.unreachableCodeEliminator == null) {
            this.unreachableCodeEliminator = new UnreachableCodeEliminator(DalvikThrowAnalysis.v());
        }
        return this.unreachableCodeEliminator;
    }

    protected CopyPropagator getCopyPopagator() {
        if (this.copyPropagator == null) {
            this.copyPropagator = new CopyPropagator(DalvikThrowAnalysis.v(), false);
        }
        return this.copyPropagator;
    }

    public void setDanglingInstruction(DanglingInstruction i) {
        this.dangling = i;
    }

    public List<DexlibAbstractInstruction> instructionsAfter(DexlibAbstractInstruction instruction) {
        int i = this.instructions.indexOf(instruction);
        if (i == -1) {
            throw new IllegalArgumentException("Instruction" + instruction + "not part of this body.");
        }
        return this.instructions.subList(i + 1, this.instructions.size());
    }

    public List<DexlibAbstractInstruction> instructionsBefore(DexlibAbstractInstruction instruction) {
        int i = this.instructions.indexOf(instruction);
        if (i == -1) {
            throw new IllegalArgumentException("Instruction " + instruction + " not part of this body.");
        }
        ArrayList<DexlibAbstractInstruction> l = new ArrayList<DexlibAbstractInstruction>();
        l.addAll(this.instructions.subList(0, i));
        Collections.reverse(l);
        return l;
    }

    private void addTraps() {
        for (TryBlock<? extends ExceptionHandler> tryBlock : this.tries) {
            int startAddress = tryBlock.getStartCodeAddress();
            Debug.printDbg(" start : 0x", Integer.toHexString(startAddress));
            int length = tryBlock.getCodeUnitCount();
            Debug.printDbg(" length: 0x", Integer.toHexString(length));
            Debug.printDbg(" end   : 0x", Integer.toHexString(startAddress + length));
            int endAddress = startAddress + length;
            Unit beginStmt = this.instructionAtAddress(startAddress).getUnit();
            Unit endStmt = this.instructionAtAddress(endAddress).getUnit();
            if (this.jBody.getUnits().getLast() == endStmt && this.instructionAtAddress(endAddress - 1).getUnit() == endStmt) {
                NopStmt nop = Jimple.v().newNopStmt();
                this.jBody.getUnits().insertAfter(nop, endStmt);
                endStmt = nop;
            }
            Debug.printDbg("begin instruction (0x", Integer.toHexString(startAddress), "): ", this.instructionAtAddress(startAddress).getUnit(), " --- ", beginStmt);
            Debug.printDbg("end instruction   (0x", Integer.toHexString(endAddress), "): ", this.instructionAtAddress(endAddress).getUnit(), " --- ", endStmt);
            List<? extends ExceptionHandler> hList = tryBlock.getExceptionHandlers();
            for (ExceptionHandler exceptionHandler : hList) {
                Type t;
                int handlerAddress = exceptionHandler.getHandlerCodeAddress();
                Debug.printDbg("handler   (0x", Integer.toHexString(handlerAddress), "): ", this.instructionAtAddress(handlerAddress).getUnit(), " --- ", handlerAddress > 0 ? this.instructionAtAddress(handlerAddress - 1).getUnit() : "<unknown>");
                String exceptionType = exceptionHandler.getExceptionType();
                if (exceptionType == null) {
                    exceptionType = "Ljava/lang/Throwable;";
                }
                if (!((t = DexType.toSoot(exceptionType)) instanceof RefType)) continue;
                SootClass exception = ((RefType)t).getSootClass();
                DexlibAbstractInstruction instruction = this.instructionAtAddress(exceptionHandler.getHandlerCodeAddress());
                if (!(instruction instanceof MoveExceptionInstruction)) {
                    Debug.printDbg("First instruction of trap handler unit not MoveException but ", instruction.getClass());
                } else {
                    ((MoveExceptionInstruction)instruction).setRealType(this, exception.getType());
                }
                Trap trap = Jimple.v().newTrap(exception, beginStmt, endStmt, instruction.getUnit());
                this.jBody.getTraps().add(trap);
            }
        }
    }
}

