/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Iterator;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.dexpler.DexAnnotation;
import soot.dexpler.DexField;
import soot.dexpler.DexMethod;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.Tag;

public class DexClassLoader {
    private void loadMethod(DexFile dexFile, Method method, SootClass declaringClass, DexAnnotation annotations) {
        SootMethod sm = DexMethod.makeSootMethod(dexFile, method, declaringClass);
        if (declaringClass.declaresMethod(sm.getName(), sm.getParameterTypes(), sm.getReturnType())) {
            return;
        }
        declaringClass.addMethod(sm);
        annotations.handleMethodAnnotation(sm, method);
    }

    public IInitialResolver.Dependencies makeSootClass(SootClass sc, ClassDef defItem, DexFile dexFile) {
        SootField sootField;
        String superClass = defItem.getSuperclass();
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        String sourceFile = defItem.getSourceFile();
        if (sourceFile != null) {
            sc.addTag(new SourceFileTag(sourceFile));
        }
        if (superClass != null) {
            String superClassName = Util.dottedClassName(superClass);
            SootClass sootSuperClass = SootResolver.v().makeClassRef(superClassName);
            sc.setSuperclass(sootSuperClass);
            deps.typesToHierarchy.add(sootSuperClass.getType());
        }
        int accessFlags = defItem.getAccessFlags();
        sc.setModifiers(accessFlags);
        if (defItem.getInterfaces() != null) {
            for (String string : defItem.getInterfaces()) {
                String string2 = Util.dottedClassName(string);
                if (sc.implementsInterface(string2)) continue;
                SootClass interfaceClass = SootResolver.v().makeClassRef(string2);
                interfaceClass.setModifiers(interfaceClass.getModifiers() | 0x200);
                sc.addInterface(interfaceClass);
                deps.typesToHierarchy.add(interfaceClass.getType());
            }
        }
        if (Options.v().oaat() && sc.resolvingLevel() <= 1) {
            return deps;
        }
        DexAnnotation da = new DexAnnotation(sc, deps);
        for (Field field : defItem.getStaticFields()) {
            if (sc.declaresField(field.getName(), DexType.toSoot(field.getType()))) continue;
            sootField = DexField.makeSootField(field);
            sc.addField(sootField);
            da.handleFieldAnnotation(sootField, field);
        }
        for (Field field : defItem.getInstanceFields()) {
            if (sc.declaresField(field.getName(), DexType.toSoot(field.getType()))) continue;
            sootField = DexField.makeSootField(field);
            sc.addField(sootField);
            da.handleFieldAnnotation(sootField, field);
        }
        for (Method method : defItem.getDirectMethods()) {
            this.loadMethod(dexFile, method, sc, da);
        }
        for (Method method : defItem.getVirtualMethods()) {
            this.loadMethod(dexFile, method, sc, da);
        }
        da.handleClassAnnotation(defItem);
        InnerClassAttribute innerClassAttribute = (InnerClassAttribute)sc.getTag("InnerClassAttribute");
        if (innerClassAttribute != null) {
            Iterator<InnerClassTag> iterator = innerClassAttribute.getSpecs().iterator();
            while (iterator.hasNext()) {
                InnerClassTag ict;
                String inner;
                Tag t = iterator.next();
                if (!(t instanceof InnerClassTag) || !(inner = (ict = (InnerClassTag)t).getInnerClass().replaceAll("/", ".")).equals(sc.getName())) continue;
                String outer = null;
                outer = ict.getOuterClass() == null ? ict.getInnerClass().replaceAll("\\$[0-9].*$", "").replaceAll("/", ".") : ict.getOuterClass().replaceAll("/", ".");
                SootClass osc = SootResolver.v().makeClassRef(outer);
                if (osc == sc) {
                    if (!sc.hasOuterClass()) continue;
                    osc = sc.getOuterClass();
                } else {
                    deps.typesToHierarchy.add(osc.getType());
                }
                InnerClassAttribute icat = (InnerClassAttribute)osc.getTag("InnerClassAttribute");
                if (icat == null) {
                    icat = new InnerClassAttribute();
                    osc.addTag(icat);
                }
                InnerClassTag newt = new InnerClassTag(ict.getInnerClass(), ict.getOuterClass(), ict.getShortName(), ict.getAccessFlags());
                icat.add(newt);
                iterator.remove();
                if (sc.hasTag("InnerClassTag") || !((InnerClassTag)t).getInnerClass().replaceAll("/", ".").equals(sc.toString())) continue;
                sc.addTag(t);
            }
            if (innerClassAttribute.getSpecs().isEmpty()) {
                sc.getTags().remove(innerClassAttribute);
            }
        }
        return deps;
    }
}

