/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.toolkits.scalar.LocalDefs;

public class DexDefUseAnalysis
implements LocalDefs {
    private final Body body;
    private Map<Local, Set<Unit>> localToUses = new HashMap<Local, Set<Unit>>();
    private Map<Local, Set<Unit>> localToDefs = new HashMap<Local, Set<Unit>>();
    private Map<Local, Set<Unit>> localToDefsWithAliases = new HashMap<Local, Set<Unit>>();

    public DexDefUseAnalysis(Body body) {
        this.body = body;
    }

    public Set<Unit> getUsesOf(Local l) {
        Set<Unit> uses = this.localToUses.get(l);
        if (uses == null) {
            uses = new HashSet<Unit>();
            for (Unit u : this.body.getUnits()) {
                for (ValueBox vb : u.getUseBoxes()) {
                    if (vb.getValue() != l) continue;
                    uses.add(u);
                }
            }
            this.localToUses.put(l, uses);
        }
        return uses;
    }

    protected Set<Unit> collectDefinitionsWithAliases(Local l) {
        Set<Unit> defs = this.localToDefsWithAliases.get(l);
        if (defs == null) {
            HashSet<Local> seenLocals = new HashSet<Local>();
            defs = new HashSet<Unit>();
            ArrayList<Local> newLocals = new ArrayList<Local>();
            newLocals.add(l);
            while (!newLocals.isEmpty()) {
                Local curLocal = (Local)newLocals.remove(0);
                for (Unit defUnit : this.getDefsOf(curLocal)) {
                    defs.add(defUnit);
                    DefinitionStmt defStmt = (DefinitionStmt)defUnit;
                    if (!(defStmt.getRightOp() instanceof Local) || !seenLocals.add((Local)defStmt.getRightOp())) continue;
                    newLocals.add((Local)defStmt.getRightOp());
                }
                for (Unit use : this.getUsesOf(curLocal)) {
                    AssignStmt assignUse;
                    if (!(use instanceof AssignStmt) || (assignUse = (AssignStmt)use).getRightOp() != curLocal || !(assignUse.getLeftOp() instanceof Local) || !seenLocals.add((Local)assignUse.getLeftOp())) continue;
                    newLocals.add((Local)assignUse.getLeftOp());
                }
            }
            this.localToDefsWithAliases.put(l, defs);
        }
        return defs;
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s) {
        return this.getDefsOf(l);
    }

    @Override
    public List<Unit> getDefsOf(Local l) {
        Set<Unit> defs = this.localToDefs.get(l);
        if (defs == null) {
            defs = new HashSet<Unit>();
            for (Unit u : this.body.getUnits()) {
                if (!(u instanceof DefinitionStmt) || ((DefinitionStmt)u).getLeftOp() != l) continue;
                defs.add(u);
            }
            this.localToDefs.put(l, defs);
        }
        return new ArrayList<Unit>(defs);
    }
}

