/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import soot.ArrayType;
import soot.PrimType;
import soot.Scene;
import soot.SootClass;
import soot.SootResolver;
import soot.Type;
import soot.VoidType;
import soot.dexpler.Debug;
import soot.dexpler.DexClassLoader;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;

public class DexlibWrapper {
    private List<DexFile> dexFiles;
    private final DexClassLoader dexLoader = new DexClassLoader();
    private final Map<String, ClassDef> classesToDefItems = new HashMap<String, ClassDef>();
    private static final Set<String> systemAnnotationNames;
    private final File inputDexFile;

    public DexlibWrapper(File inputDexFile) {
        this.inputDexFile = inputDexFile;
        this.dexFiles = new ArrayList<DexFile>();
    }

    public void initialize() {
        ZipFile archive = null;
        try {
            int api = 24;
            if (Options.v().process_multiple_dex() && (this.inputDexFile.getName().endsWith(".apk") || this.inputDexFile.getName().endsWith(".zip") || this.inputDexFile.getName().endsWith(".jar"))) {
                archive = new ZipFile(this.inputDexFile);
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String string = entry.getName();
                    if (!string.endsWith(".dex")) continue;
                    this.dexFiles.add(DexFileFactory.loadDexEntry(this.inputDexFile, string, true, Opcodes.forApi(api)));
                }
            } else {
                this.dexFiles.add(DexFileFactory.loadDexFile(this.inputDexFile, Opcodes.forApi(api)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (Throwable throwable) {}
        }
        for (DexFile dexFile : this.dexFiles) {
            for (ClassDef classDef : dexFile.getClasses()) {
                String forClassName = Util.dottedClassName(classDef.getType());
                this.classesToDefItems.put(forClassName, classDef);
            }
        }
        for (DexFile dexFile : this.dexFiles) {
            if (dexFile instanceof DexBackedDexFile) {
                DexBackedDexFile dbdf = (DexBackedDexFile)dexFile;
                for (int i = 0; i < dbdf.getTypeCount(); ++i) {
                    String t = dbdf.getType(i);
                    Type st = DexType.toSoot(t);
                    if (st instanceof ArrayType) {
                        st = ((ArrayType)st).baseType;
                    }
                    Debug.printDbg("Type: ", t, " soot type:", st);
                    String sootTypeName = st.toString();
                    if (!Scene.v().containsClass(sootTypeName)) {
                        if (st instanceof PrimType || st instanceof VoidType || systemAnnotationNames.contains(sootTypeName)) continue;
                        SootResolver.v().makeClassRef(sootTypeName);
                    }
                    SootResolver.v().resolveClass(sootTypeName, 2);
                }
                continue;
            }
            System.out.println("Warning: DexFile not instance of DexBackedDexFile! Not resolving types!");
            System.out.println("type: " + dexFile.getClass());
        }
    }

    public IInitialResolver.Dependencies makeSootClass(SootClass sc, String className) {
        Iterator<DexFile> iterator;
        if (Util.isByteCodeClassName(className)) {
            className = Util.dottedClassName(className);
        }
        if ((iterator = this.dexFiles.iterator()).hasNext()) {
            DexFile dexFile = iterator.next();
            ClassDef defItem = this.classesToDefItems.get(className);
            return this.dexLoader.makeSootClass(sc, defItem, dexFile);
        }
        throw new RuntimeException("Error: class not found in DEX files: " + className);
    }

    static {
        HashSet<String> systemAnnotationNamesModifiable = new HashSet<String>();
        systemAnnotationNamesModifiable.add("dalvik.annotation.AnnotationDefault");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingMethod");
        systemAnnotationNamesModifiable.add("dalvik.annotation.InnerClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.MemberClasses");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Signature");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Throws");
        systemAnnotationNames = Collections.unmodifiableSet(systemAnnotationNamesModifiable);
    }
}

