/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import heros.solver.CountingThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.PatchingChain;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.AbstractBulkAliasStrategy;
import soot.jimple.infoflow.aliasing.FlowSensitiveAliasStrategy;
import soot.jimple.infoflow.aliasing.PtsBasedAliasStrategy;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.codeOptimization.DeadCodeEliminator;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.data.FlowDroidMemoryManager;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler2;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.BackwardsInfoflowProblem;
import soot.jimple.infoflow.problems.InfoflowProblem;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.BackwardsInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.fastSolver.BackwardsInfoflowSolver;
import soot.jimple.infoflow.solver.fastSolver.InfoflowSolver;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.options.Options;
import soot.util.queue.QueueReader;

public class Infoflow
extends AbstractInfoflow {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private InfoflowResults results = null;
    private IInfoflowCFG iCfg;
    private Set<ResultsAvailableHandler> onResultsAvailable = new HashSet<ResultsAvailableHandler>();
    private TaintPropagationHandler taintPropagationHandler = null;
    private TaintPropagationHandler backwardsPropagationHandler = null;
    private long maxMemoryConsumption = -1L;
    private Set<Stmt> collectedSources = null;
    private Set<Stmt> collectedSinks = null;

    public Infoflow() {
    }

    public Infoflow(String androidPath, boolean forceAndroidJar) {
        super(null, androidPath, forceAndroidJar);
        this.pathBuilderFactory = new DefaultPathBuilderFactory();
    }

    public Infoflow(String androidPath, boolean forceAndroidJar, BiDirICFGFactory icfgFactory, IPathBuilderFactory pathBuilderFactory) {
        super(icfgFactory, androidPath, forceAndroidJar);
        this.pathBuilderFactory = pathBuilderFactory == null ? new DefaultPathBuilderFactory() : pathBuilderFactory;
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, IEntryPointCreator entryPointCreator, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("Sources are empty!");
            return;
        }
        this.initializeSoot(appPath, libPath, entryPointCreator.getRequiredClasses());
        Scene.v().setEntryPoints(Collections.singletonList(entryPointCreator.createDummyMain()));
        this.runAnalysis(sourcesSinks, null);
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, String entryPoint, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("Sources are empty!");
            return;
        }
        this.initializeSoot(appPath, libPath, SootMethodRepresentationParser.v().parseClassNames(Collections.singletonList(entryPoint), false).keySet(), entryPoint);
        if (!Scene.v().containsMethod(entryPoint)) {
            this.logger.error("Entry point not found: " + entryPoint);
            return;
        }
        SootMethod ep = Scene.v().getMethod(entryPoint);
        if (!ep.isConcrete()) {
            this.logger.debug("Skipping non-concrete method " + ep);
            return;
        }
        ep.retrieveActiveBody();
        Scene.v().setEntryPoints(Collections.singletonList(ep));
        Options.v().set_main_class(ep.getDeclaringClass().getName());
        Set<String> seeds = Collections.emptySet();
        if (entryPoint != null && !entryPoint.isEmpty()) {
            seeds = Collections.singleton(entryPoint);
        }
        this.ipcManager.updateJimpleForICC();
        this.runAnalysis(sourcesSinks, seeds);
    }

    protected void runAnalysis(ISourceSinkManager sourcesSinks) {
        this.runAnalysis(sourcesSinks, null);
    }

    private void runAnalysis(ISourceSinkManager sourcesSinks, Set<String> additionalSeeds) {
        AbstractBulkAliasStrategy aliasingStrategy;
        this.maxMemoryConsumption = -1L;
        this.results = null;
        if (this.config.getEnableStaticFieldTracking() && InfoflowConfiguration.getAccessPathLength() == 0) {
            throw new RuntimeException("Static field tracking must be disabled if the access path length is zero");
        }
        if (InfoflowConfiguration.getAccessPathLength() < 0) {
            throw new RuntimeException("The access path length may not be negative");
        }
        AccessPathFactory.v().clearBaseRegister();
        long beforeCallgraph = System.nanoTime();
        this.constructCallgraph();
        this.logger.info("Callgraph construction took " + (double)(System.nanoTime() - beforeCallgraph) / 1.0E9 + " seconds");
        if (this.config.getCodeEliminationMode() != InfoflowConfiguration.CodeEliminationMode.NoCodeElimination) {
            long currentMillis = System.nanoTime();
            this.eliminateDeadCode(sourcesSinks);
            this.logger.info("Dead code elimination took " + (double)(System.nanoTime() - currentMillis) / 1.0E9 + " seconds");
        }
        if (this.config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
            this.logger.info("Callgraph has {} edges", (Object)Scene.v().getCallGraph().size());
        }
        if (!this.config.isTaintAnalysisEnabled()) {
            return;
        }
        this.logger.info("Starting Taint Analysis");
        this.iCfg = this.icfgFactory.buildBiDirICFG(this.config.getCallgraphAlgorithm(), this.config.getEnableExceptionTracking());
        int numThreads = Runtime.getRuntime().availableProcessors();
        CountingThreadPoolExecutor executor = this.createExecutor(numThreads);
        FlowDroidMemoryManager.PathDataErasureMode erasureMode = FlowDroidMemoryManager.PathDataErasureMode.EraseAll;
        if (this.pathBuilderFactory.isContextSensitive()) {
            erasureMode = FlowDroidMemoryManager.PathDataErasureMode.KeepOnlyContextData;
        }
        if (this.pathBuilderFactory.supportsPathReconstruction()) {
            erasureMode = FlowDroidMemoryManager.PathDataErasureMode.EraseNothing;
        }
        FlowDroidMemoryManager memoryManager = new FlowDroidMemoryManager(false, erasureMode);
        InfoflowManager manager = new InfoflowManager(this.config, null, this.iCfg, sourcesSinks, this.taintWrapper, this.hierarchy);
        AbstractInfoflowProblem backProblem = null;
        InfoflowManager backwardsManager = null;
        BackwardsInfoflowSolver backSolver = null;
        switch (this.getConfig().getAliasingAlgorithm()) {
            case FlowSensitive: {
                backwardsManager = new InfoflowManager(this.config, null, new BackwardsInfoflowCFG(this.iCfg), sourcesSinks, this.taintWrapper, this.hierarchy);
                backProblem = new BackwardsInfoflowProblem(backwardsManager);
                backSolver = new BackwardsInfoflowSolver(backProblem, executor);
                backSolver.setMemoryManager(memoryManager);
                backSolver.setJumpPredecessors(!this.pathBuilderFactory.supportsPathReconstruction());
                aliasingStrategy = new FlowSensitiveAliasStrategy(this.iCfg, backSolver);
                break;
            }
            case PtsBased: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new PtsBasedAliasStrategy(this.iCfg);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported aliasing algorithm");
            }
        }
        Abstraction zeroValue = backProblem != null ? backProblem.createZeroValue() : null;
        InfoflowProblem forwardProblem = new InfoflowProblem(manager, aliasingStrategy, zeroValue);
        InfoflowSolver forwardSolver = new InfoflowSolver(forwardProblem, executor);
        aliasingStrategy.setForwardSolver(forwardSolver);
        manager.setForwardSolver(forwardSolver);
        if (backwardsManager != null) {
            backwardsManager.setForwardSolver(forwardSolver);
        }
        forwardSolver.setMemoryManager(memoryManager);
        forwardSolver.setJumpPredecessors(!this.pathBuilderFactory.supportsPathReconstruction());
        forwardProblem.setTaintPropagationHandler(this.taintPropagationHandler);
        forwardProblem.setTaintWrapper(this.taintWrapper);
        if (this.nativeCallHandler != null) {
            forwardProblem.setNativeCallHandler(this.nativeCallHandler);
        }
        if (backProblem != null) {
            ((BackwardsInfoflowProblem)backProblem).setForwardSolver(forwardSolver);
            backProblem.setTaintPropagationHandler(this.backwardsPropagationHandler);
            ((BackwardsInfoflowProblem)backProblem).setTaintWrapper(this.taintWrapper);
            if (this.nativeCallHandler != null) {
                backProblem.setNativeCallHandler(this.nativeCallHandler);
            }
            backProblem.setActivationUnitsToCallSites(forwardProblem);
        }
        this.config.printSummary();
        if (this.config.getFlowSensitiveAliasing() && !aliasingStrategy.isFlowSensitive()) {
            this.logger.warn("Trying to use a flow-sensitive aliasing with an aliasing strategy that does not support this feature");
        }
        int sinkCount = 0;
        this.logger.info("Looking for sources and sinks...");
        for (SootMethod sm : this.getMethodsForSeeds(this.iCfg)) {
            sinkCount += this.scanMethodForSourcesSinks(sourcesSinks, forwardProblem, sm);
        }
        if (additionalSeeds != null) {
            for (String meth : additionalSeeds) {
                SootMethod m = Scene.v().getMethod(meth);
                if (!m.hasActiveBody()) {
                    this.logger.warn("Seed method {} has no active body", (Object)m);
                    continue;
                }
                forwardProblem.addInitialSeeds((Unit)m.getActiveBody().getUnits().getFirst(), Collections.singleton(forwardProblem.zeroValue()));
            }
        }
        if (!forwardProblem.hasInitialSeeds()) {
            this.logger.error("No sources found, aborting analysis");
            return;
        }
        if (sinkCount == 0) {
            this.logger.error("No sinks found, aborting analysis");
            return;
        }
        this.logger.info("Source lookup done, found {} sources and {} sinks.", (Object)forwardProblem.getInitialSeeds().size(), (Object)sinkCount);
        if (this.taintWrapper != null) {
            this.taintWrapper.initialize(manager);
        }
        if (this.nativeCallHandler != null) {
            this.nativeCallHandler.initialize(manager);
        }
        TaintPropagationResults propagationResults = forwardProblem.getResults();
        CountingThreadPoolExecutor resultExecutor = this.createExecutor(numThreads);
        final IAbstractionPathBuilder builder = this.pathBuilderFactory.createPathBuilder(resultExecutor, this.iCfg);
        if (this.config.getIncrementalResultReporting()) {
            this.results = new InfoflowResults();
            propagationResults.addResultAvailableHandler(new TaintPropagationResults.OnTaintPropagationResultAdded(){

                @Override
                public boolean onResultAvailable(AbstractionAtSink abs) {
                    builder.addResultAvailableHandler(new IAbstractionPathBuilder.OnPathBuilderResultAvailable(){

                        @Override
                        public void onResultAvailable(ResultSourceInfo source, ResultSinkInfo sink) {
                            for (ResultsAvailableHandler handler : Infoflow.this.onResultsAvailable) {
                                if (!(handler instanceof ResultsAvailableHandler2)) continue;
                                ResultsAvailableHandler2 handler2 = (ResultsAvailableHandler2)handler;
                                handler2.onSingleResultAvailable(source, sink);
                            }
                            Infoflow.this.results.addResult(sink, source);
                        }
                    });
                    builder.computeTaintPaths(Collections.singleton(abs));
                    return true;
                }
            });
        }
        forwardSolver.solve();
        this.maxMemoryConsumption = Math.max(this.maxMemoryConsumption, this.getUsedMemory());
        int terminateTries = 0;
        while (!(terminateTries >= 10 || executor.getActiveCount() == 0 && executor.isTerminated())) {
            ++terminateTries;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.error("Could not wait for executor termination", e);
            }
        }
        if (executor.getActiveCount() != 0 || !executor.isTerminated()) {
            this.logger.error("Executor did not terminate gracefully");
        }
        if (this.taintWrapper != null) {
            this.logger.info("Taint wrapper hits: " + this.taintWrapper.getWrapperHits());
            this.logger.info("Taint wrapper misses: " + this.taintWrapper.getWrapperMisses());
        }
        Set<AbstractionAtSink> res = propagationResults.getResults();
        Iterator<AbstractionAtSink> absAtSinkIt = res.iterator();
        block13: while (absAtSinkIt.hasNext()) {
            AbstractionAtSink curAbs = absAtSinkIt.next();
            for (AbstractionAtSink checkAbs : res) {
                if (checkAbs == curAbs || checkAbs.getSinkStmt() != curAbs.getSinkStmt() || checkAbs.getAbstraction().isImplicit() != curAbs.getAbstraction().isImplicit() || checkAbs.getAbstraction().getSourceContext() != curAbs.getAbstraction().getSourceContext() || !checkAbs.getAbstraction().getAccessPath().entails(curAbs.getAbstraction().getAccessPath())) continue;
                absAtSinkIt.remove();
                continue block13;
            }
        }
        this.logger.info("IFDS problem with {} forward and {} backward edges solved, processing {} results...", forwardSolver.propagationCount, backSolver == null ? 0L : backSolver.propagationCount, res == null ? 0 : res.size());
        this.maxMemoryConsumption = Math.max(this.maxMemoryConsumption, this.getUsedMemory());
        forwardSolver.cleanup();
        if (backSolver != null) {
            backSolver.cleanup();
            backSolver = null;
            backProblem = null;
        }
        forwardSolver = null;
        forwardProblem = null;
        Runtime.getRuntime().gc();
        if (!this.config.getIncrementalResultReporting()) {
            builder.computeTaintPaths(res);
            if (this.results == null) {
                this.results = builder.getResults();
            } else {
                this.results.addAll(builder.getResults());
            }
        }
        try {
            resultExecutor.awaitCompletion();
        }
        catch (InterruptedException e) {
            this.logger.error("Could not wait for executor termination", e);
        }
        if (this.config.getIncrementalResultReporting()) {
            builder.runIncrementalPathCompuation();
            try {
                resultExecutor.awaitCompletion();
            }
            catch (InterruptedException e) {
                this.logger.error("Could not wait for executor termination", e);
            }
        }
        resultExecutor.shutdown();
        if (this.results == null || this.results.getResults().isEmpty()) {
            this.logger.warn("No results found.");
        } else {
            for (ResultSinkInfo sink : this.results.getResults().keySet()) {
                this.logger.info("The sink {} in method {} was called with values from the following sources:", (Object)sink, (Object)((SootMethod)this.iCfg.getMethodOf(sink.getSink())).getSignature());
                for (ResultSourceInfo source : this.results.getResults().get(sink)) {
                    this.logger.info("- {} in method {}", (Object)source, (Object)((SootMethod)this.iCfg.getMethodOf(source.getSource())).getSignature());
                    if (source.getPath() == null) continue;
                    this.logger.info("\ton Path: ");
                    for (Stmt p : source.getPath()) {
                        this.logger.info("\t -> " + this.iCfg.getMethodOf(p));
                        this.logger.info("\t\t -> " + p);
                    }
                }
            }
        }
        for (ResultsAvailableHandler handler : this.onResultsAvailable) {
            handler.onResultsAvailable(this.iCfg, this.results);
        }
        if (this.config.getWriteOutputFiles()) {
            PackManager.v().writeOutput();
        }
        this.maxMemoryConsumption = Math.max(this.maxMemoryConsumption, this.getUsedMemory());
        System.out.println("Maximum memory consumption: " + (double)this.maxMemoryConsumption / 1000000.0 + " MB");
    }

    private long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private void eliminateDeadCode(ISourceSinkManager sourcesSinks) {
        DeadCodeEliminator dce = new DeadCodeEliminator();
        dce.initialize(this.config);
        dce.run(this.iCfg, Scene.v().getEntryPoints(), sourcesSinks, this.taintWrapper);
    }

    private CountingThreadPoolExecutor createExecutor(int numThreads) {
        return new CountingThreadPoolExecutor(this.config.getMaxThreadNum() == -1 ? numThreads : Math.min(this.config.getMaxThreadNum(), numThreads), Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private Collection<SootMethod> getMethodsForSeeds(IInfoflowCFG icfg) {
        LinkedList<SootMethod> seeds = new LinkedList<SootMethod>();
        if (Scene.v().hasCallGraph()) {
            ArrayList<SootMethod> eps = new ArrayList<SootMethod>(Scene.v().getEntryPoints());
            ReachableMethods reachableMethods = new ReachableMethods(Scene.v().getCallGraph(), eps.iterator(), null);
            reachableMethods.update();
            QueueReader<MethodOrMethodContext> iter = reachableMethods.listener();
            while (iter.hasNext()) {
                seeds.add(((MethodOrMethodContext)iter.next()).method());
            }
        } else {
            long beforeSeedMethods = System.nanoTime();
            HashSet<SootMethod> doneSet = new HashSet<SootMethod>();
            for (SootMethod sm : Scene.v().getEntryPoints()) {
                this.getMethodsForSeedsIncremental(sm, doneSet, seeds, icfg);
            }
            this.logger.info("Collecting seed methods took {} seconds", (Object)((double)(System.nanoTime() - beforeSeedMethods) / 1.0E9));
        }
        return seeds;
    }

    private void getMethodsForSeedsIncremental(SootMethod sm, Set<SootMethod> doneSet, List<SootMethod> seeds, IInfoflowCFG icfg) {
        assert (Scene.v().hasFastHierarchy());
        if (!(sm.isConcrete() && sm.getDeclaringClass().isApplicationClass() && doneSet.add(sm))) {
            return;
        }
        seeds.add(sm);
        for (Unit u : sm.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr()) continue;
            for (SootMethod callee : icfg.getCalleesOfCallAt(stmt)) {
                this.getMethodsForSeedsIncremental(callee, doneSet, seeds, icfg);
            }
        }
    }

    private int scanMethodForSourcesSinks(ISourceSinkManager sourcesSinks, InfoflowProblem forwardProblem, SootMethod m) {
        if (this.getConfig().getLogSourcesAndSinks() && this.collectedSources == null) {
            this.collectedSources = new HashSet<Stmt>();
            this.collectedSinks = new HashSet<Stmt>();
        }
        int sinkCount = 0;
        if (m.hasActiveBody()) {
            String className = m.getDeclaringClass().getName();
            if (this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.isClassInSystemPackage(className)) {
                return sinkCount;
            }
            PatchingChain<Unit> units = m.getActiveBody().getUnits();
            for (Unit u : units) {
                Stmt s = (Stmt)u;
                if (sourcesSinks.getSourceInfo(s, this.iCfg) != null) {
                    forwardProblem.addInitialSeeds(u, Collections.singleton(forwardProblem.zeroValue()));
                    if (this.getConfig().getLogSourcesAndSinks()) {
                        this.collectedSources.add(s);
                    }
                    this.logger.debug("Source found: {}", (Object)u);
                }
                if (!sourcesSinks.isSink(s, this.iCfg, null)) continue;
                ++sinkCount;
                if (this.getConfig().getLogSourcesAndSinks()) {
                    this.collectedSinks.add(s);
                }
                this.logger.debug("Sink found: {}", (Object)u);
            }
        }
        return sinkCount;
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public boolean isResultAvailable() {
        return this.results != null;
    }

    public void addResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.add(handler);
    }

    public void setTaintPropagationHandler(TaintPropagationHandler handler) {
        this.taintPropagationHandler = handler;
    }

    public void setBackwardsPropagationHandler(TaintPropagationHandler handler) {
        this.backwardsPropagationHandler = handler;
    }

    public void removeResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.remove(handler);
    }

    public long getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public Set<Stmt> getCollectedSources() {
        return this.collectedSources;
    }

    public Set<Stmt> getCollectedSinks() {
        return this.collectedSinks;
    }
}

