/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoflowConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static int accessPathLength = 5;
    private static boolean useRecursiveAccessPaths = true;
    private static boolean useThisChainReduction = true;
    private static boolean pathAgnosticResults = true;
    private static boolean oneResultPerAccessPath = false;
    private static boolean mergeNeighbors = false;
    private static boolean useTypeTightening = true;
    private int stopAfterFirstKFlows = 0;
    private boolean enableImplicitFlows = false;
    private boolean enableStaticFields = true;
    private boolean enableExceptions = true;
    private boolean enableArraySizeTainting = true;
    private boolean flowSensitiveAliasing = true;
    private boolean enableTypeChecking = true;
    private boolean ignoreFlowsInSystemPackages = true;
    private int maxThreadNum = -1;
    private boolean writeOutputFiles = false;
    private boolean logSourcesAndSinks = false;
    private boolean inspectSources = false;
    private boolean inspectSinks = false;
    private CallgraphAlgorithm callgraphAlgorithm = CallgraphAlgorithm.AutomaticSelection;
    private AliasingAlgorithm aliasingAlgorithm = AliasingAlgorithm.FlowSensitive;
    private CodeEliminationMode codeEliminationMode = CodeEliminationMode.PropagateConstants;
    private boolean taintAnalysisEnabled = true;
    private boolean incrementalResultReporting = false;

    public void merge(InfoflowConfiguration config) {
        this.stopAfterFirstKFlows = config.stopAfterFirstKFlows;
        this.enableImplicitFlows = config.enableImplicitFlows;
        this.enableStaticFields = config.enableStaticFields;
        this.enableExceptions = config.enableExceptions;
        this.enableArraySizeTainting = config.enableArraySizeTainting;
        this.flowSensitiveAliasing = config.flowSensitiveAliasing;
        this.enableTypeChecking = config.enableTypeChecking;
        this.ignoreFlowsInSystemPackages = config.ignoreFlowsInSystemPackages;
        this.maxThreadNum = config.maxThreadNum;
        this.writeOutputFiles = config.writeOutputFiles;
        this.logSourcesAndSinks = config.logSourcesAndSinks;
        this.callgraphAlgorithm = config.callgraphAlgorithm;
        this.aliasingAlgorithm = config.aliasingAlgorithm;
        this.codeEliminationMode = config.codeEliminationMode;
        this.inspectSources = config.inspectSources;
        this.inspectSinks = config.inspectSinks;
        this.taintAnalysisEnabled = config.taintAnalysisEnabled;
        this.incrementalResultReporting = config.incrementalResultReporting;
    }

    public static int getAccessPathLength() {
        return accessPathLength;
    }

    public static void setAccessPathLength(int accessPathLength) {
        InfoflowConfiguration.accessPathLength = accessPathLength;
    }

    public static void setPathAgnosticResults(boolean pathAgnosticResults) {
        InfoflowConfiguration.pathAgnosticResults = pathAgnosticResults;
    }

    public static boolean getPathAgnosticResults() {
        return pathAgnosticResults;
    }

    public static boolean getOneResultPerAccessPath() {
        return oneResultPerAccessPath;
    }

    public static void setOneResultPerAccessPath(boolean oneResultPerAP) {
        oneResultPerAccessPath = oneResultPerAP;
    }

    public static boolean getMergeNeighbors() {
        return mergeNeighbors;
    }

    public static void setMergeNeighbors(boolean value) {
        mergeNeighbors = value;
    }

    public static boolean getUseTypeTightening() {
        return useTypeTightening;
    }

    public static void setUseTypeTightening(boolean useTypeTightening) {
        InfoflowConfiguration.useTypeTightening = useTypeTightening;
    }

    public static boolean getUseRecursiveAccessPaths() {
        return useRecursiveAccessPaths;
    }

    public static void setUseRecursiveAccessPaths(boolean useRecursiveAccessPaths) {
        InfoflowConfiguration.useRecursiveAccessPaths = useRecursiveAccessPaths;
    }

    public static boolean getUseThisChainReduction() {
        return useThisChainReduction;
    }

    public static void setUseThisChainReduction(boolean useThisChainReduction) {
        InfoflowConfiguration.useThisChainReduction = useThisChainReduction;
    }

    public void setStopAfterFirstKFlows(int stopAfterFirstKFlows) {
        this.stopAfterFirstKFlows = stopAfterFirstKFlows;
    }

    public int getStopAfterFirstKFlows() {
        return this.stopAfterFirstKFlows;
    }

    public void setStopAfterFirstFlow(boolean stopAfterFirstFlow) {
        this.stopAfterFirstKFlows = stopAfterFirstFlow ? 1 : 0;
    }

    public boolean getStopAfterFirstFlow() {
        return this.stopAfterFirstKFlows == 1;
    }

    public void setInspectSources(boolean inspect) {
        this.inspectSources = inspect;
    }

    public boolean getInspectSources() {
        return this.inspectSources;
    }

    public void setInspectSinks(boolean inspect) {
        this.inspectSinks = inspect;
    }

    public boolean getInspectSinks() {
        return this.inspectSinks;
    }

    public void setEnableImplicitFlows(boolean enableImplicitFlows) {
        this.enableImplicitFlows = enableImplicitFlows;
    }

    public boolean getEnableImplicitFlows() {
        return this.enableImplicitFlows;
    }

    public void setEnableStaticFieldTracking(boolean enableStaticFields) {
        this.enableStaticFields = enableStaticFields;
    }

    public boolean getEnableStaticFieldTracking() {
        return this.enableStaticFields;
    }

    public void setFlowSensitiveAliasing(boolean flowSensitiveAliasing) {
        this.flowSensitiveAliasing = flowSensitiveAliasing;
    }

    public boolean getFlowSensitiveAliasing() {
        return this.flowSensitiveAliasing;
    }

    public void setEnableExceptionTracking(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public boolean getEnableExceptionTracking() {
        return this.enableExceptions;
    }

    public void setEnableArraySizeTainting(boolean arrayLengthTainting) {
        this.enableArraySizeTainting = arrayLengthTainting;
    }

    public boolean getEnableArraySizeTainting() {
        return this.enableArraySizeTainting;
    }

    public void setCallgraphAlgorithm(CallgraphAlgorithm algorithm) {
        this.callgraphAlgorithm = algorithm;
    }

    public CallgraphAlgorithm getCallgraphAlgorithm() {
        return this.callgraphAlgorithm;
    }

    public void setAliasingAlgorithm(AliasingAlgorithm algorithm) {
        this.aliasingAlgorithm = algorithm;
    }

    public AliasingAlgorithm getAliasingAlgorithm() {
        return this.aliasingAlgorithm;
    }

    public void setEnableTypeChecking(boolean enableTypeChecking) {
        this.enableTypeChecking = enableTypeChecking;
    }

    public boolean getEnableTypeChecking() {
        return this.enableTypeChecking;
    }

    public void setIgnoreFlowsInSystemPackages(boolean ignoreFlowsInSystemPackages) {
        this.ignoreFlowsInSystemPackages = ignoreFlowsInSystemPackages;
    }

    public boolean getIgnoreFlowsInSystemPackages() {
        return this.ignoreFlowsInSystemPackages;
    }

    public void setMaxThreadNum(int threadNum) {
        this.maxThreadNum = threadNum;
    }

    public int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    public boolean getWriteOutputFiles() {
        return this.writeOutputFiles;
    }

    public void setWriteOutputFiles(boolean writeOutputFiles) {
        this.writeOutputFiles = writeOutputFiles;
    }

    public void setCodeEliminationMode(CodeEliminationMode mode) {
        this.codeEliminationMode = mode;
    }

    public CodeEliminationMode getCodeEliminationMode() {
        return this.codeEliminationMode;
    }

    public boolean getLogSourcesAndSinks() {
        return this.logSourcesAndSinks;
    }

    public void setLogSourcesAndSinks(boolean logSourcesAndSinks) {
        this.logSourcesAndSinks = logSourcesAndSinks;
    }

    public boolean isTaintAnalysisEnabled() {
        return this.taintAnalysisEnabled;
    }

    public void setTaintAnalysisEnabled(boolean taintAnalysisEnabled) {
        this.taintAnalysisEnabled = taintAnalysisEnabled;
    }

    public boolean getIncrementalResultReporting() {
        return this.incrementalResultReporting;
    }

    public void setIncrementalResultReporting(boolean incrementalReporting) {
        this.incrementalResultReporting = incrementalReporting;
    }

    public void printSummary() {
        if (!this.enableStaticFields) {
            this.logger.warn("Static field tracking is disabled, results may be incomplete");
        }
        if (!this.flowSensitiveAliasing) {
            this.logger.warn("Using flow-insensitive alias tracking, results may be imprecise");
        }
        if (this.enableImplicitFlows) {
            this.logger.info("Implicit flow tracking is enabled");
        } else {
            this.logger.info("Implicit flow tracking is NOT enabled");
        }
        if (this.enableExceptions) {
            this.logger.info("Exceptional flow tracking is enabled");
        } else {
            this.logger.info("Exceptional flow tracking is NOT enabled");
        }
        this.logger.info("Running with a maximum access path length of {}", (Object)InfoflowConfiguration.getAccessPathLength());
        if (pathAgnosticResults) {
            this.logger.info("Using path-agnostic result collection");
        } else {
            this.logger.info("Using path-sensitive result collection");
        }
        if (useRecursiveAccessPaths) {
            this.logger.info("Recursive access path shortening is enabled");
        } else {
            this.logger.info("Recursive access path shortening is NOT enabled");
        }
        this.logger.info("Taint analysis enabled: " + this.taintAnalysisEnabled);
    }

    public static enum CodeEliminationMode {
        NoCodeElimination,
        PropagateConstants,
        RemoveSideEffectFreeCode;

    }

    public static enum AliasingAlgorithm {
        FlowSensitive,
        PtsBased;

    }

    public static enum CallgraphAlgorithm {
        AutomaticSelection,
        CHA,
        VTA,
        RTA,
        SPARK,
        GEOM,
        OnDemand;

    }
}

