/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.aliasing;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.infoflow.aliasing.AbstractBulkAliasStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class ImplicitFlowAliasStrategy
extends AbstractBulkAliasStrategy {
    protected final LoadingCache<SootMethod, Map<AccessPath, Set<AccessPath>>> methodToAliases = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, Map<AccessPath, Set<AccessPath>>>(){

        @Override
        public Map<AccessPath, Set<AccessPath>> load(SootMethod method) throws Exception {
            return ImplicitFlowAliasStrategy.this.computeGlobalAliases(method);
        }
    });

    public ImplicitFlowAliasStrategy(IInfoflowCFG cfg) {
        super(cfg);
    }

    private Map<AccessPath, Set<AccessPath>> computeGlobalAliases(SootMethod method) {
        HashMap<AccessPath, Set<AccessPath>> res = new HashMap<AccessPath, Set<AccessPath>>();
        for (Unit u : method.getActiveBody().getUnits()) {
            AssignStmt assign;
            if (!(u instanceof AssignStmt) || (!((assign = (AssignStmt)u).getLeftOp() instanceof FieldRef) || !(assign.getRightOp() instanceof FieldRef) && !(assign.getRightOp() instanceof Local)) && (!(assign.getRightOp() instanceof FieldRef) || !(assign.getLeftOp() instanceof FieldRef) && !(assign.getLeftOp() instanceof Local))) continue;
            AccessPath apLeft = AccessPathFactory.v().createAccessPath(assign.getLeftOp(), true);
            AccessPath apRight = AccessPathFactory.v().createAccessPath(assign.getRightOp(), true);
            HashSet<AccessPath> mapLeft = (HashSet<AccessPath>)res.get(apLeft);
            if (mapLeft == null) {
                mapLeft = new HashSet<AccessPath>();
                res.put(apLeft, mapLeft);
            }
            mapLeft.add(apRight);
            HashSet mapRight = (HashSet)res.get(apRight);
            if (mapRight == null) {
                mapRight = new HashSet();
                res.put(apRight, mapRight);
            }
            mapLeft.add(apLeft);
        }
        return res;
    }

    @Override
    public void computeAliasTaints(Abstraction d1, Stmt src, Value targetValue, Set<Abstraction> taintSet, SootMethod method, Abstraction newAbs) {
        Value baseValue = ((InstanceFieldRef)targetValue).getBase();
        Set<AccessPath> aliases = this.methodToAliases.getUnchecked(method).get(AccessPathFactory.v().createAccessPath(baseValue, true));
        if (aliases != null) {
            for (AccessPath ap : aliases) {
                Abstraction aliasAbs = newAbs.deriveNewAbstraction(ap.merge(newAbs.getAccessPath()), null);
                if (!taintSet.add(aliasAbs) || !ap.isInstanceFieldRef()) continue;
                InstanceFieldRef aliasBaseVal = Jimple.v().newInstanceFieldRef(ap.getPlainValue(), ap.getFirstField().makeRef());
                this.computeAliasTaints(d1, src, aliasBaseVal, taintSet, method, aliasAbs);
            }
        }
    }

    @Override
    public void injectCallingContext(Abstraction abs, IInfoflowSolver fSolver, SootMethod callee, Unit callSite, Abstraction source, Abstraction d1) {
    }

    @Override
    public boolean isFlowSensitive() {
        return false;
    }

    @Override
    public boolean requiresAnalysisOnReturn() {
        return true;
    }

    @Override
    public boolean hasProcessedMethod(SootMethod method) {
        return this.methodToAliases.getIfPresent(method) != null;
    }
}

