/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.aliasing;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import heros.solver.PathEdge;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.aliasing.AbstractBulkAliasStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class PtsBasedAliasStrategy
extends AbstractBulkAliasStrategy {
    private final Table<SootMethod, Abstraction, Set<Abstraction>> aliases = HashBasedTable.create();

    public PtsBasedAliasStrategy(IInfoflowCFG cfg) {
        super(cfg);
    }

    @Override
    public void computeAliasTaints(Abstraction d1, Stmt src, Value targetValue, Set<Abstraction> taintSet, SootMethod method, Abstraction newAbs) {
        this.computeAliasTaintsInternal(d1, method, newAbs, Collections.emptyList(), Collections.emptyList(), newAbs.getAccessPath().getTaintSubFields(), src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAliasTaintsInternal(Abstraction d1, SootMethod method, Abstraction newAbs, List<SootField> appendFields, List<Type> appendTypes, boolean taintSubFields, Stmt actStmt) {
        Table<SootMethod, Abstraction, Set<Abstraction>> table = this.aliases;
        synchronized (table) {
            Set<Object> d1s;
            if (this.aliases.contains(method, newAbs)) {
                d1s = this.aliases.get(method, newAbs);
                if (d1s.contains(d1)) {
                    return;
                }
                d1s.add(d1);
            } else {
                d1s = Sets.newIdentityHashSet();
                d1s.add(d1);
                this.aliases.put(method, newAbs, d1s);
            }
        }
        AccessPath ap = newAbs.getAccessPath();
        if (ap.isInstanceFieldRef() && ap.getFirstField() != null || ap.isStaticFieldRef() && ap.getFieldCount() > 1) {
            LinkedList<SootField> appendList = new LinkedList<SootField>(appendFields);
            appendList.add(0, newAbs.getAccessPath().getLastField());
            LinkedList<Type> typesList = new LinkedList<Type>(appendTypes);
            typesList.add(0, newAbs.getAccessPath().getLastFieldType());
            this.computeAliasTaintsInternal(d1, method, newAbs.deriveNewAbstraction(newAbs.getAccessPath().dropLastField(), null), appendList, typesList, taintSubFields, actStmt);
        }
        if (ap.getFieldCount() > 1) {
            return;
        }
        PointsToSet ptsTaint = this.getPointsToSet(newAbs.getAccessPath());
        SootField[] appendFieldsA = appendFields.toArray(new SootField[appendFields.size()]);
        Type[] appendTypesA = appendTypes.toArray(new Type[appendTypes.size()]);
        boolean beforeActUnit = method.getActiveBody().getUnits().contains(actStmt);
        for (Unit u : method.getActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (stmt == actStmt) {
                beforeActUnit = false;
            }
            if (stmt.containsInvokeExpr()) {
                InvokeExpr invExpr = stmt.getInvokeExpr();
                boolean baseAliases = false;
                if (invExpr instanceof InstanceInvokeExpr && !newAbs.getAccessPath().isStaticFieldRef()) {
                    InstanceInvokeExpr iinvExpr = (InstanceInvokeExpr)invExpr;
                    PointsToSet ptsBase = this.getPointsToSet((Local)iinvExpr.getBase());
                    PointsToSet ptsBaseOrg = this.getPointsToSet(newAbs.getAccessPath().getPlainValue());
                    baseAliases = ptsBase.hasNonEmptyIntersection(ptsBaseOrg);
                }
                boolean parameterAliases = false;
                for (Value arg : invExpr.getArgs()) {
                    if (!(arg instanceof Local) || !this.getPointsToSet(arg).hasNonEmptyIntersection(ptsTaint)) continue;
                    parameterAliases = true;
                    break;
                }
                if (!baseAliases && !parameterAliases) continue;
                Abstraction absCallee = newAbs.deriveNewAbstraction(newAbs.getAccessPath().appendFields(appendFieldsA, appendTypesA, taintSubFields), stmt);
                if (beforeActUnit) {
                    absCallee = absCallee.deriveInactiveAbstraction(actStmt);
                }
                this.getForwardSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, u, absCallee));
                continue;
            }
            if (!(u instanceof DefinitionStmt)) continue;
            DefinitionStmt assign = (DefinitionStmt)u;
            if ((assign.getRightOp() instanceof FieldRef || assign.getRightOp() instanceof Local || assign.getRightOp() instanceof ArrayRef) && this.isAliasedAtStmt(ptsTaint, assign.getRightOp()) && appendFields != null && appendFields.size() > 0) {
                Abstraction aliasAbsLeft = newAbs.deriveNewAbstraction(AccessPathFactory.v().createAccessPath(assign.getLeftOp(), appendFieldsA, taintSubFields), stmt);
                if (beforeActUnit) {
                    aliasAbsLeft = aliasAbsLeft.deriveInactiveAbstraction(actStmt);
                }
                this.computeAliasTaints(d1, stmt, assign.getLeftOp(), Collections.emptySet(), method, aliasAbsLeft);
            }
            if (!(assign.getLeftOp() instanceof FieldRef) && !(assign.getLeftOp() instanceof Local) && !(assign.getLeftOp() instanceof ArrayRef) || !(assign.getRightOp() instanceof FieldRef) && !(assign.getRightOp() instanceof Local) && !(assign.getRightOp() instanceof ArrayRef) || !this.isAliasedAtStmt(ptsTaint, assign.getLeftOp())) continue;
            Abstraction aliasAbsRight = newAbs.deriveNewAbstraction(AccessPathFactory.v().createAccessPath(assign.getRightOp(), appendFieldsA, taintSubFields), stmt);
            if (beforeActUnit) {
                aliasAbsRight = aliasAbsRight.deriveInactiveAbstraction(actStmt);
            }
            this.getForwardSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, u, aliasAbsRight));
        }
    }

    private boolean isAliasedAtStmt(PointsToSet ptsTaint, Value val) {
        PointsToSet ptsRight = this.getPointsToSet(val);
        return ptsTaint.hasNonEmptyIntersection(ptsRight);
    }

    private PointsToSet getPointsToSet(Value targetValue) {
        PointsToAnalysis pta;
        PointsToAnalysis pointsToAnalysis = pta = Scene.v().getPointsToAnalysis();
        synchronized (pointsToAnalysis) {
            if (targetValue instanceof Local) {
                return pta.reachingObjects((Local)targetValue);
            }
            if (targetValue instanceof InstanceFieldRef) {
                InstanceFieldRef iref = (InstanceFieldRef)targetValue;
                return pta.reachingObjects((Local)iref.getBase(), iref.getField());
            }
            if (targetValue instanceof StaticFieldRef) {
                StaticFieldRef sref = (StaticFieldRef)targetValue;
                return pta.reachingObjects(sref.getField());
            }
            if (targetValue instanceof ArrayRef) {
                ArrayRef aref = (ArrayRef)targetValue;
                return pta.reachingObjects((Local)aref.getBase());
            }
            throw new RuntimeException("Unexpected value type for aliasing: " + targetValue.getClass());
        }
    }

    private PointsToSet getPointsToSet(AccessPath accessPath) {
        if (accessPath.isLocal()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getPlainValue());
        }
        if (accessPath.isInstanceFieldRef()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getPlainValue(), accessPath.getFirstField());
        }
        if (accessPath.isStaticFieldRef()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getFirstField());
        }
        throw new RuntimeException("Unexepected access path type");
    }

    @Override
    public void injectCallingContext(Abstraction abs, IInfoflowSolver fSolver, SootMethod callee, Unit callSite, Abstraction source, Abstraction d1) {
    }

    @Override
    public boolean isFlowSensitive() {
        return false;
    }

    @Override
    public boolean requiresAnalysisOnReturn() {
        return true;
    }
}

