/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import soot.G;
import soot.Main;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AbstractCallbackAnalyzer;
import soot.jimple.infoflow.android.callbacks.DefaultCallbackAnalyzer;
import soot.jimple.infoflow.android.callbacks.FastCallbackAnalyzer;
import soot.jimple.infoflow.android.config.SootConfigForAndroid;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.parsers.PermissionMethodParser;
import soot.jimple.infoflow.android.manifest.ProcessManifest;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.LayoutControl;
import soot.jimple.infoflow.android.resources.LayoutFileParser;
import soot.jimple.infoflow.android.source.AccessPathBasedSourceSinkManager;
import soot.jimple.infoflow.android.source.parsers.xml.XMLSourceSinkParser;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.AndroidEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.rifl.RIFLSourceSinkDefinitionProvider;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.source.data.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.source.data.SourceSinkDefinition;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.options.Options;

public class SetupApplication {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ISourceSinkDefinitionProvider sourceSinkProvider;
    private final Map<String, Set<SootMethodAndClass>> callbackMethods = new HashMap<String, Set<SootMethodAndClass>>(10000);
    private InfoflowAndroidConfiguration config = new InfoflowAndroidConfiguration();
    private Set<String> entrypoints = null;
    private Set<String> callbackClasses = null;
    private List<ARSCFileParser.ResPackage> resourcePackages = null;
    private String appPackageName = "";
    private final String androidJar;
    private final boolean forceAndroidJar;
    private final String apkFileLocation;
    private final String additionalClasspath;
    private ITaintPropagationWrapper taintWrapper;
    private AccessPathBasedSourceSinkManager sourceSinkManager = null;
    private IEntryPointCreator entryPointCreator = null;
    private IInfoflowConfig sootConfig = new SootConfigForAndroid();
    private BiDirICFGFactory cfgFactory = null;
    private IIPCManager ipcManager = null;
    private long maxMemoryConsumption = -1L;
    private Set<Stmt> collectedSources = null;
    private Set<Stmt> collectedSinks = null;
    private String callbackFile = "AndroidCallbacks.txt";

    public SetupApplication(String androidJar, String apkFileLocation) {
        this(androidJar, apkFileLocation, "", null);
    }

    public SetupApplication(String androidJar, String apkFileLocation, IIPCManager ipcManager) {
        this(androidJar, apkFileLocation, "", ipcManager);
    }

    public SetupApplication(String androidJar, String apkFileLocation, String additionalClasspath, IIPCManager ipcManager) {
        File f = new File(androidJar);
        this.forceAndroidJar = f.isFile();
        this.androidJar = androidJar;
        this.apkFileLocation = apkFileLocation;
        this.ipcManager = ipcManager;
        this.additionalClasspath = additionalClasspath;
    }

    public Set<SourceSinkDefinition> getSinks() {
        return this.sourceSinkProvider == null ? null : this.sourceSinkProvider.getSinks();
    }

    public Set<Stmt> getCollectedSinks() {
        return this.collectedSinks;
    }

    public void printSinks() {
        if (this.sourceSinkProvider == null) {
            System.err.println("Sinks not calculated yet");
            return;
        }
        System.out.println("Sinks:");
        for (SourceSinkDefinition am : this.getSinks()) {
            System.out.println(am.toString());
        }
        System.out.println("End of Sinks");
    }

    public Set<SourceSinkDefinition> getSources() {
        return this.sourceSinkProvider == null ? null : this.sourceSinkProvider.getSources();
    }

    public Set<Stmt> getCollectedSources() {
        return this.collectedSources;
    }

    public void printSources() {
        if (this.sourceSinkProvider == null) {
            System.err.println("Sources not calculated yet");
            return;
        }
        System.out.println("Sources:");
        for (SourceSinkDefinition am : this.getSources()) {
            System.out.println(am.toString());
        }
        System.out.println("End of Sources");
    }

    public Set<String> getEntrypointClasses() {
        return this.entrypoints;
    }

    public void printEntrypoints() {
        if (this.entrypoints == null) {
            System.out.println("Entry points not initialized");
        } else {
            System.out.println("Classes containing entry points:");
            for (String className : this.entrypoints) {
                System.out.println("\t" + className);
            }
            System.out.println("End of Entrypoints");
        }
    }

    public void setCallbackClasses(Set<String> callbackClasses) {
        this.callbackClasses = callbackClasses;
    }

    public Set<String> getCallbackClasses() {
        return this.callbackClasses;
    }

    public void setTaintWrapper(ITaintPropagationWrapper taintWrapper) {
        this.taintWrapper = taintWrapper;
    }

    public ITaintPropagationWrapper getTaintWrapper() {
        return this.taintWrapper;
    }

    public void calculateSourcesSinksEntrypoints(Set<AndroidMethod> sources, Set<AndroidMethod> sinks) throws IOException, XmlPullParserException {
        final HashSet<SourceSinkDefinition> sourceDefs = new HashSet<SourceSinkDefinition>(sources.size());
        final HashSet<SourceSinkDefinition> sinkDefs = new HashSet<SourceSinkDefinition>(sinks.size());
        for (AndroidMethod am : sources) {
            sourceDefs.add(new SourceSinkDefinition(am));
        }
        for (AndroidMethod am : sinks) {
            sinkDefs.add(new SourceSinkDefinition(am));
        }
        ISourceSinkDefinitionProvider parser2 = new ISourceSinkDefinitionProvider(){

            @Override
            public Set<SourceSinkDefinition> getSources() {
                return sourceDefs;
            }

            @Override
            public Set<SourceSinkDefinition> getSinks() {
                return sinkDefs;
            }

            @Override
            public Set<SourceSinkDefinition> getAllMethods() {
                HashSet<SourceSinkDefinition> sourcesSinks = new HashSet<SourceSinkDefinition>(sourceDefs.size() + sinkDefs.size());
                sourcesSinks.addAll(sourceDefs);
                sourcesSinks.addAll(sinkDefs);
                return sourcesSinks;
            }
        };
        this.calculateSourcesSinksEntrypoints(parser2);
    }

    public void calculateSourcesSinksEntrypoints(String sourceSinkFile) throws IOException, XmlPullParserException {
        ISourceSinkDefinitionProvider parser2 = null;
        String fileExtension = sourceSinkFile.substring(sourceSinkFile.lastIndexOf("."));
        fileExtension = fileExtension.toLowerCase();
        try {
            if (fileExtension.equals(".xml")) {
                parser2 = XMLSourceSinkParser.fromFile(sourceSinkFile);
            } else if (fileExtension.equals(".txt")) {
                parser2 = PermissionMethodParser.fromFile(sourceSinkFile);
            } else if (fileExtension.equals(".rifl")) {
                parser2 = new RIFLSourceSinkDefinitionProvider(sourceSinkFile);
            } else {
                throw new UnsupportedDataTypeException("The Inputfile isn't a .txt or .xml file.");
            }
            this.calculateSourcesSinksEntrypoints(parser2);
        }
        catch (SAXException ex) {
            throw new IOException("Could not read XML file", ex);
        }
    }

    public void calculateSourcesSinksEntrypoints(ISourceSinkDefinitionProvider sourcesAndSinks) throws IOException, XmlPullParserException {
        this.sourceSinkProvider = sourcesAndSinks;
        ProcessManifest processMan = new ProcessManifest(this.apkFileLocation);
        this.appPackageName = processMan.getPackageName();
        this.entrypoints = processMan.getEntryPointClasses();
        long beforeARSC = System.nanoTime();
        ARSCFileParser resParser = new ARSCFileParser();
        resParser.parse(this.apkFileLocation);
        this.logger.info("ARSC file parsing took " + (double)(System.nanoTime() - beforeARSC) / 1.0E9 + " seconds");
        this.resourcePackages = resParser.getPackages();
        LayoutFileParser lfp = null;
        if (this.config.getEnableCallbacks()) {
            if (this.callbackClasses != null && this.callbackClasses.isEmpty()) {
                this.logger.warn("Callback definition file is empty, disabling callbacks");
            } else {
                lfp = new LayoutFileParser(this.appPackageName, resParser);
                switch (this.config.getCallbackAnalyzer()) {
                    case Fast: {
                        this.calculateCallbackMethodsFast(resParser, lfp);
                        break;
                    }
                    case Default: {
                        this.calculateCallbackMethods(resParser, lfp);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown callback analyzer");
                    }
                }
                System.out.println("Found " + lfp.getUserControls() + " layout controls");
            }
        }
        System.out.println("Entry point calculation done.");
        G.reset();
        HashSet<SootMethodAndClass> callbacks = new HashSet<SootMethodAndClass>();
        for (Set<SootMethodAndClass> methods : this.callbackMethods.values()) {
            callbacks.addAll(methods);
        }
        this.sourceSinkManager = new AccessPathBasedSourceSinkManager(this.sourceSinkProvider.getSources(), this.sourceSinkProvider.getSinks(), callbacks, this.config.getLayoutMatchingMode(), lfp == null ? null : lfp.getUserControlsByID());
        this.sourceSinkManager.setAppPackageName(this.appPackageName);
        this.sourceSinkManager.setResourcePackages(this.resourcePackages);
        this.sourceSinkManager.setEnableCallbackSources(this.config.getEnableCallbackSources());
        this.entryPointCreator = this.createEntryPointCreator();
    }

    private void addCallbackMethod(String layoutClass, AndroidMethod callbackMethod) {
        Set<SootMethodAndClass> methods = this.callbackMethods.get(layoutClass);
        if (methods == null) {
            methods = new HashSet<SootMethodAndClass>();
            this.callbackMethods.put(layoutClass, methods);
        }
        methods.add(new AndroidMethod(callbackMethod));
    }

    private void calculateCallbackMethods(ARSCFileParser resParser, LayoutFileParser lfp) throws IOException {
        AbstractCallbackAnalyzer jimpleClass = null;
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            G.reset();
            this.initializeSoot(true);
            this.createMainMethod();
            if (jimpleClass == null) {
                jimpleClass = this.callbackClasses == null ? new DefaultCallbackAnalyzer(this.config, this.entrypoints, this.callbackFile) : new DefaultCallbackAnalyzer(this.config, this.entrypoints, this.callbackClasses);
                jimpleClass.collectCallbackMethods();
                lfp.parseLayoutFile(this.apkFileLocation);
            } else {
                jimpleClass.collectCallbackMethodsIncremental();
            }
            PackManager.v().getPack("wjpp").apply();
            PackManager.v().getPack("cg").apply();
            PackManager.v().getPack("wjtp").apply();
            for (Map.Entry<String, Set<SootMethodAndClass>> entry : jimpleClass.getCallbackMethods().entrySet()) {
                Set<SootMethodAndClass> curCallbacks = this.callbackMethods.get(entry.getKey());
                if (curCallbacks != null) {
                    if (!curCallbacks.addAll((Collection<SootMethodAndClass>)entry.getValue())) continue;
                    hasChanged = true;
                    continue;
                }
                this.callbackMethods.put(entry.getKey(), new HashSet(entry.getValue()));
                hasChanged = true;
            }
            if (!this.entrypoints.addAll(jimpleClass.getDynamicManifestComponents())) continue;
            hasChanged = true;
        }
        this.collectXmlBasedCallbackMethods(resParser, lfp, jimpleClass);
    }

    private void collectXmlBasedCallbackMethods(ARSCFileParser resParser, LayoutFileParser lfp, AbstractCallbackAnalyzer jimpleClass) {
        for (Map.Entry<String, Set<Integer>> lcentry : jimpleClass.getLayoutClasses().entrySet()) {
            SootClass callbackClass = Scene.v().getSootClass(lcentry.getKey());
            for (Integer classId : lcentry.getValue()) {
                ARSCFileParser.AbstractResource resource = resParser.findResource(classId);
                if (resource instanceof ARSCFileParser.StringResource) {
                    Set<LayoutControl> controls;
                    String layoutFileName = ((ARSCFileParser.StringResource)resource).getValue();
                    Set<String> callbackMethods = lfp.getCallbackMethods().get(layoutFileName);
                    if (callbackMethods != null) {
                        block2: for (String methodName : callbackMethods) {
                            String subSig = "void " + methodName + "(android.view.View)";
                            SootClass currentClass = callbackClass;
                            while (true) {
                                SootMethod callbackMethod;
                                if ((callbackMethod = currentClass.getMethodUnsafe(subSig)) != null) {
                                    this.addCallbackMethod(callbackClass.getName(), new AndroidMethod(callbackMethod));
                                    continue block2;
                                }
                                if (!currentClass.hasSuperclass()) {
                                    System.err.println("Callback method " + methodName + " not found in class " + callbackClass.getName());
                                    continue block2;
                                }
                                currentClass = currentClass.getSuperclass();
                            }
                        }
                    }
                    if ((controls = lfp.getUserControls().get(layoutFileName)) == null) continue;
                    for (LayoutControl lc : controls) {
                        this.registerCallbackMethodsForView(callbackClass, lc);
                    }
                    continue;
                }
                System.err.println("Unexpected resource type for layout class");
            }
        }
        HashSet<SootMethodAndClass> callbacksPlain = new HashSet<SootMethodAndClass>();
        for (Set<SootMethodAndClass> set : this.callbackMethods.values()) {
            callbacksPlain.addAll(set);
        }
        System.out.println("Found " + callbacksPlain.size() + " callback methods for " + this.callbackMethods.size() + " components");
    }

    private void calculateCallbackMethodsFast(ARSCFileParser resParser, LayoutFileParser lfp) throws IOException {
        G.reset();
        this.initializeSoot(false);
        FastCallbackAnalyzer jimpleClass = this.callbackClasses == null ? new FastCallbackAnalyzer(this.config, this.entrypoints, this.callbackFile) : new FastCallbackAnalyzer(this.config, this.entrypoints, this.callbackClasses);
        ((AbstractCallbackAnalyzer)jimpleClass).collectCallbackMethods();
        Set<SootMethodAndClass> callbacks = jimpleClass.getCallbackMethods().get("");
        if (callbacks != null) {
            for (String componentName : this.entrypoints) {
                this.callbackMethods.put(componentName, callbacks);
            }
        }
        lfp.parseLayoutFileDirect(this.apkFileLocation);
        this.collectXmlBasedCallbackMethods(resParser, lfp, jimpleClass);
    }

    private void registerCallbackMethodsForView(SootClass callbackClass, LayoutControl lc) {
        if (callbackClass.getName().startsWith("android.")) {
            return;
        }
        if (lc.getViewClass().getName().startsWith("android.")) {
            return;
        }
        SootClass sc = lc.getViewClass();
        boolean isView = false;
        while (sc.hasSuperclass()) {
            if (sc.getName().equals("android.view.View")) {
                isView = true;
                break;
            }
            sc = sc.getSuperclass();
        }
        if (!isView) {
            return;
        }
        sc = lc.getViewClass();
        HashSet<String> systemMethods = new HashSet<String>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sc)) {
            if (!parentClass.getName().startsWith("android.")) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.add(sm.getSubSignature());
            }
        }
        for (SootMethod sm : sc.getMethods()) {
            if (sm.isConstructor() || !systemMethods.contains(sm.getSubSignature())) continue;
            this.addCallbackMethod(callbackClass.getName(), new AndroidMethod(sm));
        }
    }

    private void createMainMethod() {
        SootMethod entryPoint = this.createEntryPointCreator().createDummyMain();
        Scene.v().setEntryPoints(Collections.singletonList(entryPoint));
        if (Scene.v().containsClass(entryPoint.getDeclaringClass().getName())) {
            Scene.v().removeClass(entryPoint.getDeclaringClass());
        }
        Scene.v().addClass(entryPoint.getDeclaringClass());
        entryPoint.getDeclaringClass().setApplicationClass();
    }

    public AccessPathBasedSourceSinkManager getSourceSinkManager() {
        return this.sourceSinkManager;
    }

    private String getClasspath() {
        String classpath;
        String string = classpath = this.forceAndroidJar ? this.androidJar : Scene.v().getAndroidJarPath(this.androidJar, this.apkFileLocation);
        if (this.additionalClasspath != null && !this.additionalClasspath.isEmpty()) {
            classpath = classpath + File.pathSeparator + this.additionalClasspath;
        }
        this.logger.debug("soot classpath: " + classpath);
        return classpath;
    }

    private void initializeSoot(boolean constructCallgraph) {
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_output_format(12);
        Options.v().set_whole_program(constructCallgraph);
        Options.v().set_process_dir(Collections.singletonList(this.apkFileLocation));
        if (this.forceAndroidJar) {
            Options.v().set_force_android_jar(this.androidJar);
        } else {
            Options.v().set_android_jars(this.androidJar);
        }
        Options.v().set_src_prec(5);
        Options.v().set_keep_line_number(false);
        Options.v().set_keep_offset(false);
        if (this.sootConfig != null) {
            this.sootConfig.setSootOptions(Options.v());
        }
        Options.v().set_soot_classpath(this.getClasspath());
        Main.v().autoSetOptions();
        if (constructCallgraph) {
            switch (this.config.getCallgraphAlgorithm()) {
                case AutomaticSelection: 
                case SPARK: {
                    Options.v().setPhaseOption("cg.spark", "on");
                    break;
                }
                case GEOM: {
                    Options.v().setPhaseOption("cg.spark", "on");
                    AbstractInfoflow.setGeomPtaSpecificOptions();
                    break;
                }
                case CHA: {
                    Options.v().setPhaseOption("cg.cha", "on");
                    break;
                }
                case RTA: {
                    Options.v().setPhaseOption("cg.spark", "on");
                    Options.v().setPhaseOption("cg.spark", "rta:true");
                    Options.v().setPhaseOption("cg.spark", "on-fly-cg:false");
                    break;
                }
                case VTA: {
                    Options.v().setPhaseOption("cg.spark", "on");
                    Options.v().setPhaseOption("cg.spark", "vta:true");
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid callgraph algorithm");
                }
            }
        }
        Scene.v().loadNecessaryClasses();
    }

    public InfoflowResults runInfoflow() {
        return this.runInfoflow(null);
    }

    public InfoflowResults runInfoflow(ResultsAvailableHandler onResultsAvailable) {
        if (this.sourceSinkProvider == null) {
            throw new RuntimeException("Sources and/or sinks not calculated yet");
        }
        System.out.println("Running data flow analysis on " + this.apkFileLocation + " with " + this.getSources().size() + " sources and " + this.getSinks().size() + " sinks...");
        Infoflow info = this.cfgFactory == null ? new Infoflow(this.androidJar, this.forceAndroidJar, null, new DefaultPathBuilderFactory(this.config.getPathBuilder(), this.config.getComputeResultPaths())) : new Infoflow(this.androidJar, this.forceAndroidJar, this.cfgFactory, new DefaultPathBuilderFactory(this.config.getPathBuilder(), this.config.getComputeResultPaths()));
        String path = this.forceAndroidJar ? this.androidJar : Scene.v().getAndroidJarPath(this.androidJar, this.apkFileLocation);
        info.setTaintWrapper(this.taintWrapper);
        if (onResultsAvailable != null) {
            info.addResultsAvailableHandler(onResultsAvailable);
        }
        System.out.println("Starting infoflow computation...");
        info.setConfig(this.config);
        info.setSootConfig(this.sootConfig);
        if (null != this.ipcManager) {
            info.setIPCManager(this.ipcManager);
        }
        info.computeInfoflow(this.apkFileLocation, path, this.entryPointCreator, (ISourceSinkManager)this.sourceSinkManager);
        this.maxMemoryConsumption = info.getMaxMemoryConsumption();
        this.collectedSources = info.getCollectedSources();
        this.collectedSinks = info.getCollectedSinks();
        return info.getResults();
    }

    protected IEntryPointCreator createEntryPointCreator() {
        AndroidEntryPointCreator entryPointCreator = new AndroidEntryPointCreator(new ArrayList<String>(this.entrypoints));
        HashMap<String, List<String>> callbackMethodSigs = new HashMap<String, List<String>>();
        for (String className : this.callbackMethods.keySet()) {
            ArrayList<String> methodSigs = new ArrayList<String>();
            callbackMethodSigs.put(className, methodSigs);
            for (SootMethodAndClass am : this.callbackMethods.get(className)) {
                methodSigs.add(am.getSignature());
            }
        }
        entryPointCreator.setCallbackFunctions(callbackMethodSigs);
        return entryPointCreator;
    }

    public IEntryPointCreator getEntryPointCreator() {
        return this.entryPointCreator;
    }

    public IInfoflowConfig getSootConfig() {
        return this.sootConfig;
    }

    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    public void setIcfgFactory(BiDirICFGFactory factory) {
        this.cfgFactory = factory;
    }

    public long getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public InfoflowAndroidConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(InfoflowAndroidConfiguration config) {
        this.config = config;
    }

    public void setCallbackFile(String callbackFile) {
        this.callbackFile = callbackFile;
    }
}

