/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.TestApps;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.stream.XMLStreamException;
import org.xmlpull.v1.XmlPullParserException;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.SetupApplication;
import soot.jimple.infoflow.android.source.AndroidSourceSinkManager;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.results.xml.InfoflowResultsSerializer;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.options.Options;

public class Test {
    private static InfoflowAndroidConfiguration config = new InfoflowAndroidConfiguration();
    private static int repeatCount = 1;
    private static int timeout = -1;
    private static int sysTimeout = -1;
    private static boolean aggressiveTaintWrapper = false;
    private static boolean noTaintWrapper = false;
    private static String summaryPath = "";
    private static String resultFilePath = "";
    private static boolean DEBUG = false;
    private static IIPCManager ipcManager = null;

    public static void setIPCManager(IIPCManager ipcManager) {
        Test.ipcManager = ipcManager;
    }

    public static IIPCManager getIPCManager() {
        return ipcManager;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 2) {
            Test.printUsage();
            return;
        }
        File outputDir = new File("JimpleOutput");
        if (outputDir.isDirectory()) {
            boolean success = true;
            for (File f : outputDir.listFiles()) {
                success = success && f.delete();
            }
            if (!success) {
                System.err.println("Cleanup of output directory " + outputDir + " failed!");
            }
            outputDir.delete();
        }
        if (!Test.parseAdditionalOptions(args)) {
            return;
        }
        if (!Test.validateAdditionalOptions()) {
            return;
        }
        if (repeatCount <= 0) {
            return;
        }
        ArrayList<String> apkFiles = new ArrayList<String>();
        File apkFile = new File(args[0]);
        if (apkFile.isDirectory()) {
            String[] dirFiles;
            for (String s : dirFiles = apkFile.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".apk");
                }
            })) {
                apkFiles.add(s);
            }
        } else {
            String extension = apkFile.getName().substring(apkFile.getName().lastIndexOf("."));
            if (extension.equalsIgnoreCase(".txt")) {
                BufferedReader rdr = new BufferedReader(new FileReader(apkFile));
                String line = null;
                while ((line = rdr.readLine()) != null) {
                    apkFiles.add(line);
                }
                rdr.close();
            } else if (extension.equalsIgnoreCase(".apk")) {
                apkFiles.add(args[0]);
            } else {
                System.err.println("Invalid input file format: " + extension);
                return;
            }
        }
        int oldRepeatCount = repeatCount;
        for (String fileName : apkFiles) {
            String fullFilePath;
            repeatCount = oldRepeatCount;
            System.gc();
            if (apkFiles.size() > 1) {
                fullFilePath = apkFile.isDirectory() ? args[0] + File.separator + fileName : fileName;
                System.out.println("Analyzing file " + fullFilePath + "...");
                File flagFile = new File("_Run_" + new File(fileName).getName());
                if (flagFile.exists()) continue;
                flagFile.createNewFile();
            } else {
                fullFilePath = fileName;
            }
            while (repeatCount > 0) {
                System.gc();
                if (timeout > 0) {
                    Test.runAnalysisTimeout(fullFilePath, args[1]);
                } else if (sysTimeout > 0) {
                    Test.runAnalysisSysTimeout(fullFilePath, args[1]);
                } else {
                    Test.runAnalysis(fullFilePath, args[1]);
                }
                --repeatCount;
            }
            System.gc();
        }
    }

    private static boolean parseAdditionalOptions(String[] args) {
        int i = 2;
        while (i < args.length) {
            String algo;
            if (args[i].equalsIgnoreCase("--timeout")) {
                timeout = Integer.valueOf(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--systimeout")) {
                sysTimeout = Integer.valueOf(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--singleflow")) {
                config.setStopAfterFirstFlow(true);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--implicit")) {
                config.setEnableImplicitFlows(true);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--nostatic")) {
                config.setEnableStaticFieldTracking(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--aplength")) {
                InfoflowAndroidConfiguration.setAccessPathLength(Integer.valueOf(args[i + 1]));
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--cgalgo")) {
                algo = args[i + 1];
                if (algo.equalsIgnoreCase("AUTO")) {
                    config.setCallgraphAlgorithm(InfoflowConfiguration.CallgraphAlgorithm.AutomaticSelection);
                } else if (algo.equalsIgnoreCase("CHA")) {
                    config.setCallgraphAlgorithm(InfoflowConfiguration.CallgraphAlgorithm.CHA);
                } else if (algo.equalsIgnoreCase("VTA")) {
                    config.setCallgraphAlgorithm(InfoflowConfiguration.CallgraphAlgorithm.VTA);
                } else if (algo.equalsIgnoreCase("RTA")) {
                    config.setCallgraphAlgorithm(InfoflowConfiguration.CallgraphAlgorithm.RTA);
                } else if (algo.equalsIgnoreCase("SPARK")) {
                    config.setCallgraphAlgorithm(InfoflowConfiguration.CallgraphAlgorithm.SPARK);
                } else if (algo.equalsIgnoreCase("GEOM")) {
                    config.setCallgraphAlgorithm(InfoflowConfiguration.CallgraphAlgorithm.GEOM);
                } else {
                    System.err.println("Invalid callgraph algorithm");
                    return false;
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--nocallbacks")) {
                config.setEnableCallbacks(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--noexceptions")) {
                config.setEnableExceptionTracking(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--layoutmode")) {
                algo = args[i + 1];
                if (algo.equalsIgnoreCase("NONE")) {
                    config.setLayoutMatchingMode(AndroidSourceSinkManager.LayoutMatchingMode.NoMatch);
                } else if (algo.equalsIgnoreCase("PWD")) {
                    config.setLayoutMatchingMode(AndroidSourceSinkManager.LayoutMatchingMode.MatchSensitiveOnly);
                } else if (algo.equalsIgnoreCase("ALL")) {
                    config.setLayoutMatchingMode(AndroidSourceSinkManager.LayoutMatchingMode.MatchAll);
                } else {
                    System.err.println("Invalid layout matching mode");
                    return false;
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--aliasflowins")) {
                config.setFlowSensitiveAliasing(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--paths")) {
                config.setComputeResultPaths(true);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--nopaths")) {
                config.setComputeResultPaths(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--aggressivetw")) {
                aggressiveTaintWrapper = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--pathalgo")) {
                algo = args[i + 1];
                if (algo.equalsIgnoreCase("CONTEXTSENSITIVE")) {
                    config.setPathBuilder(DefaultPathBuilderFactory.PathBuilder.ContextSensitive);
                } else if (algo.equalsIgnoreCase("CONTEXTINSENSITIVE")) {
                    config.setPathBuilder(DefaultPathBuilderFactory.PathBuilder.ContextInsensitive);
                } else if (algo.equalsIgnoreCase("SOURCESONLY")) {
                    config.setPathBuilder(DefaultPathBuilderFactory.PathBuilder.ContextInsensitiveSourceFinder);
                } else {
                    System.err.println("Invalid path reconstruction algorithm");
                    return false;
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--summarypath")) {
                summaryPath = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--saveresults")) {
                resultFilePath = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--sysflows")) {
                config.setIgnoreFlowsInSystemPackages(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--notaintwrapper")) {
                noTaintWrapper = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--repeatcount")) {
                repeatCount = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--noarraysize")) {
                config.setEnableArraySizeTainting(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--arraysize")) {
                config.setEnableArraySizeTainting(true);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--notypetightening")) {
                InfoflowAndroidConfiguration.setUseTypeTightening(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--safemode")) {
                InfoflowAndroidConfiguration.setUseThisChainReduction(false);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--logsourcesandsinks")) {
                config.setLogSourcesAndSinks(true);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--callbackanalyzer")) {
                algo = args[i + 1];
                if (algo.equalsIgnoreCase("DEFAULT")) {
                    config.setCallbackAnalyzer(InfoflowAndroidConfiguration.CallbackAnalyzer.Default);
                } else if (algo.equalsIgnoreCase("FAST")) {
                    config.setCallbackAnalyzer(InfoflowAndroidConfiguration.CallbackAnalyzer.Fast);
                } else {
                    System.err.println("Invalid callback analysis algorithm");
                    return false;
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--maxthreadnum")) {
                config.setMaxThreadNum(Integer.valueOf(args[i + 1]));
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("--arraysizetainting")) {
                config.setEnableArraySizeTainting(true);
                ++i;
                continue;
            }
            ++i;
        }
        return true;
    }

    private static boolean validateAdditionalOptions() {
        if (timeout > 0 && sysTimeout > 0) {
            return false;
        }
        if (!config.getFlowSensitiveAliasing() && config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand && config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.AutomaticSelection) {
            System.err.println("Flow-insensitive aliasing can only be configured for callgraph algorithms that support this choice.");
            return false;
        }
        return true;
    }

    private static void runAnalysisTimeout(final String fileName, final String androidJar) {
        FutureTask<InfoflowResults> task = new FutureTask<InfoflowResults>(new Callable<InfoflowResults>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InfoflowResults call() throws Exception {
                try (BufferedWriter wr = new BufferedWriter(new FileWriter("_out_" + new File(fileName).getName() + ".txt"));){
                    long beforeRun = System.nanoTime();
                    wr.write("Running data flow analysis...\n");
                    InfoflowResults res = Test.runAnalysis(fileName, androidJar);
                    wr.write("Analysis has run for " + (double)(System.nanoTime() - beforeRun) / 1.0E9 + " seconds\n");
                    wr.flush();
                    InfoflowResults infoflowResults = res;
                    return infoflowResults;
                }
            }
        });
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(task);
        try {
            System.out.println("Running infoflow task...");
            task.get(timeout, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            System.err.println("Infoflow computation failed: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            System.err.println("Infoflow computation timed out: " + e.getMessage());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            System.err.println("Infoflow computation interrupted: " + e.getMessage());
            e.printStackTrace();
        }
        executor.shutdown();
    }

    private static void runAnalysisSysTimeout(String fileName, String androidJar) {
        String classpath = System.getProperty("java.class.path");
        String javaHome = System.getProperty("java.home");
        String executable = "/usr/bin/timeout";
        Object[] command = new String[]{executable, "-s", "KILL", sysTimeout + "m", javaHome + "/bin/java", "-cp", classpath, "soot.jimple.infoflow.android.TestApps.Test", fileName, androidJar, config.getStopAfterFirstFlow() ? "--singleflow" : "--nosingleflow", config.getEnableImplicitFlows() ? "--implicit" : "--noimplicit", config.getEnableStaticFieldTracking() ? "--static" : "--nostatic", "--aplength", Integer.toString(InfoflowAndroidConfiguration.getAccessPathLength()), "--cgalgo", Test.callgraphAlgorithmToString(config.getCallgraphAlgorithm()), config.getEnableCallbacks() ? "--callbacks" : "--nocallbacks", config.getEnableExceptionTracking() ? "--exceptions" : "--noexceptions", "--layoutmode", Test.layoutMatchingModeToString(config.getLayoutMatchingMode()), config.getFlowSensitiveAliasing() ? "--aliasflowsens" : "--aliasflowins", config.getComputeResultPaths() ? "--paths" : "--nopaths", aggressiveTaintWrapper ? "--aggressivetw" : "--nonaggressivetw", "--pathalgo", Test.pathAlgorithmToString(config.getPathBuilder()), summaryPath != null && !summaryPath.isEmpty() ? "--summarypath" : "", summaryPath != null && !summaryPath.isEmpty() ? summaryPath : "", resultFilePath != null && !resultFilePath.isEmpty() ? "--saveresults" : "", noTaintWrapper ? "--notaintwrapper" : "", config.getEnableArraySizeTainting() ? "" : "--noarraysize", InfoflowAndroidConfiguration.getUseTypeTightening() ? "" : "--notypetightening", InfoflowAndroidConfiguration.getUseThisChainReduction() ? "" : "--safemode", config.getLogSourcesAndSinks() ? "--logsourcesandsinks" : "", "--callbackanalyzer", Test.callbackAlgorithmToString(config.getCallbackAnalyzer()), "--maxthreadnum", Integer.toString(config.getMaxThreadNum()), config.getEnableArraySizeTainting() ? "--arraysizetainting" : ""};
        System.out.println("Running command: " + executable + " " + Arrays.toString(command));
        try {
            ProcessBuilder pb = new ProcessBuilder((String[])command);
            pb.redirectOutput(new File("out_" + new File(fileName).getName() + "_" + repeatCount + ".txt"));
            pb.redirectError(new File("err_" + new File(fileName).getName() + "_" + repeatCount + ".txt"));
            Process proc = pb.start();
            proc.waitFor();
        }
        catch (IOException ex) {
            System.err.println("Could not execute timeout command: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            System.err.println("Process was interrupted: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static String callgraphAlgorithmToString(InfoflowConfiguration.CallgraphAlgorithm algorihm) {
        switch (algorihm) {
            case AutomaticSelection: {
                return "AUTO";
            }
            case CHA: {
                return "CHA";
            }
            case VTA: {
                return "VTA";
            }
            case RTA: {
                return "RTA";
            }
            case SPARK: {
                return "SPARK";
            }
            case GEOM: {
                return "GEOM";
            }
        }
        return "unknown";
    }

    private static String layoutMatchingModeToString(AndroidSourceSinkManager.LayoutMatchingMode mode) {
        switch (mode) {
            case NoMatch: {
                return "NONE";
            }
            case MatchSensitiveOnly: {
                return "PWD";
            }
            case MatchAll: {
                return "ALL";
            }
        }
        return "unknown";
    }

    private static String pathAlgorithmToString(DefaultPathBuilderFactory.PathBuilder pathBuilder) {
        switch (pathBuilder) {
            case ContextSensitive: {
                return "CONTEXTSENSITIVE";
            }
            case ContextInsensitive: {
                return "CONTEXTINSENSITIVE";
            }
            case ContextInsensitiveSourceFinder: {
                return "SOURCESONLY";
            }
        }
        return "UNKNOWN";
    }

    private static String callbackAlgorithmToString(InfoflowAndroidConfiguration.CallbackAnalyzer analyzer) {
        switch (analyzer) {
            case Default: {
                return "DEFAULT";
            }
            case Fast: {
                return "FAST";
            }
        }
        return "UNKNOWN";
    }

    public static InfoflowResults runAnalysis(String fileName, String androidJar) {
        try {
            ITaintPropagationWrapper taintWrapper;
            long beforeRun = System.nanoTime();
            SetupApplication app = null == ipcManager ? new SetupApplication(androidJar, fileName) : new SetupApplication(androidJar, fileName, ipcManager);
            app.setConfig(config);
            if (noTaintWrapper) {
                app.setSootConfig(new IInfoflowConfig(){

                    @Override
                    public void setSootOptions(Options options) {
                        options.set_include_all(true);
                    }
                });
            }
            if (noTaintWrapper) {
                taintWrapper = null;
            } else if (summaryPath != null && !summaryPath.isEmpty()) {
                System.out.println("Using the StubDroid taint wrapper");
                taintWrapper = Test.createLibrarySummaryTW();
                if (taintWrapper == null) {
                    System.err.println("Could not initialize StubDroid");
                    return null;
                }
            } else {
                EasyTaintWrapper easyTaintWrapper;
                File twSourceFile = new File("../soot-infoflow/EasyTaintWrapperSource.txt");
                if (twSourceFile.exists()) {
                    easyTaintWrapper = new EasyTaintWrapper(twSourceFile);
                } else {
                    twSourceFile = new File("EasyTaintWrapperSource.txt");
                    if (twSourceFile.exists()) {
                        easyTaintWrapper = new EasyTaintWrapper(twSourceFile);
                    } else {
                        System.err.println("Taint wrapper definition file not found at " + twSourceFile.getAbsolutePath());
                        return null;
                    }
                }
                easyTaintWrapper.setAggressiveMode(aggressiveTaintWrapper);
                taintWrapper = easyTaintWrapper;
            }
            app.setTaintWrapper(taintWrapper);
            app.calculateSourcesSinksEntrypoints("SourcesAndSinks.txt");
            if (DEBUG) {
                app.printEntrypoints();
                app.printSinks();
                app.printSources();
            }
            System.out.println("Running data flow analysis...");
            InfoflowResults res = app.runInfoflow(new MyResultsAvailableHandler());
            System.out.println("Analysis has run for " + (double)(System.nanoTime() - beforeRun) / 1.0E9 + " seconds");
            if (config.getLogSourcesAndSinks()) {
                if (!app.getCollectedSources().isEmpty()) {
                    System.out.println("Collected sources:");
                    for (Stmt s : app.getCollectedSources()) {
                        System.out.println("\t" + s);
                    }
                }
                if (!app.getCollectedSinks().isEmpty()) {
                    System.out.println("Collected sinks:");
                    for (Stmt s : app.getCollectedSinks()) {
                        System.out.println("\t" + s);
                    }
                }
            }
            return res;
        }
        catch (IOException ex) {
            System.err.println("Could not read file: " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        catch (XmlPullParserException ex) {
            System.err.println("Could not read Android manifest file: " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private static ITaintPropagationWrapper createLibrarySummaryTW() throws IOException {
        try {
            Class<?> clzLazySummary = Class.forName("soot.jimple.infoflow.methodSummary.data.provider.LazySummaryProvider");
            Class<?> itfLazySummary = Class.forName("soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider");
            Object lazySummary = clzLazySummary.getConstructor(File.class).newInstance(new File(summaryPath));
            ITaintPropagationWrapper summaryWrapper = (ITaintPropagationWrapper)Class.forName("soot.jimple.infoflow.methodSummary.taintWrappers.SummaryTaintWrapper").getConstructor(itfLazySummary).newInstance(lazySummary);
            ITaintPropagationWrapper systemClassWrapper = new ITaintPropagationWrapper(){
                private ITaintPropagationWrapper wrapper = new EasyTaintWrapper("EasyTaintWrapperSource.txt");

                private boolean isSystemClass(Stmt stmt) {
                    if (stmt.containsInvokeExpr()) {
                        return SystemClassHandler.isClassInSystemPackage(stmt.getInvokeExpr().getMethod().getDeclaringClass().getName());
                    }
                    return false;
                }

                @Override
                public boolean supportsCallee(Stmt callSite) {
                    return this.isSystemClass(callSite) && this.wrapper.supportsCallee(callSite);
                }

                @Override
                public boolean supportsCallee(SootMethod method) {
                    return SystemClassHandler.isClassInSystemPackage(method.getDeclaringClass().getName()) && this.wrapper.supportsCallee(method);
                }

                @Override
                public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
                    return this.isSystemClass(stmt) && this.wrapper.isExclusive(stmt, taintedPath);
                }

                @Override
                public void initialize(InfoflowManager manager) {
                    this.wrapper.initialize(manager);
                }

                @Override
                public int getWrapperMisses() {
                    return 0;
                }

                @Override
                public int getWrapperHits() {
                    return 0;
                }

                @Override
                public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
                    if (!this.isSystemClass(stmt)) {
                        return null;
                    }
                    return this.wrapper.getTaintsForMethod(stmt, d1, taintedPath);
                }

                @Override
                public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
                    if (!this.isSystemClass(stmt)) {
                        return null;
                    }
                    return this.wrapper.getAliasesForMethod(stmt, d1, taintedPath);
                }
            };
            Method setFallbackMethod = summaryWrapper.getClass().getMethod("setFallbackTaintWrapper", ITaintPropagationWrapper.class);
            setFallbackMethod.invoke((Object)summaryWrapper, systemClassWrapper);
            return summaryWrapper;
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            System.err.println("Could not find library summary classes: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        catch (InvocationTargetException ex) {
            System.err.println("Could not initialize library summaries: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            System.err.println("Internal error in library summary initialization: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private static void printUsage() {
        System.out.println("FlowDroid (c) Secure Software Engineering Group @ EC SPRIDE");
        System.out.println();
        System.out.println("Incorrect arguments: [0] = apk-file, [1] = android-jar-directory");
        System.out.println("Optional further parameters:");
        System.out.println("\t--TIMEOUT n Time out after n seconds");
        System.out.println("\t--SYSTIMEOUT n Hard time out (kill process) after n seconds, Unix only");
        System.out.println("\t--SINGLEFLOW Stop after finding first leak");
        System.out.println("\t--IMPLICIT Enable implicit flows");
        System.out.println("\t--NOSTATIC Disable static field tracking");
        System.out.println("\t--NOEXCEPTIONS Disable exception tracking");
        System.out.println("\t--APLENGTH n Set access path length to n");
        System.out.println("\t--CGALGO x Use callgraph algorithm x");
        System.out.println("\t--NOCALLBACKS Disable callback analysis");
        System.out.println("\t--LAYOUTMODE x Set UI control analysis mode to x");
        System.out.println("\t--ALIASFLOWINS Use a flow insensitive alias search");
        System.out.println("\t--NOPATHS Do not compute result paths");
        System.out.println("\t--AGGRESSIVETW Use taint wrapper in aggressive mode");
        System.out.println("\t--PATHALGO Use path reconstruction algorithm x");
        System.out.println("\t--LIBSUMTW Use library summary taint wrapper");
        System.out.println("\t--SUMMARYPATH Path to library summaries");
        System.out.println("\t--SYSFLOWS Also analyze classes in system packages");
        System.out.println("\t--NOTAINTWRAPPER Disables the use of taint wrappers");
        System.out.println("\t--NOTYPETIGHTENING Disables the use of taint wrappers");
        System.out.println("\t--LOGSOURCESANDSINKS Print out concrete source/sink instances");
        System.out.println("\t--CALLBACKANALYZER x Uses callback analysis algorithm x");
        System.out.println("\t--MAXTHREADNUM x Sets the maximum number of threads to be used by the analysis to x");
        System.out.println();
        System.out.println("Supported callgraph algorithms: AUTO, CHA, RTA, VTA, SPARK, GEOM");
        System.out.println("Supported layout mode algorithms: NONE, PWD, ALL");
        System.out.println("Supported path algorithms: CONTEXTSENSITIVE, CONTEXTINSENSITIVE, SOURCESONLY");
        System.out.println("Supported callback algorithms: DEFAULT, FAST");
    }

    private static final class MyResultsAvailableHandler
    implements ResultsAvailableHandler {
        private final BufferedWriter wr;

        private MyResultsAvailableHandler() {
            this.wr = null;
        }

        private MyResultsAvailableHandler(BufferedWriter wr) {
            this.wr = wr;
        }

        @Override
        public void onResultsAvailable(IInfoflowCFG cfg, InfoflowResults results) {
            if (results == null) {
                this.print("No results found.");
            } else {
                for (ResultSinkInfo sink : results.getResults().keySet()) {
                    this.print("Found a flow to sink " + sink + ", from the following sources:");
                    for (ResultSourceInfo source : results.getResults().get(sink)) {
                        this.print("\t- " + source.getSource() + " (in " + ((SootMethod)cfg.getMethodOf(source.getSource())).getSignature() + ")");
                        if (source.getPath() == null) continue;
                        this.print("\t\ton Path " + Arrays.toString(source.getPath()));
                    }
                }
                if (resultFilePath != null && !resultFilePath.isEmpty()) {
                    InfoflowResultsSerializer serializer = new InfoflowResultsSerializer(cfg);
                    try {
                        serializer.serialize(results, resultFilePath);
                    }
                    catch (FileNotFoundException ex) {
                        System.err.println("Could not write data flow results to file: " + ex.getMessage());
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                    catch (XMLStreamException ex) {
                        System.err.println("Could not write data flow results to file: " + ex.getMessage());
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                }
            }
        }

        private void print(String string) {
            try {
                System.out.println(string);
                if (this.wr != null) {
                    this.wr.write(string + "\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

