/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public abstract class AbstractCallbackAnalyzer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final InfoflowAndroidConfiguration config;
    protected final Set<String> entryPointClasses;
    protected final Set<String> androidCallbacks;
    protected final Map<String, Set<SootMethodAndClass>> callbackMethods = new HashMap<String, Set<SootMethodAndClass>>();
    protected final Map<String, Set<Integer>> layoutClasses = new HashMap<String, Set<Integer>>();
    protected final Set<String> dynamicManifestComponents = new HashSet<String>();

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses) throws IOException {
        this(config, entryPointClasses, "AndroidCallbacks.txt");
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses, String callbackFile) throws IOException {
        this.config = config;
        this.entryPointClasses = entryPointClasses;
        this.androidCallbacks = this.loadAndroidCallbacks(callbackFile);
    }

    public AbstractCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses, Set<String> androidCallbacks) throws IOException {
        this.config = config;
        this.entryPointClasses = entryPointClasses;
        this.androidCallbacks = androidCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadAndroidCallbacks(String androidCallbackFile) throws IOException {
        HashSet<String> androidCallbacks = new HashSet<String>();
        try (BufferedReader rdr = null;){
            String line;
            String fileName = androidCallbackFile;
            if (!new File(fileName).exists() && !new File(fileName = "../soot-infoflow-android/AndroidCallbacks.txt").exists()) {
                throw new RuntimeException("Callback definition file not found");
            }
            rdr = new BufferedReader(new FileReader(fileName));
            while ((line = rdr.readLine()) != null) {
                if (line.isEmpty()) continue;
                androidCallbacks.add(line);
            }
        }
        return androidCallbacks;
    }

    public abstract void collectCallbackMethods();

    public abstract void collectCallbackMethodsIncremental();

    protected void analyzeMethodForCallbackRegistrations(SootClass lifecycleElement, SootMethod method) {
        if (method.getDeclaringClass().getName().startsWith("android.") || method.getDeclaringClass().getName().startsWith("java.")) {
            return;
        }
        if (!method.isConcrete()) {
            return;
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(method.retrieveActiveBody());
        SmartLocalDefs smd = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        HashSet<SootClass> callbackClasses = new HashSet<SootClass>();
        for (Unit u : method.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) continue;
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
            String[] parameters = SootMethodRepresentationParser.v().getParameterTypesFromSubSignature(iinv.getMethodRef().getSubSignature().getString());
            for (int i = 0; i < parameters.length; ++i) {
                Value arg;
                String param = parameters[i];
                if (!this.androidCallbacks.contains(param) || !((arg = iinv.getArg(i)).getType() instanceof RefType) || !(arg instanceof Local)) continue;
                for (Unit def : smd.getDefsOfAt((Local)arg, u)) {
                    assert (def instanceof DefinitionStmt);
                    Type tp = ((DefinitionStmt)def).getRightOp().getType();
                    if (!(tp instanceof RefType)) continue;
                    SootClass callbackClass = ((RefType)tp).getSootClass();
                    if (callbackClass.isInterface()) {
                        for (SootClass impl : Scene.v().getActiveHierarchy().getImplementersOf(callbackClass)) {
                            for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(impl)) {
                                callbackClasses.add(c);
                            }
                        }
                        continue;
                    }
                    for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(callbackClass)) {
                        callbackClasses.add(c);
                    }
                }
            }
        }
        for (SootClass callbackClass : callbackClasses) {
            this.analyzeClass(callbackClass, lifecycleElement);
        }
    }

    protected void analyzeMethodForDynamicBroadcastReceiver(SootMethod method) {
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            Value br;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !stmt.getInvokeExpr().getMethod().getName().equals("registerReceiver") || stmt.getInvokeExpr().getArgCount() <= 0 || !this.isInheritedMethod(stmt, "android.content.ContextWrapper", "android.content.Context") || !((br = stmt.getInvokeExpr().getArg(0)).getType() instanceof RefType)) continue;
            RefType rt = (RefType)br.getType();
            this.dynamicManifestComponents.add(rt.getClassName());
        }
    }

    private boolean isInheritedMethod(Stmt stmt, String ... classNames) {
        if (!stmt.containsInvokeExpr()) {
            return false;
        }
        SootMethod tgt = stmt.getInvokeExpr().getMethod();
        for (String className : classNames) {
            if (!className.equals(tgt.getDeclaringClass().getName())) continue;
            return true;
        }
        if (Scene.v().hasCallGraph()) {
            Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(stmt);
            while (edgeIt.hasNext()) {
                Edge edge = edgeIt.next();
                String targetClass = edge.getTgt().method().getDeclaringClass().getName();
                for (String className : classNames) {
                    if (!className.equals(targetClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean invokesSetContentView(InvokeExpr inv) {
        String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(inv.getMethodRef().getSubSignature().getString());
        if (!methodName.equals("setContentView")) {
            return false;
        }
        SootClass curClass = inv.getMethod().getDeclaringClass();
        while (curClass != null) {
            if (curClass.getName().equals("android.app.Activity") || curClass.getName().equals("android.support.v7.app.ActionBarActivity")) {
                return true;
            }
            if (curClass.declaresMethod("void setContentView(int)")) {
                return false;
            }
            curClass = curClass.hasSuperclass() ? curClass.getSuperclass() : null;
        }
        return false;
    }

    private void analyzeClass(SootClass sootClass, SootClass lifecycleElement) {
        if (sootClass.getName().startsWith("android.") || sootClass.getName().startsWith("java.")) {
            return;
        }
        this.analyzeClassInterfaceCallbacks(sootClass, sootClass, lifecycleElement);
    }

    protected void analyzeMethodOverrideCallbacks(SootClass sootClass) {
        if (!sootClass.isConcrete()) {
            return;
        }
        if (sootClass.isInterface()) {
            return;
        }
        if (this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.isClassInSystemPackage(sootClass.getName())) {
            return;
        }
        HashSet<String> systemMethods = new HashSet<String>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sootClass)) {
            if (!SystemClassHandler.isClassInSystemPackage(parentClass.getName())) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.add(sm.getSubSignature());
            }
        }
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sootClass)) {
            if (parentClass.getName().startsWith("android.")) continue;
            for (SootMethod method : parentClass.getMethods()) {
                if (!systemMethods.contains(method.getSubSignature())) continue;
                this.checkAndAddMethod(method, sootClass);
            }
        }
    }

    private SootMethod getMethodFromHierarchyEx(SootClass c, String methodSignature) {
        if (c.declaresMethod(methodSignature)) {
            return c.getMethod(methodSignature);
        }
        if (c.hasSuperclass()) {
            return this.getMethodFromHierarchyEx(c.getSuperclass(), methodSignature);
        }
        throw new RuntimeException("Could not find method");
    }

    private void analyzeClassInterfaceCallbacks(SootClass baseClass, SootClass sootClass, SootClass lifecycleElement) {
        if (!baseClass.isConcrete()) {
            return;
        }
        if (baseClass.getName().startsWith("android.")) {
            return;
        }
        if (sootClass.hasSuperclass()) {
            this.analyzeClassInterfaceCallbacks(baseClass, sootClass.getSuperclass(), lifecycleElement);
        }
        for (SootClass i : this.collectAllInterfaces(sootClass)) {
            if (!this.androidCallbacks.contains(i.getName())) continue;
            for (SootMethod sm : i.getMethods()) {
                this.checkAndAddMethod(this.getMethodFromHierarchyEx(baseClass, sm.getSubSignature()), lifecycleElement);
            }
        }
    }

    protected boolean checkAndAddMethod(SootMethod method, SootClass baseClass) {
        AndroidMethod am = new AndroidMethod(method);
        if (am.getClassName().startsWith("android.") || am.getClassName().startsWith("java.")) {
            return false;
        }
        if (method.isConcrete() && this.isEmpty(method.retrieveActiveBody())) {
            return false;
        }
        String componentName = baseClass == null ? "" : baseClass.getName();
        Set<SootMethodAndClass> methods = this.callbackMethods.get(componentName);
        if (methods == null) {
            methods = new HashSet<SootMethodAndClass>();
            this.callbackMethods.put(componentName, methods);
        }
        return methods.add(am);
    }

    private boolean isEmpty(Body activeBody) {
        for (Unit u : activeBody.getUnits()) {
            if (u instanceof IdentityStmt || u instanceof ReturnVoidStmt) continue;
            return false;
        }
        return true;
    }

    private Set<SootClass> collectAllInterfaces(SootClass sootClass) {
        HashSet<SootClass> interfaces = new HashSet<SootClass>(sootClass.getInterfaces());
        for (SootClass i : sootClass.getInterfaces()) {
            interfaces.addAll(this.collectAllInterfaces(i));
        }
        return interfaces;
    }

    public Map<String, Set<SootMethodAndClass>> getCallbackMethods() {
        return this.callbackMethods;
    }

    public Map<String, Set<Integer>> getLayoutClasses() {
        return this.layoutClasses;
    }

    public Set<String> getDynamicManifestComponents() {
        return this.dynamicManifestComponents;
    }
}

