/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Unit;
import soot.Value;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AbstractCallbackAnalyzer;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.HashMultiMap;
import soot.util.queue.QueueReader;

public class DefaultCallbackAnalyzer
extends AbstractCallbackAnalyzer {
    private final Map<String, Set<SootMethodAndClass>> callbackWorklist = new HashMap<String, Set<SootMethodAndClass>>();

    public DefaultCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses) throws IOException {
        super(config, entryPointClasses);
    }

    public DefaultCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses, String callbackFile) throws IOException {
        super(config, entryPointClasses, callbackFile);
    }

    public DefaultCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses, Set<String> androidCallbacks) throws IOException {
        super(config, entryPointClasses, androidCallbacks);
    }

    @Override
    public void collectCallbackMethods() {
        this.logger.info("Collecting callbacks in DEFAULT mode...");
        Transform transform = new Transform("wjtp.ajc", new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                DefaultCallbackAnalyzer.this.findClassLayoutMappings();
                for (String className : DefaultCallbackAnalyzer.this.entryPointClasses) {
                    SootClass sc = Scene.v().getSootClass(className);
                    ArrayList<SootMethod> methods = new ArrayList<SootMethod>();
                    methods.addAll(sc.getMethods());
                    DefaultCallbackAnalyzer.this.analyzeRechableMethods(sc, methods);
                    DefaultCallbackAnalyzer.this.analyzeMethodOverrideCallbacks(sc);
                }
                System.out.println("Callback analysis done.");
            }
        });
        PackManager.v().getPack("wjtp").add(transform);
    }

    @Override
    public void collectCallbackMethodsIncremental() {
        Transform transform = new Transform("wjtp.ajc", new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                System.out.println("Running incremental callback analysis for " + DefaultCallbackAnalyzer.this.callbackWorklist.size() + " components...");
                HashMultiMap workListCopy = new HashMultiMap(DefaultCallbackAnalyzer.this.callbackWorklist);
                for (String className : workListCopy.keySet()) {
                    LinkedList<SootMethod> entryClasses = new LinkedList<SootMethod>();
                    for (SootMethodAndClass am : workListCopy.get(className)) {
                        entryClasses.add(Scene.v().getMethod(am.getSignature()));
                    }
                    DefaultCallbackAnalyzer.this.analyzeRechableMethods(Scene.v().getSootClass(className), entryClasses);
                    DefaultCallbackAnalyzer.this.callbackWorklist.remove(className);
                }
                System.out.println("Incremental callback analysis done.");
            }
        });
        PackManager.v().getPack("wjtp").add(transform);
    }

    private void analyzeRechableMethods(SootClass lifecycleElement, List<MethodOrMethodContext> methods) {
        ReachableMethods rm = new ReachableMethods(Scene.v().getCallGraph(), methods);
        rm.update();
        QueueReader<MethodOrMethodContext> reachableMethods = rm.listener();
        while (reachableMethods.hasNext()) {
            SootMethod method = ((MethodOrMethodContext)reachableMethods.next()).method();
            this.analyzeMethodForCallbackRegistrations(lifecycleElement, method);
            this.analyzeMethodForDynamicBroadcastReceiver(method);
        }
    }

    @Override
    protected boolean checkAndAddMethod(SootMethod method, SootClass baseClass) {
        if (super.checkAndAddMethod(method, baseClass)) {
            AndroidMethod am = new AndroidMethod(method);
            if (this.callbackWorklist.containsKey(baseClass.getName())) {
                this.callbackWorklist.get(baseClass.getName()).add(am);
            } else {
                HashSet<AndroidMethod> methods = new HashSet<AndroidMethod>();
                methods.add(am);
                this.callbackWorklist.put(baseClass.getName(), methods);
            }
            return true;
        }
        return false;
    }

    private void findClassLayoutMappings() {
        QueueReader<MethodOrMethodContext> rmIterator = Scene.v().getReachableMethods().listener();
        while (rmIterator.hasNext()) {
            SootMethod sm = ((MethodOrMethodContext)rmIterator.next()).method();
            if (!sm.isConcrete()) continue;
            for (Unit u : sm.retrieveActiveBody().getUnits()) {
                InvokeExpr inv;
                Stmt stmt;
                if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr() || !this.invokesSetContentView(inv = stmt.getInvokeExpr())) continue;
                for (Value val : inv.getArgs()) {
                    if (!(val instanceof IntConstant)) continue;
                    IntConstant constVal = (IntConstant)val;
                    HashSet<Integer> layoutIDs = (HashSet<Integer>)this.layoutClasses.get(sm.getDeclaringClass().getName());
                    if (layoutIDs == null) {
                        layoutIDs = new HashSet<Integer>();
                        this.layoutClasses.put(sm.getDeclaringClass().getName(), layoutIDs);
                    }
                    layoutIDs.add(constVal.value);
                }
            }
        }
    }
}

