/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AbstractCallbackAnalyzer;

public class FastCallbackAnalyzer
extends AbstractCallbackAnalyzer {
    public FastCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses) throws IOException {
        super(config, entryPointClasses);
    }

    public FastCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses, String callbackFile) throws IOException {
        super(config, entryPointClasses, callbackFile);
    }

    public FastCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<String> entryPointClasses, Set<String> androidCallbacks) throws IOException {
        super(config, entryPointClasses, androidCallbacks);
    }

    @Override
    public void collectCallbackMethods() {
        this.logger.info("Collecting callbacks in FAST mode...");
        this.findClassLayoutMappings();
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            if (!sc.isConcrete()) continue;
            for (SootMethod sm : sc.getMethods()) {
                if (!sm.isConcrete()) continue;
                this.analyzeMethodForCallbackRegistrations(null, sm);
                this.analyzeMethodForDynamicBroadcastReceiver(sm);
            }
            this.analyzeMethodOverrideCallbacks(sc);
        }
    }

    @Override
    public void collectCallbackMethodsIncremental() {
    }

    private void findClassLayoutMappings() {
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            if (!sc.isConcrete()) continue;
            for (SootMethod sm : sc.getMethods()) {
                if (!sm.isConcrete()) continue;
                for (Unit u : sm.retrieveActiveBody().getUnits()) {
                    InvokeExpr inv;
                    Stmt stmt;
                    if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr() || !this.invokesSetContentView(inv = stmt.getInvokeExpr())) continue;
                    for (Value val : inv.getArgs()) {
                        if (!(val instanceof IntConstant)) continue;
                        IntConstant constVal = (IntConstant)val;
                        HashSet<Integer> layoutIDs = (HashSet<Integer>)this.layoutClasses.get(sm.getDeclaringClass().getName());
                        if (layoutIDs == null) {
                            layoutIDs = new HashSet<Integer>();
                            this.layoutClasses.put(sm.getDeclaringClass().getName(), layoutIDs);
                        }
                        layoutIDs.add(constVal.value);
                    }
                }
            }
        }
    }
}

