/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class AndroidMethod
extends SootMethodAndClass {
    private Set<String> permissions;
    private boolean isSource = false;
    private boolean isSink = false;
    private boolean isNeitherNor = false;
    private CATEGORY category = null;

    public AndroidMethod(String methodName, String returnType, String className) {
        super(methodName, className, returnType, new ArrayList<String>());
        this.permissions = null;
    }

    public AndroidMethod(String methodName, List<String> parameters, String returnType, String className) {
        super(methodName, className, returnType, parameters);
        this.permissions = null;
    }

    public AndroidMethod(String methodName, List<String> parameters, String returnType, String className, Set<String> permissions) {
        super(methodName, className, returnType, parameters);
        this.permissions = permissions;
    }

    public AndroidMethod(SootMethod sm) {
        super(sm);
        this.permissions = null;
    }

    public AndroidMethod(SootMethodAndClass methodAndClass) {
        super(methodAndClass);
        this.permissions = null;
    }

    public Set<String> getPermissions() {
        return this.permissions == null ? Collections.emptySet() : this.permissions;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    public void addPermission(String permission) {
        if (this.permissions == null) {
            this.permissions = new HashSet<String>();
        }
        this.permissions.add(permission);
    }

    public boolean isSink() {
        return this.isSink;
    }

    public void setSink(boolean isSink) {
        this.isSink = isSink;
    }

    public boolean isNeitherNor() {
        return this.isNeitherNor;
    }

    public void setNeitherNor(boolean isNeitherNor) {
        this.isNeitherNor = isNeitherNor;
    }

    public void setCategory(CATEGORY category) {
        this.category = category;
    }

    public CATEGORY getCategory() {
        return this.category;
    }

    @Override
    public String toString() {
        String s = this.getSignature();
        if (this.permissions != null) {
            for (String perm : this.permissions) {
                s = s + " " + perm;
            }
        }
        if (this.isSource || this.isSink || this.isNeitherNor) {
            s = s + " ->";
        }
        if (this.isSource) {
            s = s + " _SOURCE_";
        }
        if (this.isSink) {
            s = s + " _SINK_ ";
        }
        if (this.isNeitherNor) {
            s = s + " _NONE_";
        }
        if (this.category != null) {
            s = s + "|" + (Object)((Object)this.category);
        }
        return s;
    }

    public String getSignatureAndPermissions() {
        String s = this.getSignature();
        if (this.permissions != null) {
            for (String perm : this.permissions) {
                s = s + " " + perm;
            }
        }
        return s;
    }

    public boolean isAnnotated() {
        return this.isSource || this.isSink || this.isNeitherNor;
    }

    public static AndroidMethod createFromSignature(String signature) {
        if (!signature.startsWith("<")) {
            signature = "<" + signature;
        }
        if (!signature.endsWith(">")) {
            signature = signature + ">";
        }
        SootMethodAndClass smac = SootMethodRepresentationParser.v().parseSootMethodString(signature);
        return new AndroidMethod(smac.getMethodName(), smac.getParameters(), smac.getReturnType(), smac.getClassName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.isNeitherNor ? 1231 : 1237);
        result = 31 * result + (this.isSink ? 1231 : 1237);
        result = 31 * result + (this.isSource ? 1231 : 1237);
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndroidMethod other = (AndroidMethod)obj;
        if (this.category != other.category) {
            return false;
        }
        if (this.isNeitherNor != other.isNeitherNor) {
            return false;
        }
        if (this.isSink != other.isSink) {
            return false;
        }
        if (this.isSource != other.isSource) {
            return false;
        }
        return !(this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions));
    }

    public static enum CATEGORY {
        ALL,
        NO_CATEGORY,
        HARDWARE_INFO,
        UNIQUE_IDENTIFIER,
        LOCATION_INFORMATION,
        NETWORK_INFORMATION,
        ACCOUNT_INFORMATION,
        EMAIL_INFORMATION,
        FILE_INFORMATION,
        BLUETOOTH_INFORMATION,
        VOIP_INFORMATION,
        DATABASE_INFORMATION,
        PHONE_INFORMATION,
        PHONE_CONNECTION,
        INTER_APP_COMMUNICATION,
        VOIP,
        PHONE_STATE,
        EMAIL,
        BLUETOOTH,
        ACCOUNT_SETTINGS,
        VIDEO,
        SYNCHRONIZATION_DATA,
        NETWORK,
        EMAIL_SETTINGS,
        FILE,
        LOG,
        AUDIO,
        SMS_MMS,
        CONTACT_INFORMATION,
        CALENDAR_INFORMATION,
        SYSTEM_SETTINGS,
        IMAGE,
        BROWSER_INFORMATION,
        NFC;

    }
}

