/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.source.data.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.source.data.SourceSinkDefinition;

public class CSVPermissionMethodParser
implements ISourceSinkDefinitionProvider {
    private Set<SourceSinkDefinition> sourceList = null;
    private Set<SourceSinkDefinition> sinkList = null;
    private Set<SourceSinkDefinition> neitherList = null;
    private static final int INITIAL_SET_SIZE = 10000;
    private final String fileName;

    public CSVPermissionMethodParser(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        this.sourceList = new HashSet<SourceSinkDefinition>(10000);
        this.sinkList = new HashSet<SourceSinkDefinition>(10000);
        this.neitherList = new HashSet<SourceSinkDefinition>(10000);
        BufferedReader rdr = null;
        try {
            rdr = new BufferedReader(new FileReader(this.fileName));
            String line = null;
            boolean firstLine = true;
            while ((line = rdr.readLine()) != null) {
                String className;
                String methodName;
                if (firstLine) {
                    firstLine = false;
                    continue;
                }
                firstLine = false;
                String[] fields = line.split("\t");
                if (fields.length < 1) {
                    System.err.println("Found invalid line: " + line);
                    continue;
                }
                ArrayList<String> methodParams = new ArrayList<String>();
                HashSet<String> permissions = new HashSet<String>();
                try {
                    methodName = fields[0].contains(")") ? fields[0].substring(0, fields[0].indexOf("(")) : fields[0];
                    className = methodName.substring(0, methodName.lastIndexOf("."));
                    methodName = methodName.substring(methodName.lastIndexOf(".") + 1);
                    if (fields[0].contains("(")) {
                        String parameters = fields[0].substring(fields[0].indexOf("(") + 1);
                        parameters = parameters.substring(0, parameters.indexOf(")"));
                        for (String p : parameters.split(",")) {
                            methodParams.add(p);
                        }
                    }
                    String perm = fields.length > 1 ? fields[1] : "";
                    perm = perm.replaceAll(" and ", " ");
                    if ((perm = perm.replaceAll(" or ", " ")).contains(".")) {
                        perm = perm.substring(perm.lastIndexOf(".") + 1);
                    }
                    for (String p : perm.split(" ")) {
                        permissions.add(p);
                    }
                }
                catch (StringIndexOutOfBoundsException ex) {
                    System.err.println("Could not parse line: " + line);
                    ex.printStackTrace();
                    continue;
                }
                AndroidMethod method = new AndroidMethod(methodName, methodParams, "", className, permissions);
                if (method.isSource()) {
                    this.sourceList.add(new SourceSinkDefinition(method));
                    continue;
                }
                if (method.isSink()) {
                    this.sinkList.add(new SourceSinkDefinition(method));
                    continue;
                }
                if (!method.isNeitherNor()) continue;
                this.neitherList.add(new SourceSinkDefinition(method));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Set<SourceSinkDefinition> getSources() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sourceList;
    }

    @Override
    public Set<SourceSinkDefinition> getSinks() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sinkList;
    }

    @Override
    public Set<SourceSinkDefinition> getAllMethods() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        HashSet<SourceSinkDefinition> sourcesSinks = new HashSet<SourceSinkDefinition>(this.sourceList.size() + this.sinkList.size() + this.neitherList.size());
        sourcesSinks.addAll(this.sourceList);
        sourcesSinks.addAll(this.sinkList);
        sourcesSinks.addAll(this.neitherList);
        return sourcesSinks;
    }
}

