/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources;

import java.io.File;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import soot.jimple.infoflow.android.resources.IResourceHandler;

public abstract class AbstractResourceParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAndroidResourceFiles(String apk, Set<String> fileNameFilter, IResourceHandler handler) {
        File apkF = new File(apk);
        if (!apkF.exists()) {
            throw new RuntimeException("file '" + apk + "' does not exist!");
        }
        try (ZipFile archive = null;){
            archive = new ZipFile(apkF);
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                handler.handleResourceFile(entryName, fileNameFilter, archive.getInputStream(entry));
            }
        }
        catch (Exception e) {
            System.err.println("Error when looking for XML resource files in apk " + apk + ": " + e);
            e.printStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

