/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source;

import heros.InterproceduralCFG;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.resources.LayoutControl;
import soot.jimple.infoflow.android.source.AndroidSourceSinkManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.source.SourceInfo;
import soot.jimple.infoflow.source.data.AccessPathTuple;
import soot.jimple.infoflow.source.data.SourceSinkDefinition;
import soot.jimple.infoflow.util.SystemClassHandler;

public class AccessPathBasedSourceSinkManager
extends AndroidSourceSinkManager {
    public AccessPathBasedSourceSinkManager(Set<SourceSinkDefinition> sources, Set<SourceSinkDefinition> sinks) {
        super(sources, sinks);
    }

    public AccessPathBasedSourceSinkManager(Set<SourceSinkDefinition> sources, Set<SourceSinkDefinition> sinks, Set<SootMethodAndClass> callbackMethods, AndroidSourceSinkManager.LayoutMatchingMode layoutMatching, Map<Integer, LayoutControl> layoutControls) {
        super(sources, sinks, callbackMethods, layoutMatching, layoutControls);
    }

    @Override
    public SourceInfo getSourceInfo(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg) {
        AndroidSourceSinkManager.SourceType type = this.getSourceType(sCallSite, cfg);
        if (type == AndroidSourceSinkManager.SourceType.NoSource) {
            return null;
        }
        if (type == AndroidSourceSinkManager.SourceType.Callback || type == AndroidSourceSinkManager.SourceType.UISource) {
            return super.getSourceInfo(sCallSite, type);
        }
        String signature = (String)this.methodToSignature.getUnchecked(sCallSite.getInvokeExpr().getMethod());
        SourceSinkDefinition def = (SourceSinkDefinition)this.sourceMethods.get(signature);
        if (null == def || def.isEmpty()) {
            return super.getSourceInfo(sCallSite, cfg);
        }
        HashSet<AccessPath> aps = new HashSet<AccessPath>();
        if (sCallSite.containsInvokeExpr() && sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr && def.getBaseObjects() != null) {
            Value baseVal = ((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase();
            for (AccessPathTuple apt : def.getBaseObjects()) {
                if (!apt.isSource()) continue;
                aps.add(this.getAccessPathFromDef(baseVal, apt));
            }
        }
        if (sCallSite instanceof DefinitionStmt && def.getReturnValues() != null) {
            Value returnVal = ((DefinitionStmt)sCallSite).getLeftOp();
            for (AccessPathTuple apt : def.getReturnValues()) {
                if (!apt.isSource()) continue;
                aps.add(this.getAccessPathFromDef(returnVal, apt));
            }
        }
        if (sCallSite.containsInvokeExpr() && def.getParameters() != null && def.getParameters().length > 0) {
            for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                if (def.getParameters().length <= i) continue;
                for (AccessPathTuple apt : def.getParameters()[i]) {
                    if (!apt.isSource()) continue;
                    aps.add(this.getAccessPathFromDef(sCallSite.getInvokeExpr().getArg(i), apt));
                }
            }
        }
        if (aps.isEmpty()) {
            return super.getSourceInfo(sCallSite, cfg);
        }
        return new SourceInfo(aps);
    }

    private AccessPath getAccessPathFromDef(Value baseVal, AccessPathTuple apt) {
        if (baseVal.getType() instanceof PrimType || apt.getFields() == null || apt.getFields().length == 0) {
            return AccessPathFactory.v().createAccessPath(baseVal, true);
        }
        SootClass baseClass = ((RefType)baseVal.getType()).getSootClass();
        SootField[] fields = new SootField[apt.getFields().length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = baseClass.getFieldByName(apt.getFields()[i]);
        }
        return AccessPathFactory.v().createAccessPath(baseVal, fields, true);
    }

    @Override
    public boolean isSink(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg, AccessPath sourceAccessPath) {
        if (!sCallSite.containsInvokeExpr()) {
            return false;
        }
        String methodSignature = (String)this.methodToSignature.getUnchecked(sCallSite.getInvokeExpr().getMethod());
        SourceSinkDefinition def = (SourceSinkDefinition)this.sinkMethods.get(methodSignature);
        if (def == null) {
            for (SootMethod sm : cfg.getCalleesOfCallAt(sCallSite)) {
                String signature = (String)this.methodToSignature.getUnchecked(sm);
                if (!this.sinkMethods.containsKey(signature)) continue;
                return true;
            }
            return false;
        }
        if (def.isEmpty()) {
            return SystemClassHandler.isTaintVisible(sourceAccessPath, sCallSite.getInvokeExpr().getMethod());
        }
        if (sourceAccessPath == null) {
            return true;
        }
        if (sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr && def.getBaseObjects() != null) {
            for (AccessPathTuple apt : def.getBaseObjects()) {
                if (!apt.isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                return true;
            }
        }
        if (def.getParameters() != null && def.getParameters().length > 0) {
            for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                if (sCallSite.getInvokeExpr().getArg(i) != sourceAccessPath.getPlainValue() || def.getParameters().length <= i) continue;
                for (AccessPathTuple apt : def.getParameters()[i]) {
                    if (!apt.isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean accessPathMatches(AccessPath sourceAccessPath, AccessPathTuple apt) {
        if (apt.getFields() == null || apt.getFields().length == 0 || sourceAccessPath == null) {
            return true;
        }
        for (int i = 0; i < apt.getFields().length; ++i) {
            if (i >= sourceAccessPath.getFieldCount()) {
                return sourceAccessPath.getTaintSubFields();
            }
            if (sourceAccessPath.getFields()[i].getName().equals(apt.getFields()[i])) continue;
            return false;
        }
        return true;
    }
}

