/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.codeOptimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.codeOptimization.ICodeOptimizer;
import soot.jimple.infoflow.codeOptimization.InterproceduralConstantValuePropagator;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.InfoflowCFG;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.util.queue.QueueReader;

public class DeadCodeEliminator
implements ICodeOptimizer {
    private InfoflowConfiguration config;

    @Override
    public void initialize(InfoflowConfiguration config) {
        this.config = config;
    }

    @Override
    public void run(IInfoflowCFG icfg, Collection<SootMethod> entryPoints, ISourceSinkManager sourcesSinks, ITaintPropagationWrapper taintWrapper) {
        QueueReader<MethodOrMethodContext> rdr = Scene.v().getReachableMethods().listener();
        while (rdr.hasNext()) {
            MethodOrMethodContext sm = rdr.next();
            if (sm.method() == null || !sm.method().hasActiveBody() || Scene.v().getEntryPoints().contains(sm.method())) continue;
            List<Unit> callSites = this.getCallsInMethod(sm.method());
            ConstantPropagatorAndFolder.v().transform(sm.method().getActiveBody());
            DeadAssignmentEliminator.v().transform(sm.method().getActiveBody());
            List<Unit> newCallSites = this.getCallsInMethod(sm.method());
            if (callSites == null) continue;
            for (Unit u : callSites) {
                if (newCallSites != null && newCallSites.contains(u)) continue;
                Scene.v().getCallGraph().removeAllEdgesOutOf(u);
            }
        }
        InterproceduralConstantValuePropagator ipcvp = new InterproceduralConstantValuePropagator(new InfoflowCFG(), Scene.v().getEntryPoints(), sourcesSinks, taintWrapper);
        ipcvp.setRemoveSideEffectFreeMethods(this.config.getCodeEliminationMode() == InfoflowConfiguration.CodeEliminationMode.RemoveSideEffectFreeCode && !this.config.getEnableImplicitFlows());
        ipcvp.setExcludeSystemClasses(this.config.getIgnoreFlowsInSystemPackages());
        ipcvp.transform();
        QueueReader<MethodOrMethodContext> rdr2 = Scene.v().getReachableMethods().listener();
        while (rdr2.hasNext()) {
            MethodOrMethodContext sm = rdr2.next();
            if (sm.method() == null || !sm.method().hasActiveBody() || this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.isClassInSystemPackage(sm.method().getDeclaringClass().getName())) continue;
            ConditionalBranchFolder.v().transform(sm.method().getActiveBody());
            List<Unit> callSites = this.getCallsInMethod(sm.method());
            UnreachableCodeEliminator.v().transform(sm.method().getActiveBody());
            List<Unit> newCallSites = this.getCallsInMethod(sm.method());
            if (callSites == null) continue;
            for (Unit u : callSites) {
                if (newCallSites != null && newCallSites.contains(u)) continue;
                Scene.v().getCallGraph().removeAllEdgesOutOf(u);
            }
        }
    }

    private List<Unit> getCallsInMethod(SootMethod method) {
        ArrayList<Unit> callSites = null;
        for (Unit u : method.getActiveBody().getUnits()) {
            if (!((Stmt)u).containsInvokeExpr()) continue;
            if (callSites == null) {
                callSites = new ArrayList<Unit>();
            }
            callSites.add(u);
        }
        return callSites;
    }
}

