/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.ConcreteRef;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.util.TypeUtils;

public class AccessPathFactory {
    private static AccessPathFactory instance = new AccessPathFactory();
    private MyConcurrentHashMap<Type, Set<BasePair>> baseRegister = new MyConcurrentHashMap();

    public static AccessPathFactory v() {
        return instance;
    }

    public AccessPath createAccessPath(Value val, boolean taintSubFields) {
        return this.createAccessPath(val, null, null, null, taintSubFields, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
    }

    public AccessPath createAccessPath(Value val, Type valType, boolean taintSubFields, AccessPath.ArrayTaintType arrayTaintType) {
        return this.createAccessPath(val, null, valType, null, taintSubFields, false, true, arrayTaintType);
    }

    public AccessPath createAccessPath(Value val, SootField[] appendingFields, boolean taintSubFields) {
        return this.createAccessPath(val, appendingFields, null, null, taintSubFields, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
    }

    public AccessPath createAccessPath(Value val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType) {
        return this.createAccessPath(val, appendingFields, valType, appendingFieldTypes, taintSubFields, cutFirstField, reduceBases, arrayTaintType, false);
    }

    public AccessPath createAccessPath(Value val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType, boolean canHaveImmutableAliases) {
        boolean cutOffApproximation;
        Type[] fieldTypes;
        SootField[] fields;
        Type baseType;
        Local value;
        ConcreteRef ref;
        assert (val == null && appendingFields != null && appendingFields.length > 0 || AccessPath.canContainValue(val));
        if (appendingFields != null && appendingFieldTypes == null) {
            appendingFieldTypes = new Type[appendingFields.length];
            for (int i = 0; i < appendingFields.length; ++i) {
                appendingFieldTypes[i] = appendingFields[i].getType();
            }
        }
        if (val instanceof FieldRef) {
            ref = (FieldRef)val;
            if (val instanceof InstanceFieldRef) {
                InstanceFieldRef iref = (InstanceFieldRef)val;
                value = (Local)iref.getBase();
                baseType = value.getType();
            } else {
                value = null;
                baseType = null;
            }
            fields = new SootField[(appendingFields == null ? 0 : appendingFields.length) + 1];
            fields[0] = ref.getField();
            if (appendingFields != null) {
                System.arraycopy(appendingFields, 0, fields, 1, appendingFields.length);
            }
            fieldTypes = new Type[(appendingFieldTypes == null ? 0 : appendingFieldTypes.length) + 1];
            Type type = fieldTypes[0] = valType != null ? valType : fields[0].getType();
            if (appendingFieldTypes != null) {
                System.arraycopy(appendingFieldTypes, 0, fieldTypes, 1, appendingFieldTypes.length);
            }
        } else if (val instanceof ArrayRef) {
            ref = (ArrayRef)val;
            value = (Local)ref.getBase();
            baseType = valType == null ? value.getType() : valType;
            fields = appendingFields;
            fieldTypes = appendingFieldTypes;
        } else {
            value = (Local)val;
            baseType = valType == null ? (value == null ? null : value.getType()) : valType;
            fields = appendingFields;
            fieldTypes = appendingFieldTypes;
        }
        if (InfoflowConfiguration.getAccessPathLength() == 0) {
            fields = null;
            fieldTypes = null;
        }
        if (cutFirstField && fields != null && fields.length > 0) {
            SootField[] newFields = new SootField[fields.length - 1];
            Type[] newTypes = new Type[newFields.length];
            System.arraycopy(fields, 1, newFields, 0, newFields.length);
            System.arraycopy(fieldTypes, 1, newTypes, 0, newTypes.length);
            fields = newFields.length > 0 ? newFields : null;
            Object object = fieldTypes = newTypes.length > 0 ? newTypes : null;
        }
        if (InfoflowConfiguration.getUseTypeTightening()) {
            if (value != null && value.getType() != baseType) {
                if ((baseType = TypeUtils.getMorePreciseType(baseType, value.getType())) == null) {
                    return null;
                }
                if (fields != null && fields.length > 0 && !(baseType instanceof ArrayType)) {
                    baseType = TypeUtils.getMorePreciseType(baseType, fields[0].getDeclaringClass().getType());
                }
                if (baseType == null) {
                    return null;
                }
            }
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    fieldTypes[i] = TypeUtils.getMorePreciseType(fieldTypes[i], fields[i].getType());
                    if (fieldTypes[i] == null) {
                        return null;
                    }
                    if (fields.length > i + 1 && !(fieldTypes[i] instanceof ArrayType)) {
                        fieldTypes[i] = TypeUtils.getMorePreciseType(fieldTypes[i], fields[i + 1].getDeclaringClass().getType());
                    }
                    if (fieldTypes[i] != null) continue;
                    return null;
                }
            }
        }
        assert (value == null || value.getType() instanceof RefType || value.getType() instanceof ArrayType && (((ArrayType)value.getType()).getArrayElementType() instanceof ArrayType || ((ArrayType)value.getType()).getArrayElementType() instanceof RefType) || fields == null || fields.length == 0);
        if (InfoflowConfiguration.getUseThisChainReduction() && reduceBases && fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith("this$")) continue;
                String outerClassName = ((RefType)fields[i].getType()).getClassName();
                int startIdx = -1;
                if (value != null && value.getType() instanceof RefType && ((RefType)value.getType()).getClassName().equals(outerClassName)) {
                    startIdx = 0;
                } else {
                    for (int j = 0; j < i; ++j) {
                        if (!(fields[j].getType() instanceof RefType) || !((RefType)fields[j].getType()).getClassName().equals(outerClassName)) continue;
                        startIdx = j;
                        break;
                    }
                }
                if (startIdx < 0) continue;
                SootField[] newFields = new SootField[fields.length - (i - startIdx) - 1];
                Type[] newFieldTypes = new Type[fieldTypes.length - (i - startIdx) - 1];
                System.arraycopy(fields, 0, newFields, 0, startIdx);
                System.arraycopy(fieldTypes, 0, newFieldTypes, 0, startIdx);
                System.arraycopy(fields, i + 1, newFields, startIdx, fields.length - i - 1);
                System.arraycopy(fieldTypes, i + 1, newFieldTypes, startIdx, fieldTypes.length - i - 1);
                fields = newFields;
                fieldTypes = newFieldTypes;
                break;
            }
        }
        boolean recursiveCutOff = false;
        if (InfoflowConfiguration.getUseRecursiveAccessPaths() && reduceBases && fields != null) {
            int ei;
            int n = ei = val instanceof StaticFieldRef ? 1 : 0;
            while (ei < fields.length) {
                Type eiType = ei == 0 ? baseType : fieldTypes[ei - 1];
                int ej = ei;
                while (ej < fields.length) {
                    if (fieldTypes[ej] == eiType || fields[ej].getType() == eiType) {
                        SootField[] newFields = new SootField[fields.length - (ej - ei) - 1];
                        Type[] newTypes = new Type[newFields.length];
                        System.arraycopy(fields, 0, newFields, 0, ei);
                        System.arraycopy(fieldTypes, 0, newTypes, 0, ei);
                        if (fields.length > ej) {
                            System.arraycopy(fields, ej + 1, newFields, ei, fields.length - ej - 1);
                            System.arraycopy(fieldTypes, ej + 1, newTypes, ei, fieldTypes.length - ej - 1);
                        }
                        SootField[] base = new SootField[ej - ei + 1];
                        Type[] baseTypes = new Type[ej - ei + 1];
                        System.arraycopy(fields, ei, base, 0, base.length);
                        System.arraycopy(fieldTypes, ei, baseTypes, 0, base.length);
                        this.registerBase(eiType, base, baseTypes);
                        fields = newFields;
                        fieldTypes = newTypes;
                        recursiveCutOff = true;
                        continue;
                    }
                    ++ej;
                }
                ++ei;
            }
        }
        if (fields != null) {
            int fieldNum = Math.min(InfoflowConfiguration.getAccessPathLength(), fields.length);
            if (fields.length > fieldNum) {
                taintSubFields = true;
                cutOffApproximation = true;
            } else {
                cutOffApproximation = recursiveCutOff;
            }
            if (fieldNum == 0) {
                fields = null;
                fieldTypes = null;
            } else {
                SootField[] newFields = new SootField[fieldNum];
                Type[] newFieldTypes = new Type[fieldNum];
                System.arraycopy(fields, 0, newFields, 0, fieldNum);
                System.arraycopy(fieldTypes, 0, newFieldTypes, 0, fieldNum);
                fields = newFields;
                fieldTypes = newFieldTypes;
            }
        } else {
            cutOffApproximation = false;
            fields = null;
            fieldTypes = null;
        }
        assert (value == null || baseType instanceof ArrayType || TypeUtils.isObjectLikeType(baseType) || !(value.getType() instanceof ArrayType));
        assert (value == null || !(baseType instanceof ArrayType) || value.getType() instanceof ArrayType || TypeUtils.isObjectLikeType(value.getType())) : "Type mismatch. Type was " + baseType + ", value was: " + (value == null ? null : value.getType());
        return new AccessPath(value, fields, baseType, fieldTypes, taintSubFields, cutOffApproximation, arrayTaintType, canHaveImmutableAliases);
    }

    private void registerBase(Type eiType, SootField[] base, Type[] baseTypes) {
        assert (base.length == baseTypes.length);
        for (int i = 0; i < base.length; ++i) {
            if (baseTypes[i] != eiType) continue;
            SootField[] newBase = new SootField[i + 1];
            Type[] newTypes = new Type[i + 1];
            System.arraycopy(base, 0, newBase, 0, i + 1);
            System.arraycopy(baseTypes, 0, newTypes, 0, i + 1);
            base = newBase;
            baseTypes = newTypes;
            break;
        }
        Set bases = this.baseRegister.putIfAbsentElseGet(eiType, new ConcurrentHashSet());
        bases.add(new BasePair(base, baseTypes));
    }

    public void clearBaseRegister() {
        this.baseRegister.clear();
    }

    public Collection<BasePair> getBaseForType(Type tp) {
        return (Collection)this.baseRegister.get(tp);
    }

    public static class BasePair {
        private final SootField[] fields;
        private final Type[] types;
        private int hashCode = 0;

        private BasePair(SootField[] fields, Type[] types) {
            this.fields = fields;
            this.types = types;
            if (fields == null || fields.length == 0) {
                throw new RuntimeException("A base must contain at least one field");
            }
        }

        public SootField[] getFields() {
            return this.fields;
        }

        public Type[] getTypes() {
            return this.types;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + Arrays.hashCode(this.fields);
                this.hashCode = result = 31 * result + Arrays.hashCode(this.types);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasePair other = (BasePair)obj;
            if (!Arrays.equals(this.fields, other.fields)) {
                return false;
            }
            return Arrays.equals(this.types, other.types);
        }

        public String toString() {
            return Arrays.toString(this.fields);
        }
    }
}

