/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.solver.IMemoryManager;

public class FlowDroidMemoryManager
implements IMemoryManager<Abstraction> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentMap<AccessPath, AccessPath> apCache = new ConcurrentHashMap<AccessPath, AccessPath>();
    private ConcurrentHashMap<AbstractionCacheKey, Abstraction> absCache = new ConcurrentHashMap();
    private AtomicInteger reuseCounter = new AtomicInteger();
    private final boolean tracingEnabled;
    private final PathDataErasureMode erasePathData;
    private boolean useAbstractionCache = false;

    public FlowDroidMemoryManager() {
        this(false, PathDataErasureMode.EraseNothing);
    }

    public FlowDroidMemoryManager(boolean tracingEnabled, PathDataErasureMode erasePathData) {
        this.tracingEnabled = tracingEnabled;
        this.erasePathData = erasePathData;
        this.logger.info("Initializing FlowDroid memory manager...");
        if (this.tracingEnabled) {
            this.logger.info("FDMM: Tracing enabled. This may negatively affect performance.");
        }
        if (this.erasePathData != PathDataErasureMode.EraseNothing) {
            this.logger.info("FDMM: Path data erasure enabled");
        }
    }

    private AccessPath getCachedAccessPath(AccessPath ap) {
        AccessPath oldAP = this.apCache.putIfAbsent(ap, ap);
        if (oldAP == null) {
            return ap;
        }
        if (this.tracingEnabled && oldAP != ap) {
            this.reuseCounter.incrementAndGet();
        }
        return oldAP;
    }

    private Abstraction getCachedAbstraction(Abstraction abs) {
        Abstraction oldAbs = this.absCache.putIfAbsent(new AbstractionCacheKey(abs), abs);
        if (oldAbs != null && oldAbs != abs && this.tracingEnabled) {
            this.reuseCounter.incrementAndGet();
        }
        return oldAbs;
    }

    public int getReuseCount() {
        return this.reuseCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Abstraction handleMemoryObject(Abstraction obj) {
        Abstraction cachedAbs;
        if (this.useAbstractionCache && (cachedAbs = this.getCachedAbstraction(obj)) != null) {
            return cachedAbs;
        }
        AccessPath newAP = this.getCachedAccessPath(obj.getAccessPath());
        obj.setAccessPath(newAP);
        if (this.erasePathData != PathDataErasureMode.EraseNothing) {
            for (Abstraction curAbs = obj; curAbs != null; curAbs = curAbs.getPredecessor()) {
                Abstraction abstraction;
                boolean doErase;
                boolean bl = doErase = this.erasePathData == PathDataErasureMode.EraseAll;
                if (this.erasePathData == PathDataErasureMode.KeepOnlyContextData && curAbs.getCorrespondingCallSite() == curAbs.getCurrentStmt()) {
                    doErase = true;
                }
                if (this.erasePathData == PathDataErasureMode.KeepOnlyContextData && curAbs.getCorrespondingCallSite() == null && curAbs.getCurrentStmt() != null) {
                    abstraction = curAbs;
                    synchronized (abstraction) {
                        if (!(curAbs.getCorrespondingCallSite() != null || curAbs.getCurrentStmt() == null || curAbs.getCurrentStmt().containsInvokeExpr() || curAbs.getCurrentStmt() instanceof ReturnStmt || curAbs.getCurrentStmt() instanceof ReturnVoidStmt)) {
                            doErase = true;
                        }
                    }
                }
                abstraction = curAbs;
                synchronized (abstraction) {
                    if (doErase) {
                        curAbs.setCurrentStmt(null);
                        curAbs.setCorrespondingCallSite(null);
                    }
                    continue;
                }
            }
        }
        if (this.erasePathData != PathDataErasureMode.EraseNothing) {
            Abstraction pred;
            Abstraction curAbs = pred = obj.getPredecessor();
            while (curAbs != null && curAbs.getNeighbors() == null) {
                Abstraction predPred = curAbs.getPredecessor();
                if (predPred != null && predPred.equals(obj)) {
                    pred = predPred.getPredecessor();
                    obj = predPred;
                }
                curAbs = predPred;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Abstraction handleGeneratedMemoryObject(Abstraction input, Abstraction output) {
        if (input == output) {
            return output;
        }
        Abstraction pred = output.getPredecessor();
        if (pred != null && pred != input) {
            output.setPredecessor(input);
        }
        if (input.equals(output)) {
            if (output.getCurrentStmt() == null || input.getCurrentStmt() == output.getCurrentStmt()) {
                return input;
            }
            if (input.getCurrentStmt() == null) {
                Abstraction abstraction = input;
                synchronized (abstraction) {
                    if (input.getCurrentStmt() == null) {
                        input.setCurrentStmt(output.getCurrentStmt());
                        input.setCorrespondingCallSite(output.getCorrespondingCallSite());
                        return input;
                    }
                }
            }
        }
        return output;
    }

    public void setUseAbstractionCache(boolean useAbstractionCache) {
        this.useAbstractionCache = useAbstractionCache;
    }

    public static enum PathDataErasureMode {
        EraseNothing,
        KeepOnlyContextData,
        EraseAll;

    }

    private class AbstractionCacheKey {
        private final Abstraction abs;

        public AbstractionCacheKey(Abstraction abs) {
            this.abs = abs;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * this.abs.hashCode();
            result = 31 * result + (this.abs.getPredecessor() == null ? 0 : this.abs.getPredecessor().hashCode());
            result = 31 * result + (this.abs.getCurrentStmt() == null ? 0 : this.abs.getCurrentStmt().hashCode());
            result = 31 * result + (this.abs.getCorrespondingCallSite() == null ? 0 : this.abs.getCorrespondingCallSite().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractionCacheKey other = (AbstractionCacheKey)obj;
            if (!this.abs.equals(other.abs)) {
                return false;
            }
            if (this.abs.getPredecessor() != other.abs.getPredecessor()) {
                return false;
            }
            if (this.abs.getCurrentStmt() != other.abs.getCurrentStmt()) {
                return false;
            }
            return this.abs.getCorrespondingCallSite() == other.abs.getCorrespondingCallSite();
        }
    }
}

