/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import heros.solver.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContext;

public class SourceContextAndPath
extends SourceContext
implements Cloneable {
    protected List<Abstraction> path = null;
    protected List<Stmt> callStack = null;
    protected int neighborCounter = 0;
    private int hashCode = 0;

    public SourceContextAndPath(AccessPath value, Stmt stmt) {
        this(value, stmt, null);
    }

    public SourceContextAndPath(AccessPath value, Stmt stmt, Object userData) {
        super(value, stmt, userData);
    }

    public List<Abstraction> getAbstractionPath() {
        return this.path;
    }

    public List<Stmt> getPath() {
        if (this.path == null) {
            return Collections.emptyList();
        }
        ArrayList<Stmt> stmtPath = new ArrayList<Stmt>(this.path.size());
        for (Abstraction abs : this.path) {
            if (abs.getCurrentStmt() == null) continue;
            stmtPath.add(abs.getCurrentStmt());
        }
        return stmtPath;
    }

    public SourceContextAndPath extendPath(Abstraction abs) {
        return this.extendPath(abs, true);
    }

    public SourceContextAndPath extendPath(Abstraction abs, boolean trackPath) {
        if (abs == null) {
            return this;
        }
        if (abs.getCurrentStmt() == null && abs.getCorrespondingCallSite() == null) {
            return this;
        }
        if (abs.getCorrespondingCallSite() == null && !trackPath) {
            return this;
        }
        SourceContextAndPath scap = null;
        if (trackPath && abs.getCurrentStmt() != null) {
            scap = this.clone();
            if (this.path != null) {
                for (Abstraction a : scap.path) {
                    if (a == abs) {
                        return null;
                    }
                    if (a.getNeighbors() != null && a.getNeighbors().contains(abs)) {
                        return null;
                    }
                    if (!a.equals(abs) || a.getCurrentStmt() != abs.getCurrentStmt() || a.getCorrespondingCallSite() != abs.getCorrespondingCallSite()) continue;
                    return null;
                }
                Abstraction topAbs = scap.path.get(0);
                if (topAbs.equals(abs) && topAbs.getCorrespondingCallSite() != null && topAbs.getCorrespondingCallSite() == abs.getCorrespondingCallSite() && topAbs.getCurrentStmt() != abs.getCurrentStmt()) {
                    return null;
                }
            }
            if (scap.path == null) {
                scap.path = new ArrayList<Abstraction>();
            }
            scap.path.add(0, abs);
        }
        if (abs.getCorrespondingCallSite() != null && abs.getCorrespondingCallSite() != abs.getCurrentStmt()) {
            if (scap == null) {
                scap = this.clone();
            }
            if (scap.callStack == null) {
                scap.callStack = new ArrayList<Stmt>();
            }
            scap.callStack.add(0, abs.getCorrespondingCallSite());
        }
        this.neighborCounter = abs.getNeighbors() == null ? 0 : abs.getNeighbors().size();
        return scap == null ? this : scap;
    }

    public Pair<SourceContextAndPath, Stmt> popTopCallStackItem() {
        if (this.callStack == null || this.callStack.isEmpty()) {
            return null;
        }
        SourceContextAndPath scap = this.clone();
        return new Pair<SourceContextAndPath, Stmt>(scap, scap.callStack.remove(0));
    }

    public boolean isCallStackEmpty() {
        return this.callStack == null || this.callStack.isEmpty();
    }

    public void setNeighborCounter(int counter) {
        this.neighborCounter = counter;
    }

    public int getNeighborCounter() {
        return this.neighborCounter;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SourceContextAndPath scap = (SourceContextAndPath)other;
        if (this.hashCode != 0 && scap.hashCode != 0 && this.hashCode != scap.hashCode) {
            return false;
        }
        if (this.callStack == null ? scap.callStack != null : !this.callStack.equals(scap.callStack)) {
            return false;
        }
        if (!InfoflowConfiguration.getPathAgnosticResults() && !this.path.equals(scap.path)) {
            return false;
        }
        return super.equals(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        SourceContextAndPath sourceContextAndPath = this;
        synchronized (sourceContextAndPath) {
            this.hashCode = (!InfoflowConfiguration.getPathAgnosticResults() ? 31 * (this.path == null ? 0 : this.path.hashCode()) : 0) + 31 * (this.callStack == null ? 0 : this.callStack.hashCode()) + 31 * super.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public synchronized SourceContextAndPath clone() {
        SourceContextAndPath scap = new SourceContextAndPath(this.getAccessPath(), this.getStmt(), this.getUserData());
        if (this.path != null) {
            scap.path = new ArrayList<Abstraction>(this.path);
        }
        if (this.callStack != null) {
            scap.callStack = new ArrayList<Stmt>(this.callStack);
        }
        return scap;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\ton Path: " + this.path;
    }
}

