/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import heros.solver.CountingThreadPoolExecutor;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.collect.ConcurrentIdentityHashMultiMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.data.pathBuilders.AbstractAbstractionPathBuilder;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class ContextInsensitivePathBuilder
extends AbstractAbstractionPathBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InfoflowResults results = new InfoflowResults();
    private final CountingThreadPoolExecutor executor;
    private ConcurrentIdentityHashMultiMap<Abstraction, SourceContextAndPath> pathCache = new ConcurrentIdentityHashMultiMap();

    public ContextInsensitivePathBuilder(IInfoflowCFG icfg, CountingThreadPoolExecutor executor, boolean reconstructPaths) {
        super(icfg, reconstructPaths);
        this.executor = executor;
    }

    private boolean checkForSource(Abstraction abs, SourceContextAndPath scap) {
        if (abs.getPredecessor() != null) {
            return false;
        }
        assert (abs.getSourceContext() != null);
        assert (abs.getNeighbors() == null);
        SourceContext sourceContext = abs.getSourceContext();
        this.results.addResult(scap.getAccessPath(), scap.getStmt(), sourceContext.getAccessPath(), sourceContext.getStmt(), sourceContext.getUserData(), scap.getAbstractionPath());
        return true;
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        this.runSourceFindingTasks(res);
    }

    private void runSourceFindingTasks(Set<AbstractionAtSink> res) {
        if (res.isEmpty()) {
            return;
        }
        long beforePathTracking = System.nanoTime();
        this.logger.info("Obtainted {} connections between sources and sinks", (Object)res.size());
        int curResIdx = 0;
        for (AbstractionAtSink abs : res) {
            this.logger.info("Building path " + ++curResIdx);
            this.buildPathForAbstraction(abs);
            if (abs.getAbstraction().getNeighbors() == null) continue;
            for (Abstraction neighbor : abs.getAbstraction().getNeighbors()) {
                AbstractionAtSink neighborAtSink = new AbstractionAtSink(neighbor, abs.getSinkStmt());
                this.buildPathForAbstraction(neighborAtSink);
            }
        }
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException ex) {
            this.logger.error("Could not wait for path executor completion: {0}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
        this.logger.info("Path processing took {} seconds in total", (Object)((double)(System.nanoTime() - beforePathTracking) / 1.0E9));
    }

    private void buildPathForAbstraction(AbstractionAtSink abs) {
        SourceContextAndPath scap = new SourceContextAndPath(abs.getAbstraction().getAccessPath(), abs.getSinkStmt());
        scap = scap.extendPath(abs.getAbstraction());
        if (this.pathCache.put(abs.getAbstraction(), scap) && !this.checkForSource(abs.getAbstraction(), scap)) {
            this.executor.execute(new SourceFindingTask(abs.getAbstraction()));
        }
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public void runIncrementalPathCompuation() {
        for (Abstraction abs : this.pathCache.keySet()) {
            for (SourceContextAndPath scap : this.pathCache.get(abs)) {
                if (abs.getNeighbors() == null || abs.getNeighbors().size() == scap.getNeighborCounter()) continue;
                scap.setNeighborCounter(abs.getNeighbors().size());
                for (Abstraction neighbor : abs.getNeighbors()) {
                    this.buildPathForAbstraction(new AbstractionAtSink(neighbor, scap.getStmt()));
                }
            }
        }
    }

    private class SourceFindingTask
    implements Runnable {
        private final Abstraction abstraction;

        public SourceFindingTask(Abstraction abstraction) {
            this.abstraction = abstraction;
        }

        @Override
        public void run() {
            Set paths = ContextInsensitivePathBuilder.this.pathCache.get(this.abstraction);
            Abstraction pred = this.abstraction.getPredecessor();
            if (pred != null) {
                for (SourceContextAndPath scap : paths) {
                    if (this.processPredecessor(scap, pred)) {
                        ContextInsensitivePathBuilder.this.executor.execute(new SourceFindingTask(pred));
                    }
                    if (pred.getNeighbors() == null) continue;
                    for (Abstraction neighbor : pred.getNeighbors()) {
                        if (!this.processPredecessor(scap, neighbor)) continue;
                        ContextInsensitivePathBuilder.this.executor.execute(new SourceFindingTask(neighbor));
                    }
                }
            }
        }

        private boolean processPredecessor(SourceContextAndPath scap, Abstraction pred) {
            SourceContextAndPath extendedScap = scap.extendPath(pred, ContextInsensitivePathBuilder.this.reconstructPaths);
            if (extendedScap == null) {
                return false;
            }
            ContextInsensitivePathBuilder.this.checkForSource(pred, extendedScap);
            return ContextInsensitivePathBuilder.this.pathCache.put(pred, extendedScap);
        }
    }
}

