/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import heros.solver.CountingThreadPoolExecutor;
import heros.solver.Pair;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.Stmt;
import soot.jimple.infoflow.collect.ConcurrentIdentityHashMultiMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.data.pathBuilders.AbstractAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class ContextSensitivePathBuilder
extends AbstractAbstractionPathBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InfoflowResults results = new InfoflowResults();
    private final CountingThreadPoolExecutor executor;
    protected ConcurrentIdentityHashMultiMap<Abstraction, SourceContextAndPath> pathCache = new ConcurrentIdentityHashMultiMap();

    public ContextSensitivePathBuilder(IInfoflowCFG icfg, CountingThreadPoolExecutor executor, boolean reconstructPaths) {
        super(icfg, reconstructPaths);
        this.executor = executor;
    }

    protected boolean checkForSource(Abstraction abs, SourceContextAndPath scap) {
        if (abs.getPredecessor() != null) {
            return false;
        }
        assert (abs.getSourceContext() != null);
        assert (abs.getNeighbors() == null);
        SourceContext sourceContext = abs.getSourceContext();
        Pair<ResultSourceInfo, ResultSinkInfo> newResult = this.results.addResult(scap.getAccessPath(), scap.getStmt(), sourceContext.getAccessPath(), sourceContext.getStmt(), sourceContext.getUserData(), scap.getAbstractionPath());
        if (this.resultAvailableHandlers != null) {
            for (IAbstractionPathBuilder.OnPathBuilderResultAvailable handler : this.resultAvailableHandlers) {
                handler.onResultAvailable(newResult.getO1(), newResult.getO2());
            }
        }
        return true;
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        this.logger.info("Context-sensitive path reconstructor started");
        this.runSourceFindingTasks(res);
    }

    private void runSourceFindingTasks(Set<AbstractionAtSink> res) {
        if (res.isEmpty()) {
            return;
        }
        this.logger.info("Obtainted {} connections between {} sources and sinks", (Object)res.size());
        for (AbstractionAtSink abs : res) {
            this.buildPathForAbstraction(abs);
            if (abs.getAbstraction().getNeighbors() == null) continue;
            for (Abstraction neighbor : abs.getAbstraction().getNeighbors()) {
                AbstractionAtSink neighborAtSink = new AbstractionAtSink(neighbor, abs.getSinkStmt());
                this.buildPathForAbstraction(neighborAtSink);
            }
        }
    }

    @Override
    public void runIncrementalPathCompuation() {
        for (Abstraction abs : this.pathCache.keySet()) {
            for (SourceContextAndPath scap : this.pathCache.get(abs)) {
                if (abs.getNeighbors() == null || abs.getNeighbors().size() == scap.getNeighborCounter()) continue;
                scap.setNeighborCounter(abs.getNeighbors().size());
                for (Abstraction neighbor : abs.getNeighbors()) {
                    this.buildPathForAbstraction(new AbstractionAtSink(neighbor, scap.getStmt()));
                }
            }
        }
    }

    protected void buildPathForAbstraction(AbstractionAtSink abs) {
        SourceContextAndPath scap = new SourceContextAndPath(abs.getAbstraction().getAccessPath(), abs.getSinkStmt());
        scap = scap.extendPath(abs.getAbstraction());
        if (this.pathCache.put(abs.getAbstraction(), scap) && !this.checkForSource(abs.getAbstraction(), scap)) {
            this.spawnSourceFindingTask(abs.getAbstraction());
        }
    }

    protected void spawnSourceFindingTask(Abstraction abs) {
        this.executor.execute(new SourceFindingTask(abs));
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    private class SourceFindingTask
    implements Runnable {
        private final Abstraction abstraction;

        public SourceFindingTask(Abstraction abstraction) {
            this.abstraction = abstraction;
        }

        @Override
        public void run() {
            Set<SourceContextAndPath> paths = ContextSensitivePathBuilder.this.pathCache.get(this.abstraction);
            Abstraction pred = this.abstraction.getPredecessor();
            if (pred != null && paths != null) {
                for (SourceContextAndPath scap : paths) {
                    if (this.processPredecessor(scap, pred)) {
                        ContextSensitivePathBuilder.this.spawnSourceFindingTask(pred);
                    }
                    if (pred.getNeighbors() == null) continue;
                    for (Abstraction neighbor : pred.getNeighbors()) {
                        if (!this.processPredecessor(scap, neighbor)) continue;
                        ContextSensitivePathBuilder.this.spawnSourceFindingTask(neighbor);
                    }
                }
            }
        }

        private boolean processPredecessor(SourceContextAndPath scap, Abstraction pred) {
            Pair<SourceContextAndPath, Stmt> pathAndItem;
            if (pred.getCurrentStmt() != null && pred.getCurrentStmt() == pred.getCorrespondingCallSite()) {
                SourceContextAndPath extendedScap = scap.extendPath(pred, ContextSensitivePathBuilder.this.reconstructPaths);
                if (extendedScap == null) {
                    return false;
                }
                ContextSensitivePathBuilder.this.checkForSource(pred, extendedScap);
                return ContextSensitivePathBuilder.this.pathCache.put(pred, extendedScap);
            }
            SourceContextAndPath extendedScap = scap.extendPath(pred, ContextSensitivePathBuilder.this.reconstructPaths);
            if (extendedScap == null) {
                return false;
            }
            if (pred.getCurrentStmt() != null && pred.getCurrentStmt().containsInvokeExpr() && (pathAndItem = extendedScap.popTopCallStackItem()) != null) {
                Stmt topCallStackItem = pathAndItem.getO2();
                if (topCallStackItem != pred.getCurrentStmt()) {
                    return false;
                }
                extendedScap = pathAndItem.getO1();
            }
            ContextSensitivePathBuilder.this.checkForSource(pred, extendedScap);
            return ContextSensitivePathBuilder.this.pathCache.put(pred, extendedScap);
        }
    }
}

