/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import heros.solver.CountingThreadPoolExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import soot.jimple.infoflow.data.pathBuilders.ContextInsensitivePathBuilder;
import soot.jimple.infoflow.data.pathBuilders.ContextInsensitiveSourceFinder;
import soot.jimple.infoflow.data.pathBuilders.ContextSensitivePathBuilder;
import soot.jimple.infoflow.data.pathBuilders.EmptyPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.RecursivePathBuilder;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class DefaultPathBuilderFactory
implements IPathBuilderFactory {
    private final boolean reconstructPaths;
    private final PathBuilder pathBuilder;

    public DefaultPathBuilderFactory() {
        this(PathBuilder.ContextSensitive, false);
    }

    public DefaultPathBuilderFactory(PathBuilder builder, boolean reconstructPaths) {
        this.pathBuilder = builder;
        this.reconstructPaths = reconstructPaths;
    }

    private CountingThreadPoolExecutor createExecutor(int maxThreadNum) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        return new CountingThreadPoolExecutor(maxThreadNum == -1 ? numThreads : Math.min(maxThreadNum, numThreads), Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public IAbstractionPathBuilder createPathBuilder(int maxThreadNum, IInfoflowCFG icfg) {
        return this.createPathBuilder(this.createExecutor(maxThreadNum), icfg);
    }

    @Override
    public IAbstractionPathBuilder createPathBuilder(CountingThreadPoolExecutor executor, IInfoflowCFG icfg) {
        switch (this.pathBuilder) {
            case Recursive: {
                return new RecursivePathBuilder(icfg, executor, this.reconstructPaths);
            }
            case ContextSensitive: {
                return new ContextSensitivePathBuilder(icfg, executor, this.reconstructPaths);
            }
            case ContextInsensitive: {
                return new ContextInsensitivePathBuilder(icfg, executor, this.reconstructPaths);
            }
            case ContextInsensitiveSourceFinder: {
                return new ContextInsensitiveSourceFinder(icfg, executor);
            }
            case None: {
                return new EmptyPathBuilder();
            }
        }
        throw new RuntimeException("Unsupported path building algorithm");
    }

    @Override
    public boolean supportsPathReconstruction() {
        switch (this.pathBuilder) {
            case Recursive: 
            case ContextSensitive: 
            case ContextInsensitive: {
                return this.reconstructPaths;
            }
            case ContextInsensitiveSourceFinder: 
            case None: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported path building algorithm");
    }

    @Override
    public boolean isContextSensitive() {
        return this.pathBuilder == PathBuilder.ContextSensitive;
    }

    public static enum PathBuilder {
        Recursive,
        ContextSensitive,
        ContextInsensitive,
        ContextInsensitiveSourceFinder,
        None;

    }
}

