/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.dava.internal.javaRep.DIntConstant;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;

public abstract class BaseEntryPointCreator
implements IEntryPointCreator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Local> localVarsForClasses = new HashMap<String, Local>();
    private final Set<SootClass> failedClasses = new HashSet<SootClass>();
    private boolean substituteCallParams = false;
    private List<String> substituteClasses;
    private boolean allowSelfReferences = false;
    private final Set<SootMethod> failedMethods = new HashSet<SootMethod>();
    protected String dummyClassName = "dummyMainClass";
    protected String dummyMethodName = "dummyMainMethod";

    public Set<SootClass> getFailedClasses() {
        return new HashSet<SootClass>(this.failedClasses);
    }

    public Set<SootMethod> getFailedMethods() {
        return new HashSet<SootMethod>(this.failedMethods);
    }

    @Override
    public void setSubstituteCallParams(boolean b) {
        this.substituteCallParams = b;
    }

    @Override
    public void setSubstituteClasses(List<String> l) {
        this.substituteClasses = l;
    }

    @Override
    public SootMethod createDummyMain() {
        if (this.substituteCallParams) {
            for (String className : this.substituteClasses) {
                Scene.v().forceResolve(className, 3).setApplicationClass();
            }
        }
        return this.createDummyMainInternal();
    }

    @Override
    public SootMethod createDummyMain(SootMethod dummyMainMethod) {
        if (this.substituteCallParams) {
            for (String className : this.substituteClasses) {
                Scene.v().forceResolve(className, 3).setApplicationClass();
            }
        }
        return this.createDummyMainInternal(dummyMainMethod);
    }

    protected SootMethod createDummyMainInternal() {
        SootMethod emptySootMethod = this.createEmptyMainMethod(Jimple.v().newBody());
        return this.createDummyMainInternal(emptySootMethod);
    }

    protected abstract SootMethod createDummyMainInternal(SootMethod var1);

    protected SootMethod createEmptyMainMethod(Body body) {
        SootClass mainClass;
        String methodName = this.dummyMethodName;
        if (Scene.v().containsClass(this.dummyClassName)) {
            int methodIndex = 0;
            mainClass = Scene.v().getSootClass(this.dummyClassName);
            while (mainClass.declaresMethodByName(methodName)) {
                methodName = this.dummyMethodName + "_" + methodIndex++;
            }
        } else {
            mainClass = new SootClass(this.dummyClassName);
            Scene.v().addClass(mainClass);
        }
        ArrayType stringArrayType = ArrayType.v(RefType.v("java.lang.String"), 1);
        SootMethod mainMethod = new SootMethod(methodName, Collections.singletonList(stringArrayType), VoidType.v());
        body.setMethod(mainMethod);
        mainMethod.setActiveBody(body);
        mainClass.addMethod(mainMethod);
        LocalGenerator lg = new LocalGenerator(body);
        Local paramLocal = lg.generateLocal(stringArrayType);
        body.getUnits().addFirst(Jimple.v().newIdentityStmt(paramLocal, Jimple.v().newParameterRef(stringArrayType, 0)));
        mainClass.setApplicationClass();
        mainMethod.setModifiers(9);
        return mainMethod;
    }

    protected Stmt buildMethodCall(SootMethod methodToCall, Body body, Local classLocal, LocalGenerator gen) {
        return this.buildMethodCall(methodToCall, body, classLocal, gen, Collections.emptySet());
    }

    protected Stmt buildMethodCall(SootMethod methodToCall, Body body, Local classLocal, LocalGenerator gen, Set<SootClass> parentClasses) {
        Stmt stmt;
        InvokeExpr invokeExpr;
        assert (methodToCall != null) : "Current method was null";
        assert (body != null) : "Body was null";
        assert (gen != null) : "Local generator was null";
        if (classLocal == null && !methodToCall.isStatic()) {
            this.logger.warn("Cannot call method {}, because there is no local for base object: {}", (Object)methodToCall, (Object)methodToCall.getDeclaringClass());
            this.failedMethods.add(methodToCall);
            return null;
        }
        LinkedList<Value> args = new LinkedList<Value>();
        if (methodToCall.getParameterCount() > 0) {
            for (Type tp : methodToCall.getParameterTypes()) {
                HashSet<SootClass> hashSet = new HashSet<SootClass>();
                if (!this.allowSelfReferences) {
                    hashSet.add(methodToCall.getDeclaringClass());
                }
                args.add(this.getValueForType(body, gen, tp, hashSet, parentClasses));
            }
            if (methodToCall.isStatic()) {
                invokeExpr = Jimple.v().newStaticInvokeExpr(methodToCall.makeRef(), args);
            } else {
                assert (classLocal != null) : "Class local method was null for non-static method call";
                invokeExpr = methodToCall.isConstructor() ? Jimple.v().newSpecialInvokeExpr(classLocal, methodToCall.makeRef(), args) : Jimple.v().newVirtualInvokeExpr(classLocal, methodToCall.makeRef(), args);
            }
        } else if (methodToCall.isStatic()) {
            invokeExpr = Jimple.v().newStaticInvokeExpr(methodToCall.makeRef());
        } else {
            assert (classLocal != null) : "Class local method was null for non-static method call";
            invokeExpr = methodToCall.isConstructor() ? Jimple.v().newSpecialInvokeExpr(classLocal, methodToCall.makeRef()) : Jimple.v().newVirtualInvokeExpr(classLocal, methodToCall.makeRef());
        }
        if (!(methodToCall.getReturnType() instanceof VoidType)) {
            Local returnLocal = gen.generateLocal(methodToCall.getReturnType());
            stmt = Jimple.v().newAssignStmt(returnLocal, invokeExpr);
        } else {
            stmt = Jimple.v().newInvokeStmt(invokeExpr);
        }
        body.getUnits().add(stmt);
        for (Object e : args) {
            if (!(e instanceof Local) || !(((Value)e).getType() instanceof RefType)) continue;
            body.getUnits().add(Jimple.v().newAssignStmt((Value)e, NullConstant.v()));
        }
        return stmt;
    }

    private Value getValueForType(Body body, LocalGenerator gen, Type tp, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        if (BaseEntryPointCreator.isSimpleType(tp.toString())) {
            return this.getSimpleDefaultValue(tp.toString());
        }
        if (tp instanceof RefType) {
            SootClass classToType = ((RefType)tp).getSootClass();
            if (classToType != null) {
                for (SootClass parent : parentClasses) {
                    Value val;
                    if (!this.isCompatible(parent, classToType) || (val = (Value)this.localVarsForClasses.get(parent.getName())) == null) continue;
                    return val;
                }
                Local val = this.generateClassConstructor(classToType, body, constructionStack, parentClasses);
                if (val == null) {
                    return NullConstant.v();
                }
                return val;
            }
        } else {
            if (tp instanceof ArrayType) {
                Value arrVal = this.buildArrayOfType(body, gen, (ArrayType)tp, constructionStack, parentClasses);
                if (arrVal == null) {
                    this.logger.warn("Array parameter substituted by null");
                    return NullConstant.v();
                }
                return arrVal;
            }
            this.logger.warn("Unsupported parameter type: {}", (Object)tp.toString());
            return null;
        }
        throw new RuntimeException("Should never see me");
    }

    private Value buildArrayOfType(Body body, LocalGenerator gen, ArrayType tp, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        Local local = gen.generateLocal(tp);
        NewArrayExpr newArrayExpr = Jimple.v().newNewArrayExpr(tp.getElementType(), IntConstant.v(1));
        AssignStmt assignArray = Jimple.v().newAssignStmt(local, newArrayExpr);
        body.getUnits().add(assignArray);
        AssignStmt assign = Jimple.v().newAssignStmt(Jimple.v().newArrayRef(local, IntConstant.v(0)), this.getValueForType(body, gen, tp.getElementType(), constructionStack, parentClasses));
        body.getUnits().add(assign);
        return local;
    }

    protected Local generateClassConstructor(SootClass createdClass, Body body) {
        return this.generateClassConstructor(createdClass, body, new HashSet<SootClass>(), Collections.emptySet());
    }

    protected Local generateClassConstructor(SootClass createdClass, Body body, Set<SootClass> parentClasses) {
        return this.generateClassConstructor(createdClass, body, new HashSet<SootClass>(), parentClasses);
    }

    private Local generateClassConstructor(SootClass createdClass, Body body, Set<SootClass> constructionStack, Set<SootClass> parentClasses) {
        String outerClass;
        if (createdClass == null || this.failedClasses.contains(createdClass)) {
            return null;
        }
        if (createdClass.isPhantom() || createdClass.isPhantomClass()) {
            this.logger.warn("Cannot generate constructor for phantom class {}", (Object)createdClass.getName());
            this.failedClasses.add(createdClass);
            return null;
        }
        LocalGenerator generator = new LocalGenerator(body);
        if (BaseEntryPointCreator.isSimpleType(createdClass.toString())) {
            Local varLocal = generator.generateLocal(this.getSimpleTypeFromType(createdClass.getType()));
            AssignStmt aStmt = Jimple.v().newAssignStmt(varLocal, this.getSimpleDefaultValue(createdClass.toString()));
            body.getUnits().add(aStmt);
            return varLocal;
        }
        boolean isInnerClass = createdClass.getName().contains("$");
        String string = outerClass = isInnerClass ? createdClass.getName().substring(0, createdClass.getName().lastIndexOf("$")) : "";
        if (!constructionStack.add(createdClass)) {
            this.logger.warn("Ran into a constructor generation loop for class " + createdClass + ", substituting with null...");
            Local tempLocal = generator.generateLocal(RefType.v(createdClass));
            AssignStmt assignStmt = Jimple.v().newAssignStmt(tempLocal, NullConstant.v());
            body.getUnits().add(assignStmt);
            return tempLocal;
        }
        if (createdClass.isInterface() || createdClass.isAbstract()) {
            if (this.substituteCallParams) {
                List<SootClass> classes = createdClass.isInterface() ? Scene.v().getActiveHierarchy().getImplementersOf(createdClass) : Scene.v().getActiveHierarchy().getSubclassesOf(createdClass);
                for (SootClass sClass : classes) {
                    Local cons;
                    if (!this.substituteClasses.contains(sClass.toString()) || (cons = this.generateClassConstructor(sClass, body, constructionStack, parentClasses)) == null) continue;
                    return cons;
                }
                this.logger.warn("Cannot create valid constructor for {}, because it is {} and cannot substitute with subclass", (Object)createdClass, (Object)(createdClass.isInterface() ? "an interface" : (createdClass.isAbstract() ? "abstract" : "")));
                this.failedClasses.add(createdClass);
                return null;
            }
            this.logger.warn("Cannot create valid constructor for {}, because it is {} and cannot substitute with subclass", (Object)createdClass, (Object)(createdClass.isInterface() ? "an interface" : (createdClass.isAbstract() ? "abstract" : "")));
            this.failedClasses.add(createdClass);
            return null;
        }
        for (SootMethod currentMethod : createdClass.getMethods()) {
            if (currentMethod.isPrivate() || !currentMethod.isConstructor()) continue;
            LinkedList<Value> params = new LinkedList<Value>();
            for (Type type : currentMethod.getParameterTypes()) {
                String typeName = type.toString().replaceAll("\\[\\]]", "");
                if (type instanceof RefType && isInnerClass && typeName.equals(outerClass) && this.localVarsForClasses.containsKey(typeName)) {
                    params.add(this.localVarsForClasses.get(typeName));
                    continue;
                }
                params.add(this.getValueForType(body, generator, type, constructionStack, parentClasses));
            }
            NewExpr newExpr = Jimple.v().newNewExpr(RefType.v(createdClass));
            Local tempLocal = generator.generateLocal(RefType.v(createdClass));
            AssignStmt assignStmt = Jimple.v().newAssignStmt(tempLocal, newExpr);
            body.getUnits().add(assignStmt);
            SpecialInvokeExpr vInvokeExpr = params.isEmpty() || params.contains(null) ? Jimple.v().newSpecialInvokeExpr(tempLocal, currentMethod.makeRef()) : Jimple.v().newSpecialInvokeExpr(tempLocal, currentMethod.makeRef(), params);
            if (!(currentMethod.getReturnType() instanceof VoidType)) {
                Local possibleReturn = generator.generateLocal(currentMethod.getReturnType());
                AssignStmt assignStmt2 = Jimple.v().newAssignStmt(possibleReturn, vInvokeExpr);
                body.getUnits().add(assignStmt2);
            } else {
                body.getUnits().add(Jimple.v().newInvokeStmt(vInvokeExpr));
            }
            return tempLocal;
        }
        this.logger.warn("Could not find a suitable constructor for class {}", (Object)createdClass.getName());
        this.failedClasses.add(createdClass);
        return null;
    }

    private Type getSimpleTypeFromType(Type type) {
        if (type.toString().equals("java.lang.String")) {
            assert (type instanceof RefType);
            return RefType.v(((RefType)type).getSootClass());
        }
        if (type.toString().equals("void")) {
            return VoidType.v();
        }
        if (type.toString().equals("char")) {
            return CharType.v();
        }
        if (type.toString().equals("byte")) {
            return ByteType.v();
        }
        if (type.toString().equals("short")) {
            return ShortType.v();
        }
        if (type.toString().equals("int")) {
            return IntType.v();
        }
        if (type.toString().equals("float")) {
            return FloatType.v();
        }
        if (type.toString().equals("long")) {
            return LongType.v();
        }
        if (type.toString().equals("double")) {
            return DoubleType.v();
        }
        if (type.toString().equals("boolean")) {
            return BooleanType.v();
        }
        throw new RuntimeException("Unknown simple type: " + type);
    }

    protected static boolean isSimpleType(String t) {
        return t.equals("java.lang.String") || t.equals("void") || t.equals("char") || t.equals("byte") || t.equals("short") || t.equals("int") || t.equals("float") || t.equals("long") || t.equals("double") || t.equals("boolean");
    }

    protected Value getSimpleDefaultValue(String t) {
        if (t.equals("java.lang.String")) {
            return StringConstant.v("");
        }
        if (t.equals("char")) {
            return DIntConstant.v(0, CharType.v());
        }
        if (t.equals("byte")) {
            return DIntConstant.v(0, ByteType.v());
        }
        if (t.equals("short")) {
            return DIntConstant.v(0, ShortType.v());
        }
        if (t.equals("int")) {
            return IntConstant.v(0);
        }
        if (t.equals("float")) {
            return FloatConstant.v(0.0f);
        }
        if (t.equals("long")) {
            return LongConstant.v(0L);
        }
        if (t.equals("double")) {
            return DoubleConstant.v(0.0);
        }
        if (t.equals("boolean")) {
            return DIntConstant.v(0, BooleanType.v());
        }
        return G.v().soot_jimple_NullConstant();
    }

    protected SootMethod findMethod(SootClass currentClass, String subsignature) {
        if (currentClass.declaresMethod(subsignature)) {
            return currentClass.getMethod(subsignature);
        }
        if (currentClass.hasSuperclass()) {
            return this.findMethod(currentClass.getSuperclass(), subsignature);
        }
        return null;
    }

    protected boolean isCompatible(SootClass actual, SootClass expected) {
        SootClass act = actual;
        while (!act.getName().equals(expected.getName())) {
            if (expected.isInterface()) {
                for (SootClass intf : act.getInterfaces()) {
                    if (!intf.getName().equals(expected.getName())) continue;
                    return true;
                }
            }
            if (!act.hasSuperclass()) {
                return false;
            }
            act = act.getSuperclass();
        }
        return true;
    }

    protected void eliminateSelfLoops(Body body) {
        Iterator<Unit> unitIt = body.getUnits().iterator();
        while (unitIt.hasNext()) {
            IfStmt ifStmt;
            Unit u = unitIt.next();
            if (!(u instanceof IfStmt) || (ifStmt = (IfStmt)u).getTarget() != ifStmt) continue;
            unitIt.remove();
        }
    }

    public void setDummyClassName(String dummyClassName) {
        this.dummyClassName = dummyClassName;
    }

    public void setDummyMethodName(String dummyMethodName) {
        this.dummyMethodName = dummyMethodName;
    }

    public void setAllowSelfReferences(boolean value) {
        this.allowSelfReferences = value;
    }
}

