/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.nativ;

import java.util.Collections;
import java.util.Set;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.nativ.AbstractNativeCallHandler;

public class DefaultNativeCallHandler
extends AbstractNativeCallHandler {
    private static final String SIG_ARRAYCOPY = "<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>";
    private static final String SIG_NEW_ARRAY = "<java.lang.reflect.Array: java.lang.Object newArray(java.lang.Class,int)>";

    @Override
    public Set<Abstraction> getTaintedValues(Stmt call, Abstraction source, Value[] params) {
        if (source.isAbstractionActive()) {
            if (call.getInvokeExpr().getMethod().getSignature().equals(SIG_ARRAYCOPY)) {
                if (params[0].equals(source.getAccessPath().getPlainValue()) && this.manager.getTypeUtils().checkCast(source.getAccessPath(), params[2].getType())) {
                    Abstraction abs = source.deriveNewAbstraction(params[2], false, call, source.getAccessPath().getBaseType());
                    abs.setCorrespondingCallSite(call);
                    return Collections.singleton(abs);
                }
            } else if (call.getInvokeExpr().getMethod().getSignature().equals(SIG_NEW_ARRAY) && params[1].equals(source.getAccessPath().getPlainValue()) && this.manager.getTypeUtils().checkCast(source.getAccessPath(), params[1].getType())) {
                Abstraction abs = source.deriveNewAbstraction(params[1], false, call, source.getAccessPath().getBaseType(), AccessPath.ArrayTaintType.Length);
                abs.setCorrespondingCallSite(call);
                return Collections.singleton(abs);
            }
        }
        return null;
    }

    @Override
    public boolean supportsCall(Stmt call) {
        return call.containsInvokeExpr() && call.getInvokeExpr().getMethod().getSignature().equals(SIG_ARRAYCOPY);
    }
}

