/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.UnopExpr;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.collect.MutableTwoElementSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.TypeUtils;

public class BackwardsInfoflowProblem
extends AbstractInfoflowProblem {
    private IInfoflowSolver fSolver;

    @Override
    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public BackwardsInfoflowProblem(InfoflowManager manager) {
        super(manager);
    }

    public void setForwardSolver(IInfoflowSolver forwardSolver) {
        this.fSolver = forwardSolver;
    }

    @Override
    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private Abstraction checkAbstraction(Abstraction abs) {
                if (abs == null) {
                    return null;
                }
                if (!abs.getAccessPath().isStaticFieldRef()) {
                    if (abs.getAccessPath().getBaseType() instanceof PrimType) {
                        return null;
                    }
                    if (TypeUtils.isStringType(abs.getAccessPath().getBaseType()) && !abs.getAccessPath().getCanHaveImmutableAliases()) {
                        return null;
                    }
                } else {
                    if (abs.getAccessPath().getFirstFieldType() instanceof PrimType) {
                        return null;
                    }
                    if (TypeUtils.isStringType(abs.getAccessPath().getFirstFieldType()) && !abs.getAccessPath().getCanHaveImmutableAliases()) {
                        return null;
                    }
                }
                return abs;
            }

            /*
             * WARNING - void declaration
             */
            private Set<Abstraction> computeAliases(DefinitionStmt defStmt, Value leftValue, Abstraction d1, Abstraction source) {
                boolean bl;
                assert (!source.getAccessPath().isEmpty());
                if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                    return Collections.emptySet();
                }
                MutableTwoElementSet<Abstraction> res = new MutableTwoElementSet<Abstraction>();
                boolean leftSideMatches = Aliasing.baseMatches(leftValue, source);
                if (!leftSideMatches) {
                    res.add(source);
                } else {
                    for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                        BackwardsInfoflowProblem.this.fSolver.processEdge(new PathEdge<Unit, Abstraction>(d1, unit, source));
                    }
                }
                if (defStmt instanceof IdentityStmt) {
                    res.add(source);
                    return res;
                }
                if (!(defStmt instanceof AssignStmt)) {
                    return res;
                }
                Value rightValue = BaseSelector.selectBase(defStmt.getRightOp(), false);
                if (leftSideMatches && !(rightValue instanceof Local) && !(rightValue instanceof FieldRef)) {
                    return Collections.emptySet();
                }
                if (rightValue instanceof Constant) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof NewArrayExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof BinopExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof UnopExpr) {
                    return res;
                }
                boolean bl2 = bl = Aliasing.baseMatchesStrict(rightValue, source) && rightValue.getType() instanceof RefType && !source.dependsOnCutAP();
                if (!bl && !(rightValue.getType() instanceof PrimType)) {
                    FieldRef ref;
                    Abstraction newLeftAbs = null;
                    if (rightValue instanceof InstanceFieldRef) {
                        ref = (InstanceFieldRef)rightValue;
                        if (source.getAccessPath().isInstanceFieldRef() && ref.getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(ref.getField())) {
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(leftValue, true, defStmt, source.getAccessPath().getFirstFieldType()));
                        }
                    } else if (BackwardsInfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && rightValue instanceof StaticFieldRef) {
                        ref = (StaticFieldRef)rightValue;
                        if (source.getAccessPath().isStaticFieldRef() && source.getAccessPath().firstFieldMatches(((StaticFieldRef)ref).getField())) {
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(leftValue, true, defStmt, source.getAccessPath().getBaseType()));
                        }
                    } else if (rightValue == source.getAccessPath().getPlainValue()) {
                        Object newType = source.getAccessPath().getBaseType();
                        if (leftValue instanceof ArrayRef) {
                            newType = TypeUtils.buildArrayOrAddDimension((Type)newType);
                        } else if (defStmt.getRightOp() instanceof ArrayRef) {
                            newType = ((ArrayType)newType).getElementType();
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), defStmt.getRightOp().getType())) {
                            return Collections.emptySet();
                        }
                        if (defStmt.getRightOp() instanceof CastExpr) {
                            CastExpr castExpr = (CastExpr)defStmt.getRightOp();
                            if (!BackwardsInfoflowProblem.this.manager.getHierarchy().canStoreType((Type)newType, castExpr.getCastType())) {
                                newType = castExpr.getCastType();
                            }
                        } else {
                            if (defStmt.getRightOp() instanceof LengthExpr) {
                                return res;
                            }
                            if (defStmt.getRightOp() instanceof InstanceOfExpr) {
                                return res;
                            }
                        }
                        if (newLeftAbs == null) {
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(leftValue, (Type)newType, false), defStmt));
                        }
                    }
                    if (newLeftAbs != null) {
                        if (newLeftAbs.getAccessPath().getLastFieldType() instanceof PrimType) {
                            return res;
                        }
                        if (!newLeftAbs.getAccessPath().equals(source.getAccessPath())) {
                            res.add(newLeftAbs);
                            for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                BackwardsInfoflowProblem.this.fSolver.processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newLeftAbs));
                            }
                        }
                    }
                }
                if ((rightValue instanceof Local || rightValue instanceof FieldRef) && !(leftValue.getType() instanceof PrimType)) {
                    boolean addRightValue = false;
                    boolean cutFirstField = false;
                    Object var11_17 = null;
                    if (leftValue instanceof InstanceFieldRef) {
                        InstanceFieldRef leftRef;
                        if (source.getAccessPath().isInstanceFieldRef() && (leftRef = (InstanceFieldRef)leftValue).getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(leftRef.getField())) {
                            Type type = source.getAccessPath().getFirstFieldType();
                            addRightValue = true;
                            cutFirstField = true;
                        }
                    } else if (leftValue instanceof Local && source.getAccessPath().isInstanceFieldRef()) {
                        Local base = source.getAccessPath().getPlainValue();
                        if (leftValue == base) {
                            Type type = source.getAccessPath().getBaseType();
                            addRightValue = true;
                        }
                    } else if (leftValue instanceof ArrayRef) {
                        ArrayRef ar = (ArrayRef)leftValue;
                        Local leftBase = (Local)ar.getBase();
                        if (leftBase == source.getAccessPath().getPlainValue()) {
                            addRightValue = true;
                            Type type = source.getAccessPath().getBaseType();
                        }
                    } else if (leftValue == source.getAccessPath().getPlainValue()) {
                        if (!BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), leftValue.getType())) {
                            return Collections.emptySet();
                        }
                        addRightValue = true;
                        Type type = source.getAccessPath().getBaseType();
                    }
                    if (addRightValue) {
                        Abstraction newAbs;
                        void var11_32;
                        void var11_25;
                        if (var11_25 != null) {
                            if (defStmt.getRightOp() instanceof ArrayRef) {
                                Type type = TypeUtils.buildArrayOrAddDimension((Type)var11_25);
                            } else if (leftValue instanceof ArrayRef) {
                                void var11_29;
                                assert (source.getAccessPath().getBaseType() instanceof ArrayType);
                                Type type = ((ArrayType)var11_25).getElementType();
                                if (TypeUtils.isObjectLikeType(type)) {
                                    Type type2 = rightValue.getType();
                                }
                                if (!BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), (Type)var11_29)) {
                                    addRightValue = false;
                                }
                            }
                        }
                        if (defStmt.getRightOp() instanceof LengthExpr) {
                            Object var11_31 = null;
                        }
                        if ((var11_32 instanceof PrimType || var11_32 instanceof ArrayType && ((ArrayType)var11_32).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return Collections.emptySet();
                        }
                        if ((rightValue.getType() instanceof PrimType || rightValue.getType() instanceof ArrayType && ((ArrayType)rightValue.getType()).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return Collections.emptySet();
                        }
                        if (addRightValue && !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), (Type)var11_32)) {
                            addRightValue = false;
                        }
                        if (addRightValue && !BackwardsInfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && rightValue instanceof StaticFieldRef) {
                            addRightValue = false;
                        }
                        if (addRightValue && (newAbs = this.checkAbstraction(source.deriveNewAbstraction(rightValue, cutFirstField, defStmt, (Type)var11_32))) != null && !newAbs.getAccessPath().equals(source.getAccessPath())) {
                            res.add(newAbs);
                            for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                BackwardsInfoflowProblem.this.fSolver.processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newAbs));
                            }
                        }
                    }
                }
                return res;
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit src, Unit dest) {
                if (src instanceof DefinitionStmt) {
                    final DefinitionStmt defStmt = (DefinitionStmt)src;
                    final Value leftValue = BaseSelector.selectBase(defStmt.getLeftOp(), true);
                    final DefinitionStmt destDefStmt = dest instanceof DefinitionStmt ? (DefinitionStmt)dest : null;
                    final Value destLeftValue = destDefStmt == null ? null : BaseSelector.selectBase(destDefStmt.getLeftOp(), true);
                    return new SolverNormalFlowFunction(){

                        @Override
                        public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                            if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                                return Collections.emptySet();
                            }
                            assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                            if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                                BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(src, source, BackwardsInfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                            }
                            Set res = this.computeAliases(defStmt, leftValue, d1, source);
                            if (destDefStmt != null && BackwardsInfoflowProblem.this.interproceduralCFG().isExitStmt(destDefStmt)) {
                                for (Abstraction abs : res) {
                                    this.computeAliases(destDefStmt, destLeftValue, d1, abs);
                                }
                            }
                            return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                    };
                }
                return Identity.v();
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                if (!dest.isConcrete()) {
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Value[] paramLocals = new Value[dest.getParameterCount()];
                for (int i = 0; i < dest.getParameterCount(); ++i) {
                    paramLocals[i] = dest.getActiveBody().getParameterLocal(i);
                }
                final boolean isSource = BackwardsInfoflowProblem.this.manager.getSourceSinkManager() != null ? BackwardsInfoflowProblem.this.manager.getSourceSinkManager().getSourceInfo((Stmt)src, BackwardsInfoflowProblem.this.interproceduralCFG()) != null : false;
                final boolean isSink = BackwardsInfoflowProblem.this.manager.getSourceSinkManager() != null ? BackwardsInfoflowProblem.this.manager.getSourceSinkManager().isSink(stmt, BackwardsInfoflowProblem.this.interproceduralCFG(), null) : false;
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = BackwardsInfoflowProblem.this.interproceduralCFG().isExecutorExecute(ie, dest);
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        InstanceInvokeExpr iIExpr;
                        Abstraction abs;
                        DefinitionStmt defnStmt;
                        Value leftOp;
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, BackwardsInfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getConfig().getInspectSources() && isSource) {
                            return Collections.emptySet();
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getConfig().getInspectSinks() && isSink) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.isCallSiteActivatingTaint(stmt, source.getActivationUnit())) {
                            return Collections.emptySet();
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && dest.isStaticInitializer()) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.taintWrapper != null && BackwardsInfoflowProblem.this.taintWrapper.isExclusive(stmt, source)) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && source.getAccessPath().isStaticFieldRef() && !BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return Collections.emptySet();
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (src instanceof DefinitionStmt && (leftOp = (defnStmt = (DefinitionStmt)src).getLeftOp()) == source.getAccessPath().getPlainValue()) {
                            for (Unit u : dest.getActiveBody().getUnits()) {
                                Abstraction abs2;
                                ReturnStmt rStmt;
                                if (!(u instanceof ReturnStmt) || !((rStmt = (ReturnStmt)u).getOp() instanceof Local) && !(rStmt.getOp() instanceof FieldRef) || !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), rStmt.getOp().getType()) || (abs2 = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(rStmt.getOp(), null, false), (Stmt)src))) == null) continue;
                                res.add(abs2);
                            }
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && source.getAccessPath().isStaticFieldRef() && (abs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath(), stmt))) != null) {
                            res.add(abs);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        if (!isExecutorExecute && !source.getAccessPath().isStaticFieldRef() && !dest.isStatic() && (iIExpr = (InstanceInvokeExpr)stmt.getInvokeExpr()).getBase() == sourceBase && BackwardsInfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass())) {
                            Abstraction abs3;
                            boolean param = false;
                            for (int i = 0; i < dest.getParameterCount(); ++i) {
                                if (stmt.getInvokeExpr().getArg(i) != sourceBase) continue;
                                param = true;
                                break;
                            }
                            if (!param && (abs3 = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(thisLocal), (Stmt)src))) != null) {
                                res.add(abs3);
                            }
                        }
                        if (isExecutorExecute) {
                            Abstraction abs4;
                            if (ie.getArg(0) == source.getAccessPath().getPlainValue() && (abs4 = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(thisLocal), stmt))) != null) {
                                res.add(abs4);
                            }
                        } else if (ie != null && dest.getParameterCount() > 0) {
                            assert (dest.getParameterCount() == ie.getArgCount());
                            for (int i = 0; i < ie.getArgCount(); ++i) {
                                Abstraction abs5;
                                if (ie.getArg(i) != source.getAccessPath().getPlainValue() || (abs5 = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(paramLocals[i]), stmt))) == null) continue;
                                res.add(abs5);
                            }
                        }
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, Unit retSite) {
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                final Stmt stmt = (Stmt)callSite;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = BackwardsInfoflowProblem.this.interproceduralCFG().isExecutorExecute(ie, callee);
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (callSite == null) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, BackwardsInfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && source.getAccessPath().isStaticFieldRef()) {
                            BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, source);
                            return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (isExecutorExecute) {
                            Abstraction abs;
                            if (source.getAccessPath().getPlainValue() == thisLocal && (abs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(ie.getArg(0)), (Stmt)exitStmt))) != null) {
                                res.add(abs);
                                BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                        } else {
                            Stmt stmt2;
                            boolean parameterAliases = false;
                            Value originalCallArg = null;
                            for (int i = 0; i < paramLocals.length; ++i) {
                                Abstraction abs;
                                if (paramLocals[i] != sourceBase) continue;
                                parameterAliases = true;
                                if (!(callSite instanceof Stmt) || !AccessPath.canContainValue(originalCallArg = ie.getArg(i)) || !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || TypeUtils.isStringType(source.getAccessPath().getBaseType()) && !source.getAccessPath().getCanHaveImmutableAliases() || BackwardsInfoflowProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i]) || (abs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(originalCallArg), (Stmt)exitStmt))) == null) continue;
                                res.add(abs);
                                BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                            if (!callee.isStatic() && thisLocal == sourceBase && BackwardsInfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass()) && !parameterAliases && callSite instanceof Stmt && (stmt2 = (Stmt)callSite).getInvokeExpr() instanceof InstanceInvokeExpr) {
                                InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)stmt2.getInvokeExpr();
                                Abstraction abs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(iIExpr.getBase()), (Stmt)exitStmt));
                                if (abs != null) {
                                    res.add(abs);
                                    BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                                }
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == source) continue;
                            abs.setCorrespondingCallSite((Stmt)callSite);
                        }
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit call, Unit returnSite) {
                final Stmt iStmt = (Stmt)call;
                InvokeExpr invExpr = iStmt.getInvokeExpr();
                final Value[] callArgs = new Value[iStmt.getInvokeExpr().getArgCount()];
                for (int i = 0; i < iStmt.getInvokeExpr().getArgCount(); ++i) {
                    callArgs[i] = iStmt.getInvokeExpr().getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                final DefinitionStmt defStmt = iStmt instanceof DefinitionStmt ? (DefinitionStmt)iStmt : null;
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        InstanceInvokeExpr iinv;
                        Set<Abstraction> wrapperAliases;
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(call, source, BackwardsInfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (BackwardsInfoflowProblem.this.taintWrapper != null && (wrapperAliases = BackwardsInfoflowProblem.this.taintWrapper.getAliasesForMethod(iStmt, d1, source)) != null && !wrapperAliases.isEmpty()) {
                            HashSet<Abstraction> passOnSet = new HashSet<Abstraction>(wrapperAliases.size());
                            for (Abstraction abs : wrapperAliases) {
                                if (defStmt != null && defStmt.getLeftOp() == abs.getAccessPath().getPlainValue()) {
                                    for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                        BackwardsInfoflowProblem.this.fSolver.processEdge(new PathEdge<Unit, Abstraction>(d1, unit, abs));
                                    }
                                    continue;
                                }
                                passOnSet.add(abs);
                            }
                            return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(call, d1, source, passOnSet, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && source.getAccessPath().isStaticFieldRef() && BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return Collections.emptySet();
                        }
                        if (iStmt instanceof DefinitionStmt && ((DefinitionStmt)iStmt).getLeftOp() == source.getAccessPath().getPlainValue()) {
                            return Collections.emptySet();
                        }
                        if (iStmt.getInvokeExpr() instanceof InstanceInvokeExpr && (iinv = (InstanceInvokeExpr)iStmt.getInvokeExpr()).getBase() == source.getAccessPath().getPlainValue() && !BackwardsInfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call).isEmpty()) {
                            return Collections.emptySet();
                        }
                        for (int i = 0; i < callArgs.length; ++i) {
                            if (callArgs[i] != source.getAccessPath().getPlainValue()) continue;
                            return Collections.emptySet();
                        }
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(call, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }
                };
            }
        };
    }
}

