/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.KillAll;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.ArrayType;
import soot.BooleanType;
import soot.Local;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.PropagationRuleManager;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.TypeUtils;

public class InfoflowProblem
extends AbstractInfoflowProblem {
    private final Aliasing aliasing;
    private final IAliasingStrategy aliasingStrategy;
    private final PropagationRuleManager propagationRules;
    protected final TaintPropagationResults results;

    public InfoflowProblem(InfoflowManager manager, IAliasingStrategy aliasingStrategy, Abstraction zeroValue) {
        super(manager);
        if (zeroValue != null) {
            this.setZeroValue(zeroValue);
        }
        this.aliasingStrategy = aliasingStrategy;
        this.aliasing = new Aliasing(aliasingStrategy, manager.getICFG());
        this.results = new TaintPropagationResults(manager);
        this.propagationRules = new PropagationRuleManager(manager, this.aliasing, this.createZeroValue(), this.results);
    }

    @Override
    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private void addTaintViaStmt(Abstraction d1, AssignStmt assignStmt, Abstraction source, Set<Abstraction> taintSet, boolean cutFirstField, SootMethod method, Type targetType) {
                Value leftValue = assignStmt.getLeftOp();
                Value rightValue = assignStmt.getRightOp();
                if (!InfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && leftValue instanceof StaticFieldRef) {
                    return;
                }
                Abstraction newAbs = null;
                if (!source.getAccessPath().isEmpty()) {
                    if (leftValue instanceof ArrayRef && targetType != null) {
                        targetType = TypeUtils.buildArrayOrAddDimension(targetType);
                    }
                    if (rightValue instanceof CastExpr) {
                        CastExpr cast = (CastExpr)assignStmt.getRightOp();
                        targetType = cast.getType();
                    } else if (rightValue instanceof InstanceOfExpr) {
                        newAbs = source.deriveNewAbstraction(AccessPathFactory.v().createAccessPath(leftValue, BooleanType.v(), true, AccessPath.ArrayTaintType.ContentsAndLength), assignStmt);
                    }
                } else assert (targetType == null);
                AccessPath.ArrayTaintType arrayTaintType = source.getAccessPath().getArrayTaintType();
                if (leftValue instanceof ArrayRef && InfoflowProblem.this.manager.getConfig().getEnableArraySizeTainting()) {
                    arrayTaintType = AccessPath.ArrayTaintType.Contents;
                }
                if (newAbs == null) {
                    newAbs = source.getAccessPath().isEmpty() ? source.deriveNewAbstraction(AccessPathFactory.v().createAccessPath(leftValue, true), assignStmt, true) : source.deriveNewAbstraction(leftValue, cutFirstField, assignStmt, targetType, arrayTaintType);
                }
                if (newAbs != null) {
                    taintSet.add(newAbs);
                    if (Aliasing.canHaveAliases(assignStmt, leftValue, newAbs)) {
                        InfoflowProblem.this.aliasing.computeAliases(d1, assignStmt, leftValue, taintSet, method, newAbs);
                    }
                }
            }

            private boolean hasValidCallees(Unit call) {
                Collection callees = InfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call);
                for (SootMethod callee : callees) {
                    if (!callee.isConcrete()) continue;
                    return true;
                }
                return false;
            }

            private Set<Abstraction> createNewTaintOnAssignment(AssignStmt assignStmt, Value[] rightVals, Abstraction d1, Abstraction newSource) {
                boolean implicitTaint;
                Value leftValue = assignStmt.getLeftOp();
                Value rightValue = assignStmt.getRightOp();
                boolean addLeftValue = false;
                boolean bl = implicitTaint = newSource.getTopPostdominator() != null && newSource.getTopPostdominator().getUnit() != null;
                if (implicitTaint |= newSource.getAccessPath().isEmpty()) {
                    assert (InfoflowProblem.this.manager.getConfig().getEnableImplicitFlows());
                    if ((d1 == null || d1.getAccessPath().isEmpty()) && !(leftValue instanceof FieldRef)) {
                        return Collections.singleton(newSource);
                    }
                    if (newSource.getAccessPath().isEmpty()) {
                        addLeftValue = true;
                    }
                }
                boolean aliasOverwritten = !addLeftValue && !newSource.isAbstractionActive() && Aliasing.baseMatchesStrict(rightValue, newSource) && rightValue.getType() instanceof RefType && !newSource.dependsOnCutAP();
                boolean cutFirstField = false;
                AccessPath mappedAP = newSource.getAccessPath();
                Type targetType = null;
                if (!addLeftValue && !aliasOverwritten) {
                    for (Value rightVal : rightVals) {
                        if (rightVal instanceof FieldRef) {
                            FieldRef rightRef = (FieldRef)rightVal;
                            if (rightRef instanceof InstanceFieldRef && ((InstanceFieldRef)rightRef).getBase().getType() instanceof NullType) {
                                return null;
                            }
                            mappedAP = InfoflowProblem.this.aliasing.mayAlias(newSource.getAccessPath(), (Value)rightRef);
                            if (rightVal instanceof StaticFieldRef) {
                                if (InfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && mappedAP != null) {
                                    addLeftValue = true;
                                    cutFirstField = true;
                                }
                            } else if (rightVal instanceof InstanceFieldRef) {
                                Local rightBase = (Local)((InstanceFieldRef)rightRef).getBase();
                                Local sourceBase = newSource.getAccessPath().getPlainValue();
                                SootField rightField = rightRef.getField();
                                if (mappedAP != null) {
                                    addLeftValue = true;
                                    cutFirstField = mappedAP.getFieldCount() > 0 && mappedAP.getFirstField() == rightField;
                                } else if (InfoflowProblem.this.aliasing.mayAlias(rightBase, (Value)sourceBase) && newSource.getAccessPath().getFieldCount() == 0 && newSource.getAccessPath().getTaintSubFields()) {
                                    addLeftValue = true;
                                    targetType = rightField.getType();
                                }
                            }
                        } else if (rightVal instanceof Local && newSource.getAccessPath().isInstanceFieldRef()) {
                            Local base = newSource.getAccessPath().getPlainValue();
                            if (InfoflowProblem.this.aliasing.mayAlias(rightVal, (Value)base)) {
                                addLeftValue = true;
                                targetType = newSource.getAccessPath().getBaseType();
                            }
                        } else if (InfoflowProblem.this.aliasing.mayAlias(rightVal, (Value)newSource.getAccessPath().getPlainValue()) && !(assignStmt.getRightOp() instanceof NewArrayExpr) && (InfoflowProblem.this.manager.getConfig().getEnableArraySizeTainting() || !(rightValue instanceof NewArrayExpr))) {
                            addLeftValue = true;
                            targetType = newSource.getAccessPath().getBaseType();
                        }
                        if (addLeftValue) break;
                    }
                }
                if (!addLeftValue) {
                    return null;
                }
                if (!newSource.isAbstractionActive() && (assignStmt.getLeftOp().getType() instanceof PrimType || TypeUtils.isStringType(assignStmt.getLeftOp().getType()) && !newSource.getAccessPath().getCanHaveImmutableAliases())) {
                    return Collections.singleton(newSource);
                }
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                Abstraction targetAB = mappedAP.equals(newSource.getAccessPath()) ? newSource : newSource.deriveNewAbstraction(mappedAP, null);
                this.addTaintViaStmt(d1, assignStmt, targetAB, res, cutFirstField, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(assignStmt), targetType);
                res.add(newSource);
                return res;
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit src, final Unit dest) {
                if (!(src instanceof Stmt)) {
                    return KillAll.v();
                }
                return new NotifyingNormalFlowFunction((Stmt)src){

                    @Override
                    public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        Value right;
                        Value[] rightVals;
                        AssignStmt assignStmt;
                        Set resAssign;
                        Abstraction newSource = !source.isAbstractionActive() && src == source.getActivationUnit() ? source.getActiveCopy() : source;
                        ByReferenceBoolean killSource = new ByReferenceBoolean();
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set res = InfoflowProblem.this.propagationRules.applyNormalFlowFunction(d1, newSource, this.stmt, (Stmt)dest, killSource, killAll);
                        if (killAll.value) {
                            return Collections.emptySet();
                        }
                        if (src instanceof AssignStmt && (resAssign = this.createNewTaintOnAssignment(assignStmt = (AssignStmt)src, rightVals = BaseSelector.selectBaseList(right = assignStmt.getRightOp(), true), d1, newSource)) != null && !resAssign.isEmpty()) {
                            if (res != null) {
                                res.addAll(resAssign);
                                return res;
                            }
                            res = resAssign;
                        }
                        return res == null || res.isEmpty() ? Collections.emptySet() : res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                if (!dest.isConcrete()) {
                    InfoflowProblem.this.logger.debug("Call skipped because target has no body: {} -> {}", (Object)src, (Object)dest);
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Local[] paramLocals = dest.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        if (!res.isEmpty()) {
                            for (Abstraction abs : res) {
                                InfoflowProblem.this.aliasingStrategy.injectCallingContext(abs, InfoflowProblem.this.solver, dest, src, source, d1);
                            }
                        }
                        return InfoflowProblem.this.notifyOutFlowHandlers(stmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        if (InfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !InfoflowProblem.this.results.isEmpty()) {
                            return Collections.emptySet();
                        }
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        if (!InfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && dest.isStaticInitializer()) {
                            return Collections.emptySet();
                        }
                        if (InfoflowProblem.this.taintPropagationHandler != null) {
                            InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set<Abstraction> res = InfoflowProblem.this.propagationRules.applyCallFlowFunction(d1, source, stmt, dest, killAll);
                        if (killAll.value) {
                            return Collections.emptySet();
                        }
                        if (source.getAccessPath().isStaticFieldRef() && !InfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking()) {
                            return Collections.emptySet();
                        }
                        Set resMapping = this.mapAccessPathToCallee(dest, ie, paramLocals, thisLocal, source.getAccessPath());
                        if (resMapping == null) {
                            return res == null || res.isEmpty() ? Collections.emptySet() : res;
                        }
                        HashSet<Abstraction> resAbs = new HashSet<Abstraction>(resMapping.size());
                        if (res != null && !res.isEmpty()) {
                            resAbs.addAll(res);
                        }
                        for (AccessPath ap : resMapping) {
                            Abstraction newAbs;
                            if (ap == null) continue;
                            if (ap.isStaticFieldRef()) {
                                if (!InfoflowProblem.this.interproceduralCFG().isStaticFieldRead(dest, ap.getFirstField()) || (newAbs = source.deriveNewAbstraction(ap, stmt)) == null) continue;
                                resAbs.add(newAbs);
                                continue;
                            }
                            if (!source.isImplicit() && !InfoflowProblem.this.interproceduralCFG().methodReadsValue(dest, ap.getPlainValue()) || (newAbs = source.deriveNewAbstraction(ap, stmt)) == null) continue;
                            resAbs.add(newAbs);
                        }
                        return resAbs;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, final Unit retSite) {
                if (callSite != null && !(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt iCallStmt = (Stmt)callSite;
                final ReturnStmt returnStmt = exitStmt instanceof ReturnStmt ? (ReturnStmt)exitStmt : null;
                final Local[] paramLocals = callee.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        Set<Abstraction> res = this.computeTargetsInternal(source, callerD1s);
                        return InfoflowProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction source, Collection<Abstraction> callerD1s) {
                        Abstraction abs;
                        if (InfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !InfoflowProblem.this.results.isEmpty()) {
                            return Collections.emptySet();
                        }
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        if (InfoflowProblem.this.taintPropagationHandler != null) {
                            InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(exitStmt, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        boolean callerD1sConditional = false;
                        for (Abstraction d1 : callerD1s) {
                            if (!d1.getAccessPath().isEmpty()) continue;
                            callerD1sConditional = true;
                            break;
                        }
                        Abstraction newSource = source;
                        if (!source.isAbstractionActive() && callSite != null && (callSite == source.getActivationUnit() || InfoflowProblem.this.isCallSiteActivatingTaint(callSite, source.getActivationUnit()))) {
                            newSource = source.getActiveCopy();
                        }
                        if (!newSource.isAbstractionActive() && newSource.getActivationUnit() != null && InfoflowProblem.this.interproceduralCFG().getMethodOf(newSource.getActivationUnit()) == callee) {
                            return Collections.emptySet();
                        }
                        if (!InfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && newSource.getAccessPath().isStaticFieldRef()) {
                            return Collections.emptySet();
                        }
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set<Abstraction> res = InfoflowProblem.this.propagationRules.applyReturnFlowFunction(callerD1s, newSource, (Stmt)exitStmt, (Stmt)retSite, (Stmt)callSite, killAll);
                        if (killAll.value) {
                            return Collections.emptySet();
                        }
                        if (res == null) {
                            res = new HashSet<Abstraction>();
                        }
                        if (callSite == null) {
                            return Collections.emptySet();
                        }
                        if (returnStmt != null && callSite instanceof DefinitionStmt) {
                            Abstraction abs2;
                            Value retLocal = returnStmt.getOp();
                            DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                            Value leftOp = defnStmt.getLeftOp();
                            if (InfoflowProblem.this.aliasing.mayAlias(retLocal, (Value)newSource.getAccessPath().getPlainValue()) && !InfoflowProblem.this.isExceptionHandler(retSite) && (abs2 = newSource.deriveNewAbstraction(newSource.getAccessPath().copyWithNewValue(leftOp), (Stmt)exitStmt)) != null) {
                                res.add(abs2);
                                if (InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) {
                                    for (Abstraction d1 : callerD1s) {
                                        InfoflowProblem.this.aliasing.computeAliases(d1, iCallStmt, leftOp, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs2);
                                    }
                                }
                            }
                        }
                        if (newSource.getAccessPath().isStaticFieldRef()) {
                            Abstraction abs3 = newSource;
                            res.add(abs3);
                            if (abs3.isImplicit() && !callerD1sConditional || InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) {
                                for (Abstraction d1 : callerD1s) {
                                    InfoflowProblem.this.aliasing.computeAliases(d1, iCallStmt, null, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs3);
                                }
                            }
                        }
                        Local sourceBase = newSource.getAccessPath().getPlainValue();
                        boolean parameterAliases = false;
                        Value originalCallArg = null;
                        for (int i = 0; i < callee.getParameterCount(); ++i) {
                            if (callSite instanceof DefinitionStmt && !InfoflowProblem.this.isExceptionHandler(retSite)) {
                                DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                                Value leftOp = defnStmt.getLeftOp();
                                originalCallArg = defnStmt.getInvokeExpr().getArg(i);
                                if (originalCallArg == leftOp) continue;
                            }
                            if (!InfoflowProblem.this.aliasing.mayAlias(paramLocals[i], (Value)sourceBase)) continue;
                            parameterAliases = true;
                            originalCallArg = iCallStmt.getInvokeExpr().getArg(i);
                            if (!AccessPath.canContainValue(originalCallArg) || !InfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || TypeUtils.isStringType(source.getAccessPath().getBaseType()) && !source.getAccessPath().getCanHaveImmutableAliases() || !source.getAccessPath().getTaintSubFields() || InfoflowProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i]) || (abs = newSource.deriveNewAbstraction(newSource.getAccessPath().copyWithNewValue(originalCallArg), (Stmt)exitStmt)) == null) continue;
                            res.add(abs);
                            if ((!abs.isImplicit() || callerD1sConditional) && !InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) continue;
                            assert (originalCallArg.getType() instanceof ArrayType || originalCallArg.getType() instanceof RefType);
                            for (Abstraction d1 : callerD1s) {
                                InfoflowProblem.this.aliasing.computeAliases(d1, iCallStmt, originalCallArg, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                            }
                        }
                        if (!callee.isStatic()) {
                            DefinitionStmt defnStmt;
                            Value leftOp;
                            boolean thisAliases = false;
                            if (callSite instanceof DefinitionStmt && !InfoflowProblem.this.isExceptionHandler(retSite) && thisLocal == (leftOp = (defnStmt = (DefinitionStmt)callSite).getLeftOp())) {
                                thisAliases = true;
                            }
                            if (!parameterAliases && !thisAliases && source.getAccessPath().getTaintSubFields() && iCallStmt.getInvokeExpr() instanceof InstanceInvokeExpr && InfoflowProblem.this.aliasing.mayAlias(thisLocal, (Value)sourceBase) && InfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), thisLocal.getType())) {
                                InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)iCallStmt.getInvokeExpr();
                                abs = newSource.deriveNewAbstraction(newSource.getAccessPath().copyWithNewValue(iIExpr.getBase()), (Stmt)exitStmt);
                                if (abs != null) {
                                    res.add(abs);
                                    if (abs.isImplicit() && Aliasing.canHaveAliases(iCallStmt, iIExpr.getBase(), abs) && !callerD1sConditional || InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) {
                                        for (Abstraction d1 : callerD1s) {
                                            InfoflowProblem.this.aliasing.computeAliases(d1, iCallStmt, iIExpr.getBase(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                                        }
                                    }
                                }
                            }
                        }
                        for (Abstraction abs4 : res) {
                            if (abs4 == newSource) continue;
                            abs4.setCorrespondingCallSite(iCallStmt);
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit call, Unit returnSite) {
                boolean isSink;
                if (!(call instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt iCallStmt = (Stmt)call;
                final InvokeExpr invExpr = iCallStmt.getInvokeExpr();
                final Value[] callArgs = new Value[invExpr.getArgCount()];
                for (int i = 0; i < invExpr.getArgCount(); ++i) {
                    callArgs[i] = invExpr.getArg(i);
                }
                boolean bl = isSink = InfoflowProblem.this.manager.getSourceSinkManager() != null ? InfoflowProblem.this.manager.getSourceSinkManager().isSink(iCallStmt, InfoflowProblem.this.interproceduralCFG(), null) : false;
                final boolean isSource = InfoflowProblem.this.manager.getSourceSinkManager() != null ? InfoflowProblem.this.manager.getSourceSinkManager().getSourceInfo(iCallStmt, InfoflowProblem.this.interproceduralCFG()) != null : false;
                final SootMethod callee = invExpr.getMethod();
                final boolean hasValidCallees = this.hasValidCallees(call);
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return InfoflowProblem.this.notifyOutFlowHandlers(call, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        boolean passOn;
                        if (InfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !InfoflowProblem.this.results.isEmpty()) {
                            return Collections.emptySet();
                        }
                        if (InfoflowProblem.this.taintPropagationHandler != null) {
                            InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(call, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (!InfoflowProblem.this.manager.getConfig().getEnableStaticFieldTracking() && source.getAccessPath().isStaticFieldRef()) {
                            return Collections.emptySet();
                        }
                        Abstraction newSource = !source.isAbstractionActive() && (call == source.getActivationUnit() || InfoflowProblem.this.isCallSiteActivatingTaint(call, source.getActivationUnit())) ? source.getActiveCopy() : source;
                        ByReferenceBoolean killSource = new ByReferenceBoolean();
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set<Abstraction> res = InfoflowProblem.this.propagationRules.applyCallToReturnFlowFunction(d1, newSource, iCallStmt, killSource, killAll, true);
                        if (killAll.value) {
                            return Collections.emptySet();
                        }
                        boolean bl = passOn = !killSource.value;
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            return res == null || res.isEmpty() ? Collections.emptySet() : res;
                        }
                        if (res == null) {
                            res = new HashSet<Abstraction>();
                        }
                        if (newSource.getTopPostdominator() != null && newSource.getTopPostdominator().getUnit() == null) {
                            return Collections.singleton(newSource);
                        }
                        if (passOn) {
                            if (newSource.getAccessPath().isStaticFieldRef()) {
                                passOn = false;
                            } else if (call instanceof DefinitionStmt && InfoflowProblem.this.aliasing.mayAlias(((DefinitionStmt)call).getLeftOp(), (Value)newSource.getAccessPath().getPlainValue())) {
                                passOn = false;
                            }
                        }
                        if (passOn && invExpr instanceof InstanceInvokeExpr && newSource.getAccessPath().isInstanceFieldRef() && (InfoflowProblem.this.manager.getConfig().getInspectSinks() || !isSink) && (InfoflowProblem.this.manager.getConfig().getInspectSources() || !isSource) && (hasValidCallees || InfoflowProblem.this.taintWrapper != null && InfoflowProblem.this.taintWrapper.isExclusive(iCallStmt, newSource))) {
                            boolean allCalleesRead = true;
                            block0: for (SootMethod callee2 : InfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call)) {
                                Set calleeAPs;
                                if (!callee2.isConcrete() || !callee2.hasActiveBody() || (calleeAPs = this.mapAccessPathToCallee(callee2, invExpr, null, null, source.getAccessPath())) == null) continue;
                                for (AccessPath ap : calleeAPs) {
                                    if (ap == null || InfoflowProblem.this.interproceduralCFG().methodReadsValue(callee2, ap.getPlainValue())) continue;
                                    allCalleesRead = false;
                                    break block0;
                                }
                            }
                            if (allCalleesRead) {
                                if (InfoflowProblem.this.aliasing.mayAlias(((InstanceInvokeExpr)invExpr).getBase(), (Value)newSource.getAccessPath().getPlainValue())) {
                                    passOn = false;
                                }
                                if (passOn) {
                                    for (int i = 0; i < callArgs.length; ++i) {
                                        if (!InfoflowProblem.this.aliasing.mayAlias(callArgs[i], (Value)newSource.getAccessPath().getPlainValue())) continue;
                                        passOn = false;
                                        break;
                                    }
                                }
                                if (newSource.getAccessPath().isStaticFieldRef()) {
                                    passOn = false;
                                }
                            }
                        }
                        if (source.getAccessPath().isStaticFieldRef() && !InfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            passOn = true;
                        }
                        if ((passOn |= source.getTopPostdominator() != null || source.getAccessPath().isEmpty()) && newSource != InfoflowProblem.this.getZeroValue()) {
                            res.add(newSource);
                        }
                        if (callee.isNative()) {
                            for (Value callVal : callArgs) {
                                if (callVal != newSource.getAccessPath().getPlainValue()) continue;
                                Set<Abstraction> nativeAbs = InfoflowProblem.this.ncHandler.getTaintedValues(iCallStmt, newSource, callArgs);
                                if (nativeAbs == null) break;
                                res.addAll(nativeAbs);
                                for (Abstraction abs : nativeAbs) {
                                    if (!abs.getAccessPath().isStaticFieldRef() && !Aliasing.canHaveAliases(iCallStmt, abs.getAccessPath().getPlainValue(), abs)) continue;
                                    InfoflowProblem.this.aliasing.computeAliases(d1, iCallStmt, abs.getAccessPath().getPlainValue(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(call), abs);
                                }
                                break;
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == newSource) continue;
                            abs.setCorrespondingCallSite(iCallStmt);
                        }
                        return res;
                    }
                };
            }

            private Set<AccessPath> mapAccessPathToCallee(SootMethod callee, InvokeExpr ie, Value[] paramLocals, Local thisLocal, AccessPath ap) {
                if (ap.isEmpty()) {
                    return Collections.emptySet();
                }
                boolean isExecutorExecute = InfoflowProblem.this.interproceduralCFG().isExecutorExecute(ie, callee);
                HashSet<AccessPath> res = null;
                if (!(isExecutorExecute || ap.isStaticFieldRef() || callee.isStatic())) {
                    assert (ie instanceof InstanceInvokeExpr);
                    InstanceInvokeExpr vie = (InstanceInvokeExpr)ie;
                    if (InfoflowProblem.this.aliasing.mayAlias(vie.getBase(), (Value)ap.getPlainValue()) && InfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(ap, callee.getDeclaringClass())) {
                        if (res == null) {
                            res = new HashSet();
                        }
                        if (thisLocal == null) {
                            thisLocal = callee.getActiveBody().getThisLocal();
                        }
                        res.add(ap.copyWithNewValue(thisLocal));
                    }
                } else if (ap.isStaticFieldRef()) {
                    if (res == null) {
                        res = new HashSet<AccessPath>();
                    }
                    res.add(ap);
                }
                if (isExecutorExecute) {
                    if (InfoflowProblem.this.aliasing.mayAlias(ie.getArg(0), (Value)ap.getPlainValue())) {
                        if (res == null) {
                            res = new HashSet();
                        }
                        res.add(ap.copyWithNewValue(callee.getActiveBody().getThisLocal()));
                    }
                } else if (callee.getParameterCount() > 0) {
                    assert (callee.getParameterCount() == ie.getArgCount());
                    for (int i = 0; i < ie.getArgCount(); ++i) {
                        AccessPath newAP;
                        if (!InfoflowProblem.this.aliasing.mayAlias(ie.getArg(i), (Value)ap.getPlainValue())) continue;
                        if (res == null) {
                            res = new HashSet();
                        }
                        if (paramLocals == null) {
                            paramLocals = callee.getActiveBody().getParameterLocals().toArray(new Local[callee.getParameterCount()]);
                        }
                        if ((newAP = ap.copyWithNewValue(paramLocals[i])) == null) continue;
                        res.add(newAP);
                    }
                }
                return res;
            }

            abstract class NotifyingNormalFlowFunction
            extends SolverNormalFlowFunction {
                protected final Stmt stmt;

                public NotifyingNormalFlowFunction(Stmt stmt) {
                    this.stmt = stmt;
                }

                @Override
                public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                    if (1 <= InfoflowProblem.this.manager.getConfig().getStopAfterFirstKFlows() && InfoflowProblem.this.manager.getConfig().getStopAfterFirstKFlows() <= InfoflowProblem.this.results.getResults().size()) {
                        return Collections.emptySet();
                    }
                    if (InfoflowProblem.this.taintPropagationHandler != null) {
                        InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(this.stmt, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                    }
                    Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                    return InfoflowProblem.this.notifyOutFlowHandlers(this.stmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                }

                public abstract Set<Abstraction> computeTargetsInternal(Abstraction var1, Abstraction var2);
            }
        };
    }

    @Override
    public boolean autoAddZero() {
        return false;
    }

    public TaintPropagationResults getResults() {
        return this.results;
    }
}

