/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.HashSet;
import soot.ArrayType;
import soot.IntType;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class ArrayPropagationRule
extends AbstractTaintPropagationRule {
    public ArrayPropagationRule(InfoflowManager manager, Aliasing aliasing, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, aliasing, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (!(stmt instanceof AssignStmt)) {
            return null;
        }
        AssignStmt assignStmt = (AssignStmt)stmt;
        Abstraction newAbs = null;
        Value leftVal = assignStmt.getLeftOp();
        Value rightVal = assignStmt.getRightOp();
        if (rightVal instanceof LengthExpr) {
            LengthExpr lengthExpr = (LengthExpr)rightVal;
            if (this.getAliasing().mayAlias(source.getAccessPath().getPlainValue(), lengthExpr.getOp())) {
                if (source.getAccessPath().getArrayTaintType() == AccessPath.ArrayTaintType.Contents) {
                    return null;
                }
                AccessPath ap = AccessPathFactory.v().createAccessPath(leftVal, null, IntType.v(), null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
                newAbs = source.deriveNewAbstraction(ap, assignStmt);
            }
        } else if (rightVal instanceof ArrayRef) {
            Value rightBase = ((ArrayRef)rightVal).getBase();
            Value rightIndex = ((ArrayRef)rightVal).getIndex();
            if (source.getAccessPath().getArrayTaintType() != AccessPath.ArrayTaintType.Length && this.getAliasing().mayAlias(rightBase, (Value)source.getAccessPath().getPlainValue())) {
                Type targetType = source.getAccessPath().getBaseType();
                assert (targetType instanceof ArrayType);
                targetType = ((ArrayType)targetType).getElementType();
                AccessPath.ArrayTaintType arrayTaintType = source.getAccessPath().getArrayTaintType();
                newAbs = source.deriveNewAbstraction(leftVal, false, assignStmt, targetType, arrayTaintType);
            } else if (source.getAccessPath().getArrayTaintType() != AccessPath.ArrayTaintType.Length && rightIndex == source.getAccessPath().getPlainValue() && this.getManager().getConfig().getEnableImplicitFlows()) {
                AccessPath.ArrayTaintType arrayTaintType = AccessPath.ArrayTaintType.ContentsAndLength;
                newAbs = source.deriveNewAbstraction(leftVal, false, assignStmt, null, arrayTaintType);
            }
        } else if (rightVal instanceof NewArrayExpr && this.getManager().getConfig().getEnableArraySizeTainting()) {
            NewArrayExpr newArrayExpr = (NewArrayExpr)rightVal;
            if (this.getAliasing().mayAlias(source.getAccessPath().getPlainValue(), newArrayExpr.getSize())) {
                newAbs = source.deriveNewAbstraction(leftVal, false, assignStmt, null, AccessPath.ArrayTaintType.Length);
            }
        }
        if (newAbs == null) {
            return null;
        }
        HashSet<Abstraction> res = new HashSet<Abstraction>();
        res.add(newAbs);
        if (Aliasing.canHaveAliases(assignStmt, leftVal, newAbs)) {
            this.getAliasing().computeAliases(d1, assignStmt, leftVal, res, (SootMethod)this.getManager().getICFG().getMethodOf(assignStmt), newAbs);
        }
        return res;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }
}

