/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.problems.rules.ArrayPropagationRule;
import soot.jimple.infoflow.problems.rules.ExceptionPropagationRule;
import soot.jimple.infoflow.problems.rules.ITaintPropagationRule;
import soot.jimple.infoflow.problems.rules.ImplicitPropagtionRule;
import soot.jimple.infoflow.problems.rules.SinkPropagationRule;
import soot.jimple.infoflow.problems.rules.SourcePropagationRule;
import soot.jimple.infoflow.problems.rules.StrongUpdatePropagationRule;
import soot.jimple.infoflow.problems.rules.TypingPropagationRule;
import soot.jimple.infoflow.problems.rules.WrapperPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class PropagationRuleManager {
    protected final InfoflowManager manager;
    protected final Aliasing aliasing;
    protected final Abstraction zeroValue;
    protected final TaintPropagationResults results;
    private final ITaintPropagationRule[] rules;

    public PropagationRuleManager(InfoflowManager manager, Aliasing aliasing, Abstraction zeroValue, TaintPropagationResults results) {
        this.manager = manager;
        this.aliasing = aliasing;
        this.zeroValue = zeroValue;
        this.results = results;
        ArrayList<AbstractTaintPropagationRule> ruleList = new ArrayList<AbstractTaintPropagationRule>();
        ruleList.add(new SourcePropagationRule(manager, aliasing, zeroValue, results));
        ruleList.add(new SinkPropagationRule(manager, aliasing, zeroValue, results));
        ruleList.add(new ArrayPropagationRule(manager, aliasing, zeroValue, results));
        if (manager.getConfig().getEnableExceptionTracking()) {
            ruleList.add(new ExceptionPropagationRule(manager, aliasing, zeroValue, results));
        }
        if (manager.getTaintWrapper() != null) {
            ruleList.add(new WrapperPropagationRule(manager, aliasing, zeroValue, results));
        }
        if (manager.getConfig().getEnableImplicitFlows()) {
            ruleList.add(new ImplicitPropagtionRule(manager, aliasing, zeroValue, results));
        }
        ruleList.add(new StrongUpdatePropagationRule(manager, aliasing, zeroValue, results));
        if (manager.getConfig().getEnableTypeChecking()) {
            ruleList.add(new TypingPropagationRule(manager, aliasing, zeroValue, results));
        }
        this.rules = ruleList.toArray(new ITaintPropagationRule[ruleList.size()]);
    }

    public Set<Abstraction> applyNormalFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt) {
        return this.applyNormalFlowFunction(d1, source, stmt, destStmt, null, null);
    }

    public Set<Abstraction> applyNormalFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        HashSet<Abstraction> res = null;
        if (killSource == null) {
            killSource = new ByReferenceBoolean();
        }
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateNormalFlow(d1, source, stmt, destStmt, killSource, killAll);
            if (killAll != null && killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        if (!(killAll != null && killAll.value || killSource.value)) {
            if (res == null) {
                res = new HashSet<Abstraction>();
                res.add(source);
            } else {
                res.add(source);
            }
        }
        return res;
    }

    public Set<Abstraction> applyCallFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        HashSet<Abstraction> res = null;
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateCallFlow(d1, source, stmt, dest, killAll);
            if (killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        return res;
    }

    public Set<Abstraction> applyCallToReturnFlowFunction(Abstraction d1, Abstraction source, Stmt stmt) {
        return this.applyCallToReturnFlowFunction(d1, source, stmt, new ByReferenceBoolean(), null, false);
    }

    public Set<Abstraction> applyCallToReturnFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll, boolean noAddSource) {
        HashSet<Abstraction> res = null;
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateCallToReturnFlow(d1, source, stmt, killSource, killAll);
            if (killAll != null && killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        if (!noAddSource && !killSource.value) {
            if (res == null) {
                res = new HashSet<Abstraction>();
                res.add(source);
            } else {
                res.add(source);
            }
        }
        return res;
    }

    public Set<Abstraction> applyReturnFlowFunction(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        HashSet<Abstraction> res = null;
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateReturnFlow(callerD1s, source, stmt, retSite, callSite, killAll);
            if (killAll != null && killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        return res;
    }
}

