/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class SinkPropagationRule
extends AbstractTaintPropagationRule {
    private boolean killState = false;

    public SinkPropagationRule(InfoflowManager manager, Aliasing aliasing, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, aliasing, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (stmt instanceof ReturnStmt) {
            ReturnStmt returnStmt = (ReturnStmt)stmt;
            this.checkForSink(d1, source, stmt, returnStmt.getOp());
        } else if (stmt instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)stmt;
            this.checkForSink(d1, source, stmt, ifStmt.getCondition());
        } else if (stmt instanceof LookupSwitchStmt) {
            LookupSwitchStmt switchStmt = (LookupSwitchStmt)stmt;
            this.checkForSink(d1, source, stmt, switchStmt.getKey());
        } else if (stmt instanceof TableSwitchStmt) {
            TableSwitchStmt switchStmt = (TableSwitchStmt)stmt;
            this.checkForSink(d1, source, stmt, switchStmt.getKey());
        } else if (stmt instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)stmt;
            this.checkForSink(d1, source, stmt, assignStmt.getRightOp());
        }
        return null;
    }

    private void checkForSink(Abstraction d1, Abstraction source, Stmt stmt, Value retVal) {
        for (Value val : BaseSelector.selectBaseList(retVal, false)) {
            if (this.getManager().getSourceSinkManager() == null || !source.isAbstractionActive() || !this.getAliasing().mayAlias(val, (Value)source.getAccessPath().getPlainValue()) || !this.getManager().getSourceSinkManager().isSink(stmt, this.getManager().getICFG(), source.getAccessPath()) || this.getResults().addResult(new AbstractionAtSink(source, stmt))) continue;
            this.killState = true;
        }
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (source.isAbstractionActive() && !source.getAccessPath().isStaticFieldRef()) {
            InvokeExpr iexpr = stmt.getInvokeExpr();
            boolean found = false;
            for (int i = 0; i < iexpr.getArgCount(); ++i) {
                if (!this.getAliasing().mayAlias(iexpr.getArg(i), (Value)source.getAccessPath().getPlainValue()) || !source.getAccessPath().getTaintSubFields() && !source.getAccessPath().isLocal()) continue;
                found = true;
                break;
            }
            if (!found && iexpr instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)iexpr).getBase() == source.getAccessPath().getPlainValue()) {
                found = true;
            }
            if (found && this.getManager().getSourceSinkManager() != null && this.getManager().getSourceSinkManager().isSink(stmt, this.getManager().getICFG(), source.getAccessPath()) && !this.getResults().addResult(new AbstractionAtSink(source, stmt))) {
                this.killState = true;
            }
        }
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        if (stmt instanceof ReturnStmt) {
            boolean matches;
            ReturnStmt returnStmt = (ReturnStmt)stmt;
            boolean bl = matches = source.getAccessPath().isLocal() || source.getAccessPath().getTaintSubFields();
            if (matches && source.isAbstractionActive() && this.getManager().getSourceSinkManager() != null && this.getAliasing().mayAlias(source.getAccessPath().getPlainValue(), returnStmt.getOp()) && this.getManager().getSourceSinkManager().isSink(returnStmt, this.getManager().getICFG(), source.getAccessPath()) && !this.getResults().addResult(new AbstractionAtSink(source, returnStmt))) {
                this.killState = true;
            }
        }
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }
}

