/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.HashSet;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.source.SourceInfo;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.TypeUtils;

public class SourcePropagationRule
extends AbstractTaintPropagationRule {
    public SourcePropagationRule(InfoflowManager manager, Aliasing aliasing, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, aliasing, zeroValue, results);
    }

    private Collection<Abstraction> propagate(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (source == this.getZeroValue()) {
            SourceInfo sourceInfo = this.getManager().getSourceSinkManager() != null ? this.getManager().getSourceSinkManager().getSourceInfo(stmt, this.getManager().getICFG()) : null;
            killSource.value = true;
            if (sourceInfo != null && !sourceInfo.getAccessPaths().isEmpty()) {
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                for (AccessPath ap : sourceInfo.getAccessPaths()) {
                    Abstraction abs = new Abstraction(ap, stmt, sourceInfo.getUserData(), false, false);
                    res.add(abs);
                    for (ValueBox vb : stmt.getUseAndDefBoxes()) {
                        if (!ap.startsWith(vb.getValue()) || TypeUtils.isStringType(vb.getValue().getType()) && !ap.getCanHaveImmutableAliases()) continue;
                        this.getAliasing().computeAliases(d1, stmt, vb.getValue(), res, (SootMethod)this.getManager().getICFG().getMethodOf(stmt), abs);
                    }
                    if (!stmt.containsInvokeExpr()) continue;
                    abs.setCorrespondingCallSite(stmt);
                }
                return res;
            }
            if (killAll != null) {
                killAll.value = true;
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return this.propagate(d1, source, stmt, killSource, killAll);
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return this.propagate(d1, source, stmt, killSource, null);
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        boolean isSink;
        SourceInfo sourceInfo;
        if (!this.getManager().getConfig().getInspectSources() && this.getManager().getSourceSinkManager() != null && (sourceInfo = this.getManager().getSourceSinkManager().getSourceInfo(stmt, this.getManager().getICFG())) != null) {
            killAll.value = true;
        }
        if (!this.getManager().getConfig().getInspectSinks() && this.getManager().getSourceSinkManager() != null && (isSink = this.getManager().getSourceSinkManager().isSink(stmt, this.getManager().getICFG(), source.getAccessPath()))) {
            killAll.value = true;
        }
        return null;
    }
}

