/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.RefType;
import soot.SootMethod;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.source.SourceInfo;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.TypeUtils;

public class WrapperPropagationRule
extends AbstractTaintPropagationRule {
    public WrapperPropagationRule(InfoflowManager manager, Aliasing aliasing, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, aliasing, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    private Set<Abstraction> computeWrapperTaints(Abstraction d1, Stmt iStmt, Abstraction source) {
        Set<Abstraction> res;
        if (source == this.getZeroValue()) {
            return null;
        }
        if (this.getManager().getTaintWrapper() == null) {
            return null;
        }
        if (!source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isEmpty()) {
            boolean found = false;
            if (iStmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiExpr = (InstanceInvokeExpr)iStmt.getInvokeExpr();
                found = this.getAliasing().mayAlias(iiExpr.getBase(), (Value)source.getAccessPath().getPlainValue());
            }
            if (!found) {
                for (int paramIdx = 0; paramIdx < iStmt.getInvokeExpr().getArgCount(); ++paramIdx) {
                    if (!this.getAliasing().mayAlias(source.getAccessPath().getPlainValue(), iStmt.getInvokeExpr().getArg(paramIdx))) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return null;
            }
        }
        if (!this.getManager().getConfig().getInspectSources()) {
            SourceInfo sourceInfo;
            SourceInfo sourceInfo2 = sourceInfo = this.getManager().getSourceSinkManager() != null ? this.getManager().getSourceSinkManager().getSourceInfo(iStmt, this.getManager().getICFG()) : null;
            if (sourceInfo != null) {
                return null;
            }
        }
        if ((res = this.getManager().getTaintWrapper().getTaintsForMethod(iStmt, d1, source)) != null) {
            HashSet<Abstraction> resWithAliases = new HashSet<Abstraction>(res);
            for (Abstraction abs : res) {
                if (abs.equals(source)) continue;
                AccessPath val = abs.getAccessPath();
                boolean taintsObjectValue = val.getBaseType() instanceof RefType && abs.getAccessPath().getBaseType() instanceof RefType && (!TypeUtils.isStringType(val.getBaseType()) || val.getCanHaveImmutableAliases());
                boolean taintsStaticField = this.getManager().getConfig().getEnableStaticFieldTracking() && abs.getAccessPath().isStaticFieldRef();
                boolean taintedValueOverwritten = iStmt instanceof DefinitionStmt ? Aliasing.baseMatches(((DefinitionStmt)iStmt).getLeftOp(), abs) : false;
                if (taintedValueOverwritten || !taintsStaticField && (!taintsObjectValue || !abs.getAccessPath().getTaintSubFields()) && !Aliasing.canHaveAliases(iStmt, val.getPlainValue(), abs)) continue;
                this.getAliasing().computeAliases(d1, iStmt, val.getPlainValue(), resWithAliases, (SootMethod)this.getManager().getICFG().getMethodOf(iStmt), abs);
            }
            res = resWithAliases;
        }
        return res;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        Set<Abstraction> wrapperTaints = this.computeWrapperTaints(d1, stmt, source);
        if (wrapperTaints != null) {
            for (Abstraction wrapperAbs : wrapperTaints) {
                if (!wrapperAbs.getAccessPath().equals(source.getAccessPath())) continue;
                killSource.value = true;
                break;
            }
        }
        return wrapperTaints;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (this.getManager().getTaintWrapper() != null && this.getManager().getTaintWrapper().isExclusive(stmt, source)) {
            killAll.value = true;
        }
        return null;
    }
}

