/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import heros.solver.Pair;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class InfoflowResults {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MultiMap<ResultSinkInfo, ResultSourceInfo> results = new ConcurrentHashMultiMap<ResultSinkInfo, ResultSourceInfo>();

    public int size() {
        return this.results == null ? 0 : this.results.size();
    }

    public int numConnections() {
        int num = 0;
        if (this.results != null) {
            for (ResultSinkInfo sink : this.results.keySet()) {
                num += this.results.get(sink).size();
            }
        }
        return num;
    }

    public boolean isEmpty() {
        return this.results == null || this.results.isEmpty();
    }

    public boolean containsSink(Stmt sink) {
        for (ResultSinkInfo si : this.results.keySet()) {
            if (!si.getSink().equals(sink)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSinkMethod(String sinkSignature) {
        return !this.findSinkByMethodSignature(sinkSignature).isEmpty();
    }

    public void addResult(AccessPath sink, Stmt sinkStmt, AccessPath source, Stmt sourceStmt) {
        this.addResult(new ResultSinkInfo(sink, sinkStmt), new ResultSourceInfo(source, sourceStmt));
    }

    public Pair<ResultSourceInfo, ResultSinkInfo> addResult(AccessPath sink, Stmt sinkStmt, AccessPath source, Stmt sourceStmt, Object userData, List<Abstraction> propagationPath) {
        ArrayList<Stmt> stmtPath = null;
        ArrayList<AccessPath> apPath = null;
        if (propagationPath != null) {
            stmtPath = new ArrayList<Stmt>(propagationPath.size());
            apPath = new ArrayList<AccessPath>(propagationPath.size());
            for (Abstraction pathAbs : propagationPath) {
                if (pathAbs.getCurrentStmt() == null) continue;
                stmtPath.add(pathAbs.getCurrentStmt());
                apPath.add(pathAbs.getAccessPath());
            }
        }
        return this.addResult(sink, sinkStmt, source, sourceStmt, userData, stmtPath, apPath);
    }

    public Pair<ResultSourceInfo, ResultSinkInfo> addResult(AccessPath sink, Stmt sinkStmt, AccessPath source, Stmt sourceStmt, Object userData, List<Stmt> propagationPath, List<AccessPath> propagationAccessPath) {
        ResultSourceInfo sourceObj = new ResultSourceInfo(source, sourceStmt, userData, propagationPath, propagationAccessPath);
        ResultSinkInfo sinkObj = new ResultSinkInfo(sink, sinkStmt);
        this.addResult(sinkObj, sourceObj);
        return new Pair<ResultSourceInfo, ResultSinkInfo>(sourceObj, sinkObj);
    }

    public void addResult(ResultSinkInfo sink, ResultSourceInfo source) {
        this.results.put(sink, source);
    }

    public void addAll(InfoflowResults results) {
        if (results == null || results.isEmpty()) {
            return;
        }
        for (ResultSinkInfo sink : results.getResults().keySet()) {
            for (ResultSourceInfo source : results.getResults().get(sink)) {
                this.addResult(sink, source);
            }
        }
    }

    public MultiMap<ResultSinkInfo, ResultSourceInfo> getResults() {
        return this.results;
    }

    public boolean isPathBetween(Stmt sink, Stmt source) {
        Set<ResultSourceInfo> sources = null;
        for (ResultSinkInfo sI : this.results.keySet()) {
            if (!sI.getSink().equals(sink)) continue;
            sources = this.results.get(sI);
            break;
        }
        if (sources == null) {
            return false;
        }
        for (ResultSourceInfo src : sources) {
            if (!src.getAccessPath().equals(source)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathBetween(String sink, String source) {
        for (ResultSinkInfo si : this.results.keySet()) {
            if (!si.getAccessPath().getPlainValue().toString().equals(sink)) continue;
            Set<ResultSourceInfo> sources = this.results.get(si);
            for (ResultSourceInfo src : sources) {
                if (!src.getSource().toString().contains(source)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPathBetweenMethods(String sinkSignature, String sourceSignature) {
        List<ResultSinkInfo> sinkVals = this.findSinkByMethodSignature(sinkSignature);
        for (ResultSinkInfo si : sinkVals) {
            Set<ResultSourceInfo> sources = this.results.get(si);
            if (sources == null) {
                return false;
            }
            for (ResultSourceInfo src : sources) {
                InvokeExpr expr;
                if (!src.getSource().containsInvokeExpr() || !(expr = src.getSource().getInvokeExpr()).getMethod().getSignature().equals(sourceSignature)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ResultSinkInfo> findSinkByMethodSignature(String sinkSignature) {
        ArrayList<ResultSinkInfo> sinkVals = new ArrayList<ResultSinkInfo>();
        for (ResultSinkInfo si : this.results.keySet()) {
            InvokeExpr expr;
            if (!si.getSink().containsInvokeExpr() || !(expr = si.getSink().getInvokeExpr()).getMethod().getSignature().equals(sinkSignature)) continue;
            sinkVals.add(si);
        }
        return sinkVals;
    }

    public void printResults() {
        for (ResultSinkInfo sink : this.results.keySet()) {
            this.logger.info("Found a flow to sink {}, from the following sources:", (Object)sink);
            for (ResultSourceInfo source : this.results.get(sink)) {
                this.logger.info("\t- {}", (Object)source.getSource());
                if (source.getPath() == null) continue;
                this.logger.info("\t\ton Path {}", (Object)Arrays.toString(source.getPath()));
            }
        }
    }

    public void printResults(Writer wr) throws IOException {
        for (ResultSinkInfo sink : this.results.keySet()) {
            wr.write("Found a flow to sink " + sink + ", from the following sources:\n");
            for (ResultSourceInfo source : this.results.get(sink)) {
                wr.write("\t- " + source.getSource() + "\n");
                if (source.getPath() == null) continue;
                wr.write("\t\ton Path " + Arrays.toString(source.getPath()) + "\n");
            }
        }
    }

    public void clear() {
        this.results.clear();
    }

    public String toString() {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (ResultSinkInfo sink : this.results.keySet()) {
            for (ResultSourceInfo source : this.results.get(sink)) {
                if (!isFirst) {
                    sb.append(", ");
                }
                isFirst = false;
                sb.append(source);
                sb.append(" -> ");
                sb.append(sink);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfoflowResults other = (InfoflowResults)obj;
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }
}

