/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results.xml;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class InfoflowResultsSerializer {
    public static final int FILE_FORMAT_VERSION = 100;
    private boolean serializeTaintPath = false;
    private final IInfoflowCFG icfg;

    public InfoflowResultsSerializer() {
        this(null);
    }

    public InfoflowResultsSerializer(IInfoflowCFG cfg) {
        this.icfg = cfg;
    }

    public void serialize(InfoflowResults results, String fileName) throws FileNotFoundException, XMLStreamException {
        FileOutputStream out = new FileOutputStream(fileName);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out);
        writer.writeStartDocument();
        writer.writeStartElement("DataFlowResults");
        writer.writeAttribute("FileFormatVersion", "100");
        writer.writeStartElement("Results");
        this.writeDataFlows(results, writer);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
    }

    private void writeDataFlows(InfoflowResults results, XMLStreamWriter writer) throws XMLStreamException {
        for (ResultSinkInfo sink : results.getResults().keySet()) {
            writer.writeStartElement("Result");
            this.writeSinkInfo(sink, writer);
            writer.writeStartElement("Sources");
            for (ResultSourceInfo src : results.getResults().get(sink)) {
                this.writeSourceInfo(src, writer);
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeSourceInfo(ResultSourceInfo source, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("Source");
        writer.writeAttribute("Statement", source.getSource().toString());
        if (this.icfg != null) {
            writer.writeAttribute("Method", ((SootMethod)this.icfg.getMethodOf(source.getSource())).getSignature());
        }
        this.writeAccessPath(source.getAccessPath(), writer);
        if (this.serializeTaintPath && source.getPath() != null) {
            writer.writeStartElement("TaintPath");
            for (int i = 0; i < source.getPath().length; ++i) {
                writer.writeStartElement("PathElement");
                Stmt curStmt = source.getPath()[i];
                writer.writeAttribute("Statement", curStmt.toString());
                if (this.icfg != null) {
                    writer.writeAttribute("Method", ((SootMethod)this.icfg.getMethodOf(curStmt)).getSignature());
                }
                AccessPath curAP = source.getPathAccessPaths()[i];
                this.writeAccessPath(curAP, writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeSinkInfo(ResultSinkInfo sink, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("Sink");
        writer.writeAttribute("Statement", sink.getSink().toString());
        if (this.icfg != null) {
            writer.writeAttribute("Method", ((SootMethod)this.icfg.getMethodOf(sink.getSink())).getSignature());
        }
        this.writeAccessPath(sink.getAccessPath(), writer);
        writer.writeEndElement();
    }

    private void writeAccessPath(AccessPath accessPath, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("AccessPath");
        if (accessPath.getPlainValue() != null) {
            writer.writeAttribute("Value", accessPath.getPlainValue().toString());
        }
        if (accessPath.getBaseType() != null) {
            writer.writeAttribute("Type", accessPath.getBaseType().toString());
        }
        writer.writeAttribute("TaintSubFields", accessPath.getTaintSubFields() ? "true" : "false");
        if (accessPath.getFieldCount() > 0) {
            writer.writeStartElement("Fields");
            for (int i = 0; i < accessPath.getFieldCount(); ++i) {
                writer.writeStartElement("Field");
                writer.writeAttribute("Value", accessPath.getFields()[i].toString());
                writer.writeAttribute("Type", accessPath.getFieldTypes()[i].toString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void setSerializeTaintPath(boolean serialize) {
        this.serializeTaintPath = serialize;
    }
}

