/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.rifl;

import java.util.ArrayList;
import java.util.List;

public class RIFLDocument {
    private InterfaceSpec interfaceSpec = new InterfaceSpec();
    private List<DomainSpec> domains = new ArrayList<DomainSpec>();
    private List<DomainAssignment> domainAssignment = new ArrayList<DomainAssignment>();
    private List<FlowPair> flowPolicy = new ArrayList<FlowPair>();

    public InterfaceSpec getInterfaceSpec() {
        return this.interfaceSpec;
    }

    public List<DomainSpec> getDomains() {
        return this.domains;
    }

    public DomainSpec getDomainByName(String domainName) {
        for (DomainSpec ds : this.domains) {
            if (!ds.getName().equals(domainName)) continue;
            return ds;
        }
        return null;
    }

    public List<DomainAssignment> getDomainAssignment() {
        return this.domainAssignment;
    }

    public List<FlowPair> getFlowPolicy() {
        return this.flowPolicy;
    }

    public static String getRIFLSpecVersion() {
        return "1.0";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interfaceSpec == null ? 0 : this.interfaceSpec.hashCode());
        result = 31 * result + (this.domainAssignment == null ? 0 : this.domainAssignment.hashCode());
        result = 31 * result + (this.domains == null ? 0 : this.domains.hashCode());
        result = 31 * result + (this.flowPolicy == null ? 0 : this.flowPolicy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RIFLDocument)) {
            return false;
        }
        RIFLDocument other = (RIFLDocument)obj;
        return this.interfaceSpec.equals(other.interfaceSpec) && this.domainAssignment.equals(other.domainAssignment) && this.domains.equals(other.domains) && this.flowPolicy.equals(other.flowPolicy);
    }

    public class FlowPair {
        private final DomainSpec firstDomain;
        private final DomainSpec secondDomain;

        public FlowPair(DomainSpec firstDomain, DomainSpec secondDomain) {
            this.firstDomain = firstDomain;
            this.secondDomain = secondDomain;
        }

        public DomainSpec getFirstDomain() {
            return this.firstDomain;
        }

        public DomainSpec getSecondDomain() {
            return this.secondDomain;
        }

        public int hashCode() {
            return 31 * this.firstDomain.hashCode() + 31 * this.secondDomain.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof FlowPair)) {
                return false;
            }
            FlowPair otherPair = (FlowPair)other;
            return this.firstDomain.equals(otherPair.firstDomain) && this.secondDomain.equals(otherPair.secondDomain);
        }
    }

    public class DomainAssignment {
        private final Assignable sourceOrSink;
        private final DomainSpec domain;

        public DomainAssignment(Assignable sourceOrSink, DomainSpec domain) {
            this.sourceOrSink = sourceOrSink;
            this.domain = domain;
        }

        public Assignable getSourceOrSink() {
            return this.sourceOrSink;
        }

        public DomainSpec getDomain() {
            return this.domain;
        }

        public int hashCode() {
            return 31 * this.sourceOrSink.hashCode() + 31 * this.domain.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof DomainAssignment)) {
                return false;
            }
            DomainAssignment otherPair = (DomainAssignment)other;
            return this.sourceOrSink.equals(otherPair.sourceOrSink) && this.domain.equals(otherPair.domain);
        }
    }

    public class Category
    extends SourceSinkSpec {
        private final String name;
        private final List<SourceSinkSpec> elements;

        public Category(String name) {
            super(SourceSinkType.Category);
            this.elements = new ArrayList<SourceSinkSpec>();
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<SourceSinkSpec> getElements() {
            return this.elements;
        }

        @Override
        public int hashCode() {
            return 31 * this.name.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof Category)) {
                return false;
            }
            Category otherSpec = (Category)other;
            return this.name.equals(otherSpec.name);
        }
    }

    public class DomainSpec {
        private final String name;

        public DomainSpec(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public class JavaFieldSpec
    extends JavaSourceSinkSpec {
        private final String fieldName;

        public JavaFieldSpec(SourceSinkType type, String className, String fieldName) {
            super(type, className);
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public int hashCode() {
            return 31 * this.fieldName.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof JavaFieldSpec)) {
                return false;
            }
            JavaFieldSpec otherSpec = (JavaFieldSpec)other;
            return this.fieldName.equals(otherSpec.fieldName);
        }
    }

    public class JavaReturnValueSpec
    extends JavaMethodSourceSinkSpec {
        public JavaReturnValueSpec(SourceSinkType type, String className, String halfSignature) {
            super(type, className, halfSignature);
        }
    }

    public class JavaParameterSpec
    extends JavaMethodSourceSinkSpec {
        private final int paramIdx;

        public JavaParameterSpec(SourceSinkType type, String className, String halfSignature, int paramIdx) {
            super(type, className, halfSignature);
            this.paramIdx = paramIdx;
        }

        public int getParamIdx() {
            return this.paramIdx;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.paramIdx;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaParameterSpec other = (JavaParameterSpec)obj;
            return this.paramIdx == other.paramIdx;
        }
    }

    public abstract class JavaMethodSourceSinkSpec
    extends JavaSourceSinkSpec {
        private final String halfSignature;

        public JavaMethodSourceSinkSpec(SourceSinkType type, String className, String halfSignature) {
            super(type, className);
            this.halfSignature = halfSignature;
        }

        public String getHalfSignature() {
            return this.halfSignature;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.halfSignature == null ? 0 : this.halfSignature.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaMethodSourceSinkSpec other = (JavaMethodSourceSinkSpec)obj;
            return !(this.halfSignature == null ? other.halfSignature != null : !this.halfSignature.equals(other.halfSignature));
        }
    }

    public abstract class JavaSourceSinkSpec
    extends SourceSinkSpec {
        private final String className;

        public JavaSourceSinkSpec(SourceSinkType type, String className) {
            super(type);
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaSourceSinkSpec other = (JavaSourceSinkSpec)obj;
            return !(this.className == null ? other.className != null : !this.className.equals(other.className));
        }
    }

    public abstract class SourceSinkSpec {
        protected final SourceSinkType type;

        public SourceSinkSpec(SourceSinkType type) {
            this.type = type;
        }

        public SourceSinkType getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceSinkSpec other = (SourceSinkSpec)obj;
            return this.type == other.type;
        }
    }

    public static enum SourceSinkType {
        Category,
        Source,
        Sink;

    }

    public class InterfaceSpec {
        private final List<Assignable> sourcesSinks = new ArrayList<Assignable>();

        public List<Assignable> getSourcesSinks() {
            return this.sourcesSinks;
        }

        public Assignable getElementByHandle(String handle) {
            for (Assignable assign : this.sourcesSinks) {
                if (!assign.getHandle().equals(handle)) continue;
                return assign;
            }
            return null;
        }

        public int hashCode() {
            return 31 * this.sourcesSinks.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof InterfaceSpec)) {
                return false;
            }
            InterfaceSpec otherIO = (InterfaceSpec)other;
            return this.sourcesSinks.equals(otherIO.sourcesSinks);
        }
    }

    public class Assignable {
        private final String handle;
        private final SourceSinkSpec element;

        public Assignable(String handle, SourceSinkSpec element) {
            this.handle = handle;
            this.element = element;
        }

        public String getHandle() {
            return this.handle;
        }

        public SourceSinkSpec getElement() {
            return this.element;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.handle == null ? 0 : this.handle.hashCode());
            result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Assignable other = (Assignable)obj;
            if (this.handle == null ? other.handle != null : !this.handle.equals(other.handle)) {
                return false;
            }
            return !(this.element == null ? other.element != null : !this.element.equals(other.element));
        }
    }
}

